/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.hops.HopsException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;

public class OutputParameters {
    private boolean _blocked = true;
    private long _num_rows = -1L;
    private long _num_cols = -1L;
    private long _nnz = -1L;
    private MatrixObject.UpdateType _updateType = MatrixObject.UpdateType.COPY;
    private long _num_rows_in_block = -1L;
    private long _num_cols_in_block = -1L;
    private String _file_name = null;
    private String _file_label = null;
    Format matrix_format = Format.BINARY;

    public String getFile_name() {
        return this._file_name;
    }

    public void setFile_name(String fileName) {
        this._file_name = fileName;
    }

    public String getLabel() {
        return this._file_label;
    }

    public void setLabel(String label) {
        this._file_label = label;
    }

    public void setDimensions(long rows, long cols, long rows_per_block, long cols_per_block, long nnz) throws HopsException {
        this._num_rows = rows;
        this._num_cols = cols;
        this._nnz = nnz;
        this._num_rows_in_block = rows_per_block;
        this._num_cols_in_block = cols_per_block;
        if (this._num_rows_in_block == 0L && this._num_cols_in_block == 0L) {
            this._blocked = false;
        } else if (this._num_rows_in_block == -1L && this._num_cols_in_block == -1L) {
            this._blocked = false;
        } else if (this._num_rows_in_block > 0L && this._num_cols_in_block > 0L) {
            this._blocked = true;
        } else {
            throw new HopsException("In OutputParameters Lop, Invalid values for blocking dimensions: [" + this._num_rows_in_block + "," + this._num_cols_in_block + "].");
        }
    }

    public void setDimensions(long rows, long cols, long rows_per_block, long cols_per_block, long nnz, MatrixObject.UpdateType update) throws HopsException {
        this._updateType = update;
        this.setDimensions(rows, cols, rows_per_block, cols_per_block, nnz);
    }

    public Format getFormat() {
        return this.matrix_format;
    }

    public void setFormat(Format fmt) {
        this.matrix_format = fmt;
    }

    public boolean isBlocked() {
        return this._blocked;
    }

    public void setBlocked(boolean blocked) {
        this._blocked = blocked;
    }

    public long getNumRows() {
        return this._num_rows;
    }

    public void setNumRows(long rows) {
        this._num_rows = rows;
    }

    public long getNumCols() {
        return this._num_cols;
    }

    public void setNumCols(long cols) {
        this._num_cols = cols;
    }

    public Long getNnz() {
        return this._nnz;
    }

    public void setNnz(long nnz) {
        this._nnz = nnz;
    }

    public MatrixObject.UpdateType getUpdateType() {
        return this._updateType;
    }

    public void setUpdateType(MatrixObject.UpdateType update) {
        this._updateType = update;
    }

    public long getRowsInBlock() {
        return this._num_rows_in_block;
    }

    public void setRowsInBlock(long rows_in_block) {
        this._num_rows_in_block = rows_in_block;
    }

    public long getColsInBlock() {
        return this._num_cols_in_block;
    }

    public void setColsInBlock(long cols_in_block) {
        this._num_cols_in_block = cols_in_block;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("rows=" + this.getNumRows() + "\u00b7");
        sb.append("cols=" + this.getNumCols() + "\u00b7");
        sb.append("nnz=" + this.getNnz() + "\u00b7");
        sb.append("updateInPlace=" + this.getUpdateType().toString() + "\u00b7");
        sb.append("rowsInBlock=" + this.getRowsInBlock() + "\u00b7");
        sb.append("colsInBlock=" + this.getColsInBlock() + "\u00b7");
        sb.append("isBlockedRepresentation=" + this.isBlocked() + "\u00b7");
        sb.append("format=" + (Object)((Object)this.getFormat()) + "\u00b7");
        sb.append("label=" + this.getLabel() + "\u00b7");
        sb.append("filename=" + this.getFile_name());
        return sb.toString();
    }

    public static enum Format {
        TEXT,
        BINARY,
        MM,
        CSV;

    }
}

