/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import java.util.ArrayList;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.Expression;

public class FunctionCallCP
extends Lop {
    private String _fnamespace;
    private String _fname;
    private String[] _outputs;
    private ArrayList<Lop> _outputLops = null;

    public FunctionCallCP(ArrayList<Lop> inputs, String fnamespace, String fname, String[] outputs, ArrayList<Hop> outputHops, LopProperties.ExecType et) throws HopsException, LopsException {
        this(inputs, fnamespace, fname, outputs, et);
        if (outputHops != null) {
            this._outputLops = new ArrayList();
            for (Hop h : outputHops) {
                this._outputLops.add(h.constructLops());
            }
        }
    }

    public FunctionCallCP(ArrayList<Lop> inputs, String fnamespace, String fname, String[] outputs, LopProperties.ExecType et) {
        super(Lop.Type.FunctionCallCP, Expression.DataType.UNKNOWN, Expression.ValueType.UNKNOWN);
        this._fnamespace = fnamespace;
        this._fname = fname;
        this._outputs = outputs;
        for (Lop in : inputs) {
            this.addInput(in);
            in.addOutput(this);
        }
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        this.lps.addCompatibility(JobType.INVALID);
        this.lps.setProperties(inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
    }

    public ArrayList<Lop> getFunctionOutputs() {
        return this._outputLops;
    }

    @Override
    public String toString() {
        return "function call: " + DMLProgram.constructFunctionKey(this._fnamespace, this._fname);
    }

    private String getInstructionsMultipleReturnBuiltins(String[] inputs, String[] outputs) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this._fname.toLowerCase());
        for (i = 0; i < inputs.length; ++i) {
            sb.append("\u00b0");
            sb.append(this.getInputs().get(i).prepInputOperand(inputs[i]));
        }
        for (i = 0; i < this._outputs.length; ++i) {
            sb.append("\u00b0");
            sb.append(this._outputs[i]);
        }
        return sb.toString();
    }

    @Override
    public String getInstructions(String[] inputs, String[] outputs) throws LopsException {
        if (this._fnamespace.equalsIgnoreCase("_internal")) {
            return this.getInstructionsMultipleReturnBuiltins(inputs, outputs);
        }
        StringBuilder inst = new StringBuilder();
        inst.append((Object)this.getExecType());
        inst.append("\u00b0");
        inst.append("extfunct");
        inst.append("\u00b0");
        inst.append(this._fnamespace);
        inst.append("\u00b0");
        inst.append(this._fname);
        inst.append("\u00b0");
        inst.append(inputs.length);
        inst.append("\u00b0");
        inst.append(this._outputs.length);
        for (int i = 0; i < inputs.length; ++i) {
            inst.append("\u00b0");
            inst.append(this.getInputs().get(i).prepInputOperand(inputs[i]));
        }
        for (String out : this._outputs) {
            inst.append("\u00b0");
            inst.append(out);
        }
        return inst.toString();
    }
}

