/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import java.util.HashMap;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.OutputParameters;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class Data
extends Lop {
    Hop.FileFormatTypes formatType = Hop.FileFormatTypes.BINARY;
    OperationTypes operation;
    boolean literal_var = false;
    boolean transient_var = false;
    private HashMap<String, Lop> _inputParams;

    public static Data createLiteralLop(Expression.ValueType vt, String literalValue) throws LopsException {
        return new Data(OperationTypes.READ, null, null, null, literalValue, Expression.DataType.SCALAR, vt, false, Hop.FileFormatTypes.BINARY);
    }

    public Data(OperationTypes op, Lop input, HashMap<String, Lop> inputParametersLops, String name, String literal, Expression.DataType dt, Expression.ValueType vt, boolean isTransient, Hop.FileFormatTypes fmt) throws LopsException {
        super(Lop.Type.Data, dt, vt);
        this.operation = op;
        this.transient_var = isTransient;
        if (literal != null) {
            if (this.transient_var) {
                throw new LopsException("Invalid parameter values while setting up a Data LOP -- transient flag is invalid for a literal.");
            }
            this.literal_var = true;
            this.getOutputParameters().setLabel(literal);
        } else if (name != null) {
            if (this.transient_var) {
                this.getOutputParameters().setLabel(name);
            } else {
                this.getOutputParameters().setLabel("p" + (Object)((Object)op) + name);
            }
        } else {
            throw new LopsException("Invalid parameter values while setting up a Data LOP -- the lop must have either literal value or a name.");
        }
        if (input != null && this.operation == OperationTypes.WRITE) {
            this.addInput(input);
            input.addOutput(this);
        }
        this._inputParams = inputParametersLops;
        if (this._inputParams != null) {
            for (Lop lop : inputParametersLops.values()) {
                this.addInput(lop);
                lop.addOutput(this);
            }
            if (inputParametersLops.get("iofilename") != null && inputParametersLops.get("iofilename") instanceof Data) {
                OutputParameters outParams = ((Data)inputParametersLops.get("iofilename")).getOutputParameters();
                String fName = outParams.getLabel();
                this.getOutputParameters().setFile_name(fName);
            }
        }
        this.setFileFormatAndProperties(fmt);
    }

    private void setLopProperties() {
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        if (this.getFileFormatType() == Hop.FileFormatTypes.CSV) {
            this.lps.addCompatibility(JobType.CSV_WRITE);
            definesMRJob = true;
        } else {
            this.lps.addCompatibility(JobType.ANY);
            if (this.operation == OperationTypes.READ) {
                this.lps.removeCompatibility(JobType.DATAGEN);
            } else if (this.operation == OperationTypes.WRITE) {
                this.lps.removeCompatibility(JobType.MMCJ);
                if (this.getDataType() == Expression.DataType.MATRIX && this.formatType != Hop.FileFormatTypes.BINARY) {
                    this.lps.removeCompatibility(JobType.SORT);
                }
                this.lps.removeCompatibility(JobType.COMBINE);
            }
        }
        this.lps.setProperties(this.inputs, LopProperties.ExecType.INVALID, LopProperties.ExecLocation.Data, breaksAlignment, aligner, definesMRJob);
    }

    public void setExecType(LopProperties.ExecType et) {
        this.lps.execType = et;
    }

    public void setFileFormatAndProperties(Hop.FileFormatTypes type) throws LopsException {
        this.formatType = type;
        if (type == Hop.FileFormatTypes.BINARY) {
            this.outParams.setFormat(OutputParameters.Format.BINARY);
        } else if (type == Hop.FileFormatTypes.TEXT) {
            this.outParams.setFormat(OutputParameters.Format.TEXT);
        } else if (type == Hop.FileFormatTypes.MM) {
            this.outParams.setFormat(OutputParameters.Format.MM);
        } else if (type == Hop.FileFormatTypes.CSV) {
            this.outParams.setFormat(OutputParameters.Format.CSV);
        } else {
            throw new LopsException("Unexpected format: " + (Object)((Object)type));
        }
        this.setLopProperties();
    }

    public Hop.FileFormatTypes getFileFormatType() {
        return this.formatType;
    }

    @Override
    public String toString() {
        return this.getID() + ":File_Name: " + this.getOutputParameters().getFile_name() + " Label: " + this.getOutputParameters().getLabel() + " Operation: = " + (Object)((Object)this.operation) + " Format: " + (Object)((Object)this.outParams.getFormat()) + " Datatype: " + (Object)((Object)this.getDataType()) + " Valuetype: " + (Object)((Object)this.getValueType()) + " num_rows = " + this.getOutputParameters().getNumRows() + " num_cols = " + this.getOutputParameters().getNumCols() + " UpdateInPlace: " + (Object)((Object)this.getOutputParameters().getUpdateType());
    }

    public OperationTypes getOperationType() {
        return this.operation;
    }

    public HashMap<String, Lop> getInputParams() {
        return this._inputParams;
    }

    public Lop getNamedInputLop(String name) {
        return this._inputParams.get(name);
    }

    public Lop getNamedInputLop(String name, String defaultVal) throws LopsException {
        if (this._inputParams.containsKey(name)) {
            return this._inputParams.get(name);
        }
        return Data.createLiteralLop(Expression.ValueType.STRING, defaultVal);
    }

    public boolean isLiteral() {
        return this.literal_var;
    }

    public boolean getBooleanValue() throws LopsException {
        if (this.literal_var) {
            return Boolean.parseBoolean(this.getOutputParameters().getLabel());
        }
        throw new LopsException("Cannot obtain the value of a non-literal variable at compile time.");
    }

    public double getDoubleValue() throws LopsException {
        if (this.literal_var) {
            return Double.parseDouble(this.getOutputParameters().getLabel());
        }
        throw new LopsException("Cannot obtain the value of a non-literal variable at compile time.");
    }

    public long getLongValue() throws LopsException {
        if (this.literal_var) {
            Expression.ValueType vt = this.getValueType();
            switch (vt) {
                case INT: {
                    return Long.parseLong(this.getOutputParameters().getLabel());
                }
                case DOUBLE: {
                    return (long)Double.parseDouble(this.getOutputParameters().getLabel());
                }
            }
            throw new LopsException("Encountered a non-numeric value " + (Object)((Object)vt) + ", while a numeric value is expected.");
        }
        throw new LopsException("Can not obtain the value of a non-literal variable at compile time.");
    }

    public String getStringValue() throws LopsException {
        if (this.literal_var) {
            return this.getOutputParameters().getLabel();
        }
        throw new LopsException("Cannot obtain the value of a non-literal variable at compile time.");
    }

    public boolean isTransient() {
        return this.transient_var;
    }

    public boolean isPersistentWrite() {
        return this.operation == OperationTypes.WRITE && !this.transient_var;
    }

    @Override
    public String getInstructions(int input_index, int output_index) throws LopsException {
        Data sparseLop;
        Data delimLop;
        Data headerLop;
        OutputParameters oparams = this.getOutputParameters();
        if (this.operation != OperationTypes.WRITE) {
            throw new LopsException("This method should only be executed for generating MR Write instructions.");
        }
        if (oparams.getFormat() != OutputParameters.Format.CSV) {
            throw new LopsException("MR Write instructions can not be generated for the output format: " + (Object)((Object)oparams.getFormat()));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("MR");
        sb.append("\u00b0");
        if (oparams.getFormat() != OutputParameters.Format.CSV) {
            throw new LopsException("MR Write instructions can not be generated for the output format: " + (Object)((Object)oparams.getFormat()));
        }
        sb.append("csvwrite");
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input_index));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output_index));
        if (oparams.getFormat() == OutputParameters.Format.CSV) {
            headerLop = (Data)this.getNamedInputLop("header");
            delimLop = (Data)this.getNamedInputLop("sep");
            sparseLop = (Data)this.getNamedInputLop("sparse");
            if (headerLop.isVariable()) {
                throw new LopsException(this.printErrorLocation() + "Parameter " + "header" + " must be a literal.");
            }
            if (delimLop.isVariable()) {
                throw new LopsException(this.printErrorLocation() + "Parameter " + "sep" + " must be a literal.");
            }
            if (sparseLop.isVariable()) {
                throw new LopsException(this.printErrorLocation() + "Parameter " + "sparse" + " must be a literal.");
            }
        } else {
            throw new LopsException("MR Write instructions can not be generated for the output format: " + (Object)((Object)oparams.getFormat()));
        }
        sb.append("\u00b0");
        sb.append(headerLop.getBooleanValue());
        sb.append("\u00b0");
        sb.append(delimLop.getStringValue());
        sb.append("\u00b0");
        sb.append(sparseLop.getBooleanValue());
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getInstructions(String input1, String input2) throws LopsException {
        if (this.getOutputParameters().getFile_name() == null && this.operation == OperationTypes.READ) {
            throw new LopsException(this.printErrorLocation() + "Data.getInstructions(): Exepecting a SCALAR data type, encountered " + (Object)((Object)this.getDataType()));
        }
        StringBuilder sb = new StringBuilder();
        if (this.getExecType() == LopProperties.ExecType.SPARK) {
            sb.append("SPARK");
        } else {
            sb.append("CP");
        }
        sb.append("\u00b0");
        if (this.operation == OperationTypes.READ) {
            sb.append("read");
            sb.append("\u00b0");
            sb.append(this.prepInputOperand(input1));
        } else {
            if (this.operation != OperationTypes.WRITE) throw new LopsException(this.printErrorLocation() + "In Data Lop, Unknown operation: " + (Object)((Object)this.operation));
            sb.append("write");
            sb.append("\u00b0");
            sb.append(this.getInputs().get(0).prepInputOperand(input1));
        }
        sb.append("\u00b0");
        Lop fnameLop = this._inputParams.get("iofilename");
        boolean literal = fnameLop instanceof Data && ((Data)fnameLop).isLiteral();
        sb.append(this.prepOperand(input2, Expression.DataType.SCALAR, Expression.ValueType.STRING, literal));
        OutputParameters oparams = this.getOutputParameters();
        if (this.operation == OperationTypes.WRITE) {
            sb.append("\u00b0");
            String fmt = "";
            if (this.getDataType() == Expression.DataType.MATRIX || this.getDataType() == Expression.DataType.FRAME) {
                if (oparams.getFormat() == OutputParameters.Format.MM) {
                    fmt = "matrixmarket";
                } else if (oparams.getFormat() == OutputParameters.Format.TEXT) {
                    fmt = "textcell";
                } else if (oparams.getFormat() == OutputParameters.Format.CSV) {
                    fmt = "csv";
                } else {
                    if (oparams.getFormat() != OutputParameters.Format.BINARY) throw new LopsException("Unexpected format: " + (Object)((Object)oparams.getFormat()));
                    fmt = oparams.getRowsInBlock() > 0L || oparams.getColsInBlock() > 0L ? "binaryblock" : "binarycell";
                }
            } else {
                fmt = "textcell";
            }
            sb.append(this.prepOperand(fmt, Expression.DataType.SCALAR, Expression.ValueType.STRING, true));
            if (oparams.getFormat() == OutputParameters.Format.CSV) {
                Data headerLop = (Data)this.getNamedInputLop("header");
                Data delimLop = (Data)this.getNamedInputLop("sep");
                Data sparseLop = (Data)this.getNamedInputLop("sparse");
                if (headerLop.isVariable()) {
                    throw new LopsException(this.printErrorLocation() + "Parameter " + "header" + " must be a literal for a seq operation.");
                }
                if (delimLop.isVariable()) {
                    throw new LopsException(this.printErrorLocation() + "Parameter " + "sep" + " must be a literal for a seq operation.");
                }
                if (sparseLop.isVariable()) {
                    throw new LopsException(this.printErrorLocation() + "Parameter " + "sparse" + " must be a literal for a seq operation.");
                }
                sb.append("\u00b0");
                sb.append(headerLop.getBooleanValue());
                sb.append("\u00b0");
                sb.append(delimLop.getStringValue());
                sb.append("\u00b0");
                sb.append(sparseLop.getBooleanValue());
                if (this.getExecType() == LopProperties.ExecType.SPARK) {
                    sb.append("\u00b0");
                    sb.append(true);
                }
            }
        }
        if (this.operation != OperationTypes.WRITE) return sb.toString();
        sb.append("\u00b0");
        Lop descriptionLop = this.getInputParams().get("description");
        if (descriptionLop != null) {
            boolean descLiteral = descriptionLop instanceof Data && ((Data)descriptionLop).isLiteral();
            sb.append(this.prepOperand(descriptionLop.getOutputParameters().getLabel(), Expression.DataType.SCALAR, Expression.ValueType.STRING, descLiteral));
            return sb.toString();
        } else {
            sb.append(this.prepOperand("", Expression.DataType.SCALAR, Expression.ValueType.STRING, true));
        }
        return sb.toString();
    }

    @Override
    public String getInstructions() throws LopsException {
        return this.getCreateVarInstructions(this.getOutputParameters().getFile_name(), this.getOutputParameters().getLabel());
    }

    @Override
    public String getInstructions(String outputFileName) throws LopsException {
        return this.getCreateVarInstructions(outputFileName, this.getOutputParameters().getLabel());
    }

    public String getCreateVarInstructions(String outputFileName, String outputLabel) throws LopsException {
        if (this.getDataType() == Expression.DataType.MATRIX || this.getDataType() == Expression.DataType.FRAME) {
            if (this.isTransient()) {
                throw new LopsException("getInstructions() should not be called for transient nodes.");
            }
            OutputParameters oparams = this.getOutputParameters();
            String fmt = "";
            fmt = oparams.getFormat() == OutputParameters.Format.TEXT ? "textcell" : (oparams.getFormat() == OutputParameters.Format.MM ? "matrixmarket" : (oparams.getFormat() == OutputParameters.Format.CSV ? "csv" : (this.getDataType() == Expression.DataType.FRAME || oparams.getRowsInBlock() > 0L || oparams.getColsInBlock() > 0L ? "binaryblock" : "binarycell")));
            StringBuilder sb = new StringBuilder();
            sb.append("CP");
            sb.append("\u00b0");
            sb.append("createvar");
            sb.append("\u00b0");
            sb.append(outputLabel);
            sb.append("\u00b0");
            sb.append(outputFileName);
            sb.append("\u00b0");
            sb.append(false);
            sb.append("\u00b0");
            sb.append((Object)this.getDataType());
            sb.append("\u00b0");
            sb.append(fmt);
            sb.append("\u00b0");
            sb.append(oparams.getNumRows());
            sb.append("\u00b0");
            sb.append(oparams.getNumCols());
            sb.append("\u00b0");
            sb.append(oparams.getRowsInBlock());
            sb.append("\u00b0");
            sb.append(oparams.getColsInBlock());
            sb.append("\u00b0");
            sb.append(oparams.getNnz());
            sb.append("\u00b0");
            sb.append(oparams.getUpdateType().toString().toLowerCase());
            if (oparams.getFormat() == OutputParameters.Format.CSV) {
                sb.append("\u00b0");
                sb.append(this.createVarCSVHelper());
            }
            if (this.getDataType() == Expression.DataType.FRAME) {
                Data schema = (Data)this.getNamedInputLop("schema");
                sb.append("\u00b0");
                sb.append(schema != null ? schema.prepScalarLabel() : "*");
            }
            return sb.toString();
        }
        throw new LopsException(this.printErrorLocation() + "In Data Lop, Unexpected data type " + (Object)((Object)this.getDataType()));
    }

    private String createVarCSVHelper() throws LopsException {
        StringBuilder sb = new StringBuilder();
        if (this.operation == OperationTypes.READ) {
            Data headerLop = (Data)this.getNamedInputLop("header");
            Data delimLop = (Data)this.getNamedInputLop("sep");
            Data fillLop = (Data)this.getNamedInputLop("fill");
            Data fillValueLop = (Data)this.getNamedInputLop("default");
            Data naLop = (Data)this.getNamedInputLop("na.strings");
            sb.append(headerLop.getBooleanValue());
            sb.append("\u00b0");
            sb.append(delimLop.getStringValue());
            sb.append("\u00b0");
            sb.append(fillLop.getBooleanValue());
            sb.append("\u00b0");
            sb.append(fillValueLop.getDoubleValue());
            if (naLop != null) {
                sb.append("\u00b0");
                sb.append(naLop.getStringValue());
            }
        } else {
            Data headerLop = (Data)this.getNamedInputLop("header");
            Data delimLop = (Data)this.getNamedInputLop("sep");
            Data sparseLop = (Data)this.getNamedInputLop("sparse");
            if (headerLop.isVariable()) {
                throw new LopsException(this.printErrorLocation() + "Parameter " + "header" + " must be a literal for a seq operation.");
            }
            if (delimLop.isVariable()) {
                throw new LopsException(this.printErrorLocation() + "Parameter " + "sep" + " must be a literal for a seq operation.");
            }
            if (sparseLop.isVariable()) {
                throw new LopsException(this.printErrorLocation() + "Parameter " + "sparse" + " must be a literal for a seq operation.");
            }
            sb.append(headerLop.getBooleanValue());
            sb.append("\u00b0");
            sb.append(delimLop.getStringValue());
            sb.append("\u00b0");
            sb.append(sparseLop.getBooleanValue());
        }
        return sb.toString();
    }

    public static enum OperationTypes {
        READ,
        WRITE;

    }
}

