/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.rewrite;

import java.util.ArrayList;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.FunctionOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.rewrite.HopRewriteRule;
import org.apache.sysml.hops.rewrite.ProgramRewriteStatus;
import org.apache.sysml.parser.Expression;

public class RewriteBlockSizeAndReblock
extends HopRewriteRule {
    @Override
    public ArrayList<Hop> rewriteHopDAGs(ArrayList<Hop> roots, ProgramRewriteStatus state) throws HopsException {
        if (roots == null) {
            return null;
        }
        if (RewriteBlockSizeAndReblock.isReblockValid()) {
            state.setBlocksize(ConfigurationManager.getBlocksize());
        }
        for (Hop h : roots) {
            this.rule_BlockSizeAndReblock(h, ConfigurationManager.getBlocksize());
        }
        return roots;
    }

    @Override
    public Hop rewriteHopDAG(Hop root, ProgramRewriteStatus state) throws HopsException {
        if (root == null) {
            return null;
        }
        if (RewriteBlockSizeAndReblock.isReblockValid()) {
            state.setBlocksize(ConfigurationManager.getBlocksize());
        }
        this.rule_BlockSizeAndReblock(root, ConfigurationManager.getBlocksize());
        return root;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void rule_BlockSizeAndReblock(Hop hop, int blocksize) throws HopsException {
        block15: {
            boolean canReblock;
            block14: {
                DataOp dop;
                block17: {
                    block16: {
                        for (Hop hi : hop.getInput()) {
                            if (hi.isVisited()) continue;
                            this.rule_BlockSizeAndReblock(hi, blocksize);
                        }
                        canReblock = RewriteBlockSizeAndReblock.isReblockValid();
                        if (!(hop instanceof DataOp)) break block14;
                        dop = (DataOp)hop;
                        if (!canReblock || (dop.getDataType() != Expression.DataType.MATRIX || dop.getRowsInBlock() == (long)blocksize && dop.getColsInBlock() == (long)blocksize) && (dop.getDataType() != Expression.DataType.FRAME || !OptimizerUtils.isSparkExecutionMode() || dop.getInputFormatType() != Hop.FileFormatTypes.TEXT && dop.getInputFormatType() != Hop.FileFormatTypes.CSV)) break block15;
                        if (dop.getDataOpType() != Hop.DataOpTypes.PERSISTENTREAD) break block16;
                        dop.setRequiresReblock(true);
                        dop.setOutputBlocksizes(blocksize, blocksize);
                        break block15;
                    }
                    if (dop.getDataOpType() != Hop.DataOpTypes.PERSISTENTWRITE) break block17;
                    if (dop.getRowsInBlock() == -1L && dop.getColsInBlock() == -1L) break block15;
                    if (dop.getInput().get(0).requiresReblock() && dop.getInput().get(0).getParent().size() == 1) {
                        dop.getInput().get(0).setOutputBlocksizes(dop.getRowsInBlock(), dop.getColsInBlock());
                    } else {
                        dop.setRequiresReblock(true);
                        dop.setOutputBlocksizes(blocksize, blocksize);
                    }
                    break block15;
                }
                if (dop.getDataOpType() != Hop.DataOpTypes.TRANSIENTWRITE && dop.getDataOpType() != Hop.DataOpTypes.TRANSIENTREAD) throw new HopsException(hop.printErrorLocation() + "unexpected non-scalar Data HOP in reblock.\n");
                if (DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.SINGLE_NODE) {
                    dop.setRowsInBlock(hop.getInput().get(0).getRowsInBlock());
                    dop.setColsInBlock(hop.getInput().get(0).getColsInBlock());
                } else {
                    dop.setRowsInBlock(blocksize);
                    dop.setColsInBlock(blocksize);
                }
                break block15;
            }
            if (hop.requiresReblock()) {
                hop.setRowsInBlock(blocksize);
                hop.setColsInBlock(blocksize);
            } else if (hop.getDataType() == Expression.DataType.SCALAR) {
                hop.setRowsInBlock(-1L);
                hop.setColsInBlock(-1L);
            } else {
                if (!canReblock) {
                    hop.setRowsInBlock(-1L);
                    hop.setColsInBlock(-1L);
                } else {
                    FunctionOp fop;
                    hop.setRowsInBlock(blocksize);
                    hop.setColsInBlock(blocksize);
                    if (hop instanceof FunctionOp && (fop = (FunctionOp)hop).getOutputs() != null) {
                        for (Hop out : fop.getOutputs()) {
                            out.setRowsInBlock(blocksize);
                            out.setColsInBlock(blocksize);
                        }
                    }
                }
                for (Hop h : hop.getInput()) {
                    if (h.getDataType() != Expression.DataType.MATRIX || h.getRowsInBlock() != -1L || h.getColsInBlock() != -1L) continue;
                    hop.setRowsInBlock(-1L);
                    hop.setColsInBlock(-1L);
                    break;
                }
            }
        }
        hop.setVisited();
    }

    private static boolean isReblockValid() {
        return DMLScript.rtplatform != DMLScript.RUNTIME_PLATFORM.SINGLE_NODE;
    }
}

