/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.ipa;

import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.ipa.FunctionCallGraph;
import org.apache.sysml.hops.ipa.FunctionCallSizeInfo;
import org.apache.sysml.hops.ipa.IPAPass;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.parser.FunctionStatement;
import org.apache.sysml.parser.FunctionStatementBlock;
import org.apache.sysml.parser.IfStatement;
import org.apache.sysml.parser.IfStatementBlock;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.WhileStatementBlock;

public class IPAPassFlagFunctionsRecompileOnce
extends IPAPass {
    @Override
    public boolean isApplicable(FunctionCallGraph fgraph) {
        return true;
    }

    @Override
    public void rewriteProgram(DMLProgram prog, FunctionCallGraph fgraph, FunctionCallSizeInfo fcallSizes) throws HopsException {
        if (!ConfigurationManager.isDynamicRecompilation()) {
            return;
        }
        try {
            for (String namespaceKey : prog.getNamespaces().keySet()) {
                for (String fname : prog.getFunctionStatementBlocks(namespaceKey).keySet()) {
                    FunctionStatementBlock fsblock = prog.getFunctionStatementBlock(namespaceKey, fname);
                    if (fgraph.isRecursiveFunction(namespaceKey, fname) || !this.rFlagFunctionForRecompileOnce(fsblock, false)) continue;
                    fsblock.setRecompileOnce(true);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("IPA: FUNC flagged for recompile-once: " + DMLProgram.constructFunctionKey(namespaceKey, fname)));
                }
            }
        }
        catch (LanguageException ex) {
            throw new HopsException(ex);
        }
    }

    public boolean rFlagFunctionForRecompileOnce(StatementBlock sb, boolean inLoop) {
        boolean ret = false;
        if (sb instanceof FunctionStatementBlock) {
            FunctionStatementBlock fsb = (FunctionStatementBlock)sb;
            FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
            for (StatementBlock c : fstmt.getBody()) {
                ret |= this.rFlagFunctionForRecompileOnce(c, inLoop);
            }
        } else if (sb instanceof WhileStatementBlock) {
            ret = true;
        } else if (sb instanceof IfStatementBlock) {
            IfStatementBlock isb = (IfStatementBlock)sb;
            IfStatement istmt = (IfStatement)isb.getStatement(0);
            ret |= inLoop && isb.requiresPredicateRecompilation();
            for (StatementBlock c : istmt.getIfBody()) {
                ret |= this.rFlagFunctionForRecompileOnce(c, inLoop);
            }
            for (StatementBlock c : istmt.getElseBody()) {
                ret |= this.rFlagFunctionForRecompileOnce(c, inLoop);
            }
        } else {
            ret = sb instanceof ForStatementBlock ? true : (ret |= inLoop && sb.requiresRecompilation());
        }
        return ret;
    }
}

