/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.cost;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.cost.CostEstimator;
import org.apache.sysml.hops.cost.VarStats;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.MMTSJ;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.instructions.CPInstructionParser;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.MRInstructionParser;
import org.apache.sysml.runtime.instructions.MRJobInstruction;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.FunctionCallCPInstruction;
import org.apache.sysml.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysml.runtime.instructions.mr.BinaryMRInstructionBase;
import org.apache.sysml.runtime.instructions.mr.CM_N_COVInstruction;
import org.apache.sysml.runtime.instructions.mr.CtableInstruction;
import org.apache.sysml.runtime.instructions.mr.DataGenMRInstruction;
import org.apache.sysml.runtime.instructions.mr.GroupedAggregateInstruction;
import org.apache.sysml.runtime.instructions.mr.IDistributedCacheConsumer;
import org.apache.sysml.runtime.instructions.mr.MMTSJMRInstruction;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.MapMultChainInstruction;
import org.apache.sysml.runtime.instructions.mr.PickByCountInstruction;
import org.apache.sysml.runtime.instructions.mr.RemoveEmptyMRInstruction;
import org.apache.sysml.runtime.instructions.mr.TernaryInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryMRInstructionBase;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.CMOperator;
import org.apache.sysml.yarn.ropt.MRJobResourceInstruction;
import org.apache.sysml.yarn.ropt.YarnClusterAnalyzer;

public class CostEstimatorStaticRuntime
extends CostEstimator {
    private static final long DEFAULT_FLOPS = 0x80000000L;
    private static final double DEFAULT_NFLOP_NOOP = 10.0;
    private static final double DEFAULT_NFLOP_UNKNOWN = 1.0;
    private static final double DEFAULT_NFLOP_CP = 1.0;
    private static final double DEFAULT_NFLOP_TEXT_IO = 350.0;
    private static final double DEFAULT_MR_JOB_LATENCY_LOCAL = 2.0;
    private static final double DEFAULT_MR_JOB_LATENCY_REMOTE = 20.0;
    private static final double DEFAULT_MR_TASK_LATENCY_LOCAL = 0.001;
    private static final double DEFAULT_MR_TASK_LATENCY_REMOTE = 1.5;
    private static final double DEFAULT_MBS_FSREAD_BINARYBLOCK_DENSE = 200.0;
    private static final double DEFAULT_MBS_FSREAD_BINARYBLOCK_SPARSE = 100.0;
    private static final double DEFAULT_MBS_HDFSREAD_BINARYBLOCK_DENSE = 150.0;
    private static final double DEFAULT_MBS_HDFSREAD_BINARYBLOCK_SPARSE = 75.0;
    private static final double DEFAULT_MBS_FSWRITE_BINARYBLOCK_DENSE = 150.0;
    private static final double DEFAULT_MBS_FSWRITE_BINARYBLOCK_SPARSE = 75.0;
    private static final double DEFAULT_MBS_HDFSWRITE_BINARYBLOCK_DENSE = 120.0;
    private static final double DEFAULT_MBS_HDFSWRITE_BINARYBLOCK_SPARSE = 60.0;
    private static final double DEFAULT_MBS_HDFSWRITE_TEXT_DENSE = 40.0;
    private static final double DEFAULT_MBS_HDFSWRITE_TEXT_SPARSE = 30.0;

    @Override
    protected double getCPInstTimeEstimate(Instruction inst, VarStats[] vs, String[] args) throws DMLRuntimeException {
        CPInstruction cpinst = (CPInstruction)inst;
        double ltime = 0.0;
        if (!vs[0]._inmem) {
            ltime += CostEstimatorStaticRuntime.getHDFSReadTime(vs[0]._rlen, vs[0]._clen, vs[0].getSparsity());
            vs[0]._inmem = true;
        }
        if (!vs[1]._inmem) {
            ltime += CostEstimatorStaticRuntime.getHDFSReadTime(vs[1]._rlen, vs[1]._clen, vs[1].getSparsity());
            vs[1]._inmem = true;
        }
        if (LOG.isDebugEnabled() && ltime != 0.0) {
            LOG.debug((Object)("Cost[" + cpinst.getOpcode() + " - read] = " + ltime));
        }
        String opcode = cpinst instanceof FunctionCallCPInstruction ? InstructionUtils.getOpCode(cpinst.toString()) : cpinst.getOpcode();
        double etime = CostEstimatorStaticRuntime.getInstTimeEstimate(opcode, vs, args, LopProperties.ExecType.CP);
        double wtime = 0.0;
        if (inst instanceof VariableCPInstruction && ((VariableCPInstruction)inst).getOpcode().equals("write")) {
            wtime += CostEstimatorStaticRuntime.getHDFSWriteTime(vs[2]._rlen, vs[2]._clen, vs[2].getSparsity(), ((VariableCPInstruction)inst).getInput3().getName());
        }
        if (LOG.isDebugEnabled() && wtime != 0.0) {
            LOG.debug((Object)("Cost[" + cpinst.getOpcode() + " - write] = " + wtime));
        }
        double costs = ltime + etime + wtime;
        return costs;
    }

    @Override
    protected double getMRJobInstTimeEstimate(Instruction inst, VarStats[] vs, String[] args) throws DMLRuntimeException {
        String opcode;
        Object[] o;
        String[] linst;
        MRJobInstruction jinst = (MRJobInstruction)inst;
        boolean localJob = InfrastructureAnalyzer.isLocalMode();
        int maxPMap = InfrastructureAnalyzer.getRemoteParallelMapTasks();
        int maxPRed = Math.min(InfrastructureAnalyzer.getRemoteParallelReduceTasks(), ConfigurationManager.getNumReducers());
        double blocksize = (double)InfrastructureAnalyzer.getHDFSBlockSize() / 1048576.0;
        if (InfrastructureAnalyzer.isYarnEnabled()) {
            maxPMap = (int)Math.max((long)maxPMap, YarnClusterAnalyzer.getNumCores());
            maxPRed = (int)Math.max((long)maxPRed, YarnClusterAnalyzer.getNumCores() / 2L / 2L);
        }
        if (jinst instanceof MRJobResourceInstruction) {
            int maxTasks = (int)((MRJobResourceInstruction)jinst).getMaxMRTasks();
            maxPMap = Math.min(maxPMap, maxTasks);
            maxPRed = Math.min(maxPRed, maxTasks);
        }
        boolean mapOnly = jinst.isMapOnly();
        String rdInst = jinst.getIv_randInstructions();
        String rrInst = jinst.getIv_recordReaderInstructions();
        String mapInst = jinst.getIv_instructionsInMapper();
        String shfInst = jinst.getIv_shuffleInstructions();
        String aggInst = jinst.getIv_aggInstructions();
        String otherInst = jinst.getIv_otherInstructions();
        byte[] inIx = CostEstimatorStaticRuntime.getInputIndexes(jinst.getInputVars());
        byte[] retIx = jinst.getIv_resultIndices();
        byte[] mapOutIx = this.getMapOutputIndexes(inIx, retIx, rdInst, mapInst, shfInst, aggInst, otherInst);
        int numMap = CostEstimatorStaticRuntime.computeNumMapTasks(vs, inIx, blocksize, maxPMap, jinst.getJobType());
        int numPMap = Math.min(numMap, maxPMap);
        int numEPMap = Math.max(Math.min(numMap, maxPMap / 2), 1);
        int numRed = CostEstimatorStaticRuntime.computeNumReduceTasks(vs, mapOutIx, jinst.getJobType());
        int numPRed = Math.min(numRed, maxPRed);
        int numEPRed = Math.max(Math.min(numRed, maxPRed / 2), 1);
        LOG.debug((Object)("Meta nmap = " + numMap + ", nred = " + numRed + "; npmap = " + numPMap + ", npred = " + numPRed + "; nepmap = " + numEPMap + ", nepred = " + numEPRed));
        double exportCosts = 0.0;
        for (int i = 0; i < jinst.getInputVars().length; ++i) {
            if (!vs[i]._inmem) continue;
            exportCosts += CostEstimatorStaticRuntime.getHDFSWriteTime(vs[i]._rlen, vs[i]._clen, vs[i].getSparsity());
        }
        double jobLatencyCosts = localJob ? 2.0 : 20.0;
        double taskLatencyCost = (double)(numMap / numEPMap + numEPRed) * (localJob ? 0.001 : 1.5);
        double latencyCosts = jobLatencyCosts + taskLatencyCost;
        double hdfsReadCosts = 0.0;
        for (int i = 0; i < jinst.getInputVars().length; ++i) {
            hdfsReadCosts += CostEstimatorStaticRuntime.getHDFSReadTime(vs[i]._rlen, vs[i]._clen, vs[i].getSparsity());
        }
        hdfsReadCosts /= (double)numEPMap;
        String[] mapperInst = new String[]{rdInst, rrInst, mapInst};
        String[] reducerInst = new String[]{shfInst, aggInst, otherInst};
        double mapDCReadCost = 0.0;
        double mapCosts = 0.0;
        double shuffleCosts = 0.0;
        double reduceCosts = 0.0;
        for (String instCat : mapperInst) {
            if (instCat == null || instCat.length() <= 0) continue;
            for (String tmp : linst = instCat.split("\u2021")) {
                o = this.extractMRInstStatistics(tmp, vs);
                opcode = InstructionUtils.getOpCode(tmp);
                mapCosts += CostEstimatorStaticRuntime.getInstTimeEstimate(opcode, (VarStats[])o[0], (String[])o[1], LopProperties.ExecType.MR);
                int dcIndex = CostEstimatorStaticRuntime.getDistcacheIndex(tmp);
                if (dcIndex < 0) continue;
                mapDCReadCost += Math.min(CostEstimatorStaticRuntime.getFSReadTime(vs[dcIndex]._rlen, vs[dcIndex]._clen, vs[dcIndex].getSparsity()), CostEstimatorStaticRuntime.getFSReadTime(4000000L, 1L, 1.0)) * (double)numMap;
            }
        }
        mapCosts /= (double)numEPMap;
        mapDCReadCost /= (double)numEPMap;
        if (!mapOnly) {
            for (int i = 0; i < mapOutIx.length; ++i) {
                shuffleCosts += CostEstimatorStaticRuntime.getFSWriteTime(vs[mapOutIx[i]]._rlen, vs[mapOutIx[i]]._clen, vs[mapOutIx[i]].getSparsity()) / (double)numEPMap + CostEstimatorStaticRuntime.getFSWriteTime(vs[mapOutIx[i]]._rlen, vs[mapOutIx[i]]._clen, vs[mapOutIx[i]].getSparsity()) * 4.0 / (double)numEPRed + CostEstimatorStaticRuntime.getFSReadTime(vs[mapOutIx[i]]._rlen, vs[mapOutIx[i]]._clen, vs[mapOutIx[i]].getSparsity()) / (double)numEPRed;
                String[] stringArray = reducerInst;
                int n = stringArray.length;
                for (int instCat = 0; instCat < n; ++instCat) {
                    String[] linst2;
                    String instCat2 = stringArray[instCat];
                    if (instCat2 == null || instCat2.length() <= 0) continue;
                    String[] stringArray2 = linst2 = instCat2.split("\u2021");
                    int n2 = stringArray2.length;
                    for (int tmp = 0; tmp < n2; ++tmp) {
                        String tmp2 = stringArray2[tmp];
                        if (InstructionUtils.getMRType(tmp2) != MRInstruction.MRType.Aggregate) continue;
                        shuffleCosts += (double)numMap * CostEstimatorStaticRuntime.getFSWriteTime(vs[mapOutIx[i]]._rlen, vs[mapOutIx[i]]._clen, vs[mapOutIx[i]].getSparsity()) / (double)numEPMap + (double)numPMap * CostEstimatorStaticRuntime.getFSWriteTime(vs[mapOutIx[i]]._rlen, vs[mapOutIx[i]]._clen, vs[mapOutIx[i]].getSparsity()) / (double)numEPMap + (double)numPMap * CostEstimatorStaticRuntime.getFSReadTime(vs[mapOutIx[i]]._rlen, vs[mapOutIx[i]]._clen, vs[mapOutIx[i]].getSparsity()) / (double)numEPRed;
                    }
                }
            }
            for (String instCat : reducerInst) {
                if (instCat == null || instCat.length() <= 0) continue;
                for (String tmp : linst = instCat.split("\u2021")) {
                    o = this.extractMRInstStatistics(tmp, vs);
                    if (InstructionUtils.getMRType(tmp) == MRInstruction.MRType.Aggregate) {
                        o[1] = new String[]{String.valueOf(numMap)};
                    }
                    opcode = InstructionUtils.getOpCode(tmp);
                    reduceCosts += CostEstimatorStaticRuntime.getInstTimeEstimate(opcode, (VarStats[])o[0], (String[])o[1], LopProperties.ExecType.MR);
                }
            }
            reduceCosts /= (double)numEPRed;
        }
        double hdfsWriteCosts = 0.0;
        for (int i = 0; i < jinst.getOutputVars().length; ++i) {
            hdfsWriteCosts += CostEstimatorStaticRuntime.getHDFSWriteTime(vs[retIx[i]]._rlen, vs[retIx[i]]._clen, vs[retIx[i]].getSparsity());
        }
        hdfsWriteCosts /= (double)(mapOnly ? numEPMap : numEPRed);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Costs Export = " + exportCosts));
            LOG.debug((Object)("Costs Latency = " + latencyCosts));
            LOG.debug((Object)("Costs HDFS Read = " + hdfsReadCosts));
            LOG.debug((Object)("Costs Distcache Read = " + mapDCReadCost));
            LOG.debug((Object)("Costs Map Exec = " + mapCosts));
            LOG.debug((Object)("Costs Shuffle = " + shuffleCosts));
            LOG.debug((Object)("Costs Reduce Exec = " + reduceCosts));
            LOG.debug((Object)("Costs HDFS Write = " + hdfsWriteCosts));
        }
        return exportCosts + latencyCosts + hdfsReadCosts + mapCosts + mapDCReadCost + shuffleCosts + reduceCosts + hdfsWriteCosts;
    }

    private Object[] extractMRInstStatistics(String inst, VarStats[] stats) throws DMLRuntimeException {
        Object[] ret = new Object[2];
        VarStats[] vs = new VarStats[3];
        String[] attr = null;
        String[] parts = InstructionUtils.getInstructionParts(inst);
        String opcode = parts[0];
        if (opcode.equals("rand")) {
            vs[0] = _unknownStats;
            vs[1] = _unknownStats;
            vs[2] = stats[Integer.parseInt(parts[2])];
            int type = 2;
            if (!parts[7].contains("\u00b6") && !parts[8].contains("\u00b6")) {
                double minValue = Double.parseDouble(parts[7]);
                double maxValue = Double.parseDouble(parts[8]);
                double sparsity = Double.parseDouble(parts[9]);
                if (minValue == 0.0 && maxValue == 0.0) {
                    type = 0;
                } else if (sparsity == 1.0 && minValue == maxValue) {
                    type = 1;
                }
            }
            attr = new String[]{String.valueOf(type)};
        }
        if (opcode.equals("seq")) {
            vs[0] = _unknownStats;
            vs[1] = _unknownStats;
            vs[2] = stats[Integer.parseInt(parts[2])];
        } else {
            String inst2 = this.replaceInstructionPatch(inst);
            MRInstruction mrinst = MRInstructionParser.parseSingleInstruction(inst2);
            if (mrinst instanceof UnaryMRInstructionBase) {
                UnaryMRInstructionBase uinst = (UnaryMRInstructionBase)mrinst;
                vs[0] = uinst.input >= 0 ? stats[uinst.input] : _unknownStats;
                vs[1] = _unknownStats;
                vs[2] = stats[uinst.output];
                if (vs[0] == null) {
                    vs[0] = _scalarStats;
                }
                if (vs[2] == null) {
                    vs[2] = _scalarStats;
                }
                if (mrinst instanceof MMTSJMRInstruction) {
                    String type = ((MMTSJMRInstruction)mrinst).getMMTSJType().toString();
                    attr = new String[]{type};
                } else if (mrinst instanceof CM_N_COVInstruction) {
                    if (opcode.equals("cm")) {
                        attr = new String[]{parts[parts.length - 2]};
                    }
                } else if (mrinst instanceof GroupedAggregateInstruction && opcode.equals("groupedagg")) {
                    CMOperator.AggregateOperationTypes type = CMOperator.getAggOpType(parts[2], parts[3]);
                    attr = new String[]{String.valueOf(type.ordinal())};
                }
            } else if (mrinst instanceof BinaryMRInstructionBase) {
                BinaryMRInstructionBase binst = (BinaryMRInstructionBase)mrinst;
                vs[0] = stats[binst.input1];
                vs[1] = stats[binst.input2];
                vs[2] = stats[binst.output];
                if (vs[0] == null) {
                    vs[0] = _scalarStats;
                }
                if (vs[1] == null) {
                    vs[1] = _scalarStats;
                }
                if (vs[2] == null) {
                    vs[2] = _scalarStats;
                }
                if (opcode.equals("rmempty")) {
                    RemoveEmptyMRInstruction rbinst = (RemoveEmptyMRInstruction)mrinst;
                    attr = new String[]{rbinst.isRemoveRows() ? "0" : "1"};
                }
            } else if (mrinst instanceof TernaryInstruction) {
                TernaryInstruction tinst = (TernaryInstruction)mrinst;
                byte[] ix = tinst.getAllIndexes();
                for (int i = 0; i < ix.length - 1; ++i) {
                    vs[0] = stats[ix[i]];
                }
                vs[2] = stats[ix[ix.length - 1]];
                if (vs[0] == null) {
                    vs[0] = _scalarStats;
                }
                if (vs[1] == null) {
                    vs[1] = _scalarStats;
                }
                if (vs[2] == null) {
                    vs[2] = _scalarStats;
                }
            } else if (mrinst instanceof CtableInstruction) {
                CtableInstruction tinst = (CtableInstruction)mrinst;
                vs[0] = stats[tinst.input1];
                vs[1] = stats[tinst.input2];
                vs[2] = stats[tinst.input3];
                if (vs[0] == null) {
                    vs[0] = _scalarStats;
                }
                if (vs[1] == null) {
                    vs[1] = _scalarStats;
                }
                if (vs[2] == null) {
                    vs[2] = _scalarStats;
                }
            } else if (mrinst instanceof PickByCountInstruction) {
                PickByCountInstruction pinst = (PickByCountInstruction)mrinst;
                vs[0] = stats[pinst.input1];
                vs[2] = stats[pinst.output];
                if (vs[0] == null) {
                    vs[0] = _scalarStats;
                }
                if (vs[1] == null) {
                    vs[1] = _scalarStats;
                }
                if (vs[2] == null) {
                    vs[2] = _scalarStats;
                }
            } else if (mrinst instanceof MapMultChainInstruction) {
                MapMultChainInstruction minst = (MapMultChainInstruction)mrinst;
                vs[0] = stats[minst.getInput1()];
                vs[1] = stats[minst.getInput2()];
                if (minst.getInput3() >= 0) {
                    vs[2] = stats[minst.getInput3()];
                }
                if (vs[0] == null) {
                    vs[0] = _scalarStats;
                }
                if (vs[1] == null) {
                    vs[1] = _scalarStats;
                }
                if (vs[2] == null) {
                    vs[2] = _scalarStats;
                }
            }
        }
        vs[2]._inmem = true;
        ret[0] = vs;
        ret[1] = attr;
        return ret;
    }

    private static byte[] getInputIndexes(String[] inputVars) {
        byte[] inIx = new byte[inputVars.length];
        for (int i = 0; i < inIx.length; ++i) {
            inIx[i] = (byte)i;
        }
        return inIx;
    }

    private byte[] getMapOutputIndexes(byte[] inIx, byte[] retIx, String rdInst, String mapInst, String shfInst, String aggInst, String otherInst) throws DMLRuntimeException {
        MRInstruction[] ins;
        MRInstruction[] ins2;
        HashSet<Byte> ixMap = new HashSet<Byte>();
        for (byte ix : inIx) {
            ixMap.add(ix);
        }
        if (rdInst != null && rdInst.length() > 0) {
            rdInst = this.replaceInstructionPatch(rdInst);
            ins2 = MRInstructionParser.parseDataGenInstructions(rdInst);
            for (MRInstruction inst : ins2) {
                for (byte ix : ((DataGenMRInstruction)inst).getAllIndexes()) {
                    ixMap.add(ix);
                }
            }
        }
        if (mapInst != null && mapInst.length() > 0) {
            mapInst = this.replaceInstructionPatch(mapInst);
            for (MRInstruction inst : ins2 = MRInstructionParser.parseMixedInstructions(mapInst)) {
                for (byte ix : inst.getAllIndexes()) {
                    ixMap.add(ix);
                }
            }
        }
        HashSet<Byte> ixRed = new HashSet<Byte>();
        for (byte ix : retIx) {
            ixRed.add(ix);
        }
        if (shfInst != null && shfInst.length() > 0) {
            shfInst = this.replaceInstructionPatch(shfInst);
            for (MRInstruction inst : ins = MRInstructionParser.parseMixedInstructions(shfInst)) {
                for (byte ix : inst.getAllIndexes()) {
                    ixRed.add(ix);
                }
            }
        }
        if (aggInst != null && aggInst.length() > 0) {
            aggInst = this.replaceInstructionPatch(aggInst);
            for (MRInstruction inst : ins = MRInstructionParser.parseAggregateInstructions(aggInst)) {
                for (byte ix : inst.getAllIndexes()) {
                    ixRed.add(ix);
                }
            }
        }
        if (otherInst != null && otherInst.length() > 0) {
            otherInst = this.replaceInstructionPatch(otherInst);
            for (MRInstruction inst : ins = MRInstructionParser.parseMixedInstructions(otherInst)) {
                for (byte ix : inst.getAllIndexes()) {
                    ixRed.add(ix);
                }
            }
        }
        ixMap.retainAll(ixRed);
        byte[] ret = new byte[ixMap.size()];
        int i = 0;
        Iterator iterator = ixMap.iterator();
        while (iterator.hasNext()) {
            byte ix = (Byte)iterator.next();
            ret[i++] = ix;
        }
        return ret;
    }

    private static int computeNumMapTasks(VarStats[] vs, byte[] inputIx, double blocksize, int maxPMap, JobType jobtype) {
        if (jobtype == JobType.DATAGEN) {
            return maxPMap;
        }
        double mapInputSize = 0.0;
        int numBlocks = 0;
        for (int i = 0; i < inputIx.length; ++i) {
            mapInputSize += (double)MatrixBlock.estimateSizeOnDisk(vs[inputIx[i]]._rlen, vs[inputIx[i]]._clen, (long)vs[inputIx[i]]._nnz) / 1048576.0;
            int lret = (int)Math.ceil((double)vs[inputIx[i]]._rlen / (double)vs[inputIx[i]]._brlen) * (int)Math.ceil((double)vs[inputIx[i]]._clen / (double)vs[inputIx[i]]._bclen);
            numBlocks = Math.max(lret, numBlocks);
        }
        return Math.max(1, Math.min((int)Math.ceil(mapInputSize / blocksize), numBlocks));
    }

    private static int computeNumReduceTasks(VarStats[] vs, byte[] mapOutIx, JobType jobtype) {
        int ret = -1;
        switch (jobtype) {
            case REBLOCK: 
            case CSV_REBLOCK: {
                for (int i = 0; i < mapOutIx.length; ++i) {
                    int lret = (int)Math.ceil((double)vs[mapOutIx[i]]._rlen / (double)vs[mapOutIx[i]]._brlen) * (int)Math.ceil((double)vs[mapOutIx[i]]._clen / (double)vs[mapOutIx[i]]._bclen);
                    ret = Math.max(lret, ret);
                }
                break;
            }
            default: {
                for (int i = 0; i < mapOutIx.length; ++i) {
                    int lret = (int)Math.ceil((double)vs[mapOutIx[i]]._rlen / (double)ConfigurationManager.getBlocksize()) * (int)Math.ceil((double)vs[mapOutIx[i]]._clen / (double)ConfigurationManager.getBlocksize());
                    ret = Math.max(lret, ret);
                }
            }
        }
        return Math.max(1, ret);
    }

    private static int getDistcacheIndex(String inst) throws DMLRuntimeException {
        MRInstruction mrinst;
        ArrayList<Byte> indexes = new ArrayList<Byte>();
        if (InstructionUtils.isDistributedCacheUsed(inst) && (mrinst = MRInstructionParser.parseSingleInstruction(inst)) instanceof IDistributedCacheConsumer) {
            ((IDistributedCacheConsumer)((Object)mrinst)).addDistCacheIndex(inst, indexes);
        }
        if (!indexes.isEmpty()) {
            return ((Byte)indexes.get(0)).byteValue();
        }
        return -1;
    }

    private static double getHDFSReadTime(long dm, long dn, double ds) {
        boolean sparse = MatrixBlock.evalSparseFormatOnDisk(dm, dn, (long)(ds * (double)dm * (double)dn));
        double ret = (double)MatrixBlock.estimateSizeOnDisk(dm, dn, (long)(ds * (double)dm * (double)dn)) / 1048576.0;
        ret = sparse ? (ret /= 75.0) : (ret /= 150.0);
        return ret;
    }

    private static double getHDFSWriteTime(long dm, long dn, double ds) {
        boolean sparse = MatrixBlock.evalSparseFormatOnDisk(dm, dn, (long)(ds * (double)dm * (double)dn));
        double bytes = MatrixBlock.estimateSizeOnDisk(dm, dn, (long)(ds * (double)dm * (double)dn));
        double mbytes = bytes / 1048576.0;
        double ret = -1.0;
        ret = sparse ? mbytes / 60.0 : mbytes / 120.0;
        return ret;
    }

    private static double getHDFSWriteTime(long dm, long dn, double ds, String format) {
        boolean sparse = MatrixBlock.evalSparseFormatOnDisk(dm, dn, (long)(ds * (double)dm * (double)dn));
        double bytes = MatrixBlock.estimateSizeOnDisk(dm, dn, (long)(ds * (double)dm * (double)dn));
        double mbytes = bytes / 1048576.0;
        double ret = -1.0;
        if (format.equals("textcell") || format.equals("csv")) {
            ret = sparse ? mbytes / 30.0 : mbytes / 40.0;
            ret *= 2.75;
        } else {
            ret = sparse ? mbytes / 60.0 : mbytes / 120.0;
        }
        return ret;
    }

    private static double getFSReadTime(long dm, long dn, double ds) {
        boolean sparse = MatrixBlock.evalSparseFormatOnDisk(dm, dn, (long)(ds * (double)dm * (double)dn));
        double ret = (double)MatrixBlock.estimateSizeOnDisk(dm, dn, (long)(ds * (double)dm * (double)dn)) / 1048576.0;
        ret = sparse ? (ret /= 100.0) : (ret /= 200.0);
        return ret;
    }

    private static double getFSWriteTime(long dm, long dn, double ds) {
        boolean sparse = MatrixBlock.evalSparseFormatOnDisk(dm, dn, (long)(ds * (double)dm * (double)dn));
        double ret = (double)MatrixBlock.estimateSizeOnDisk(dm, dn, (long)(ds * (double)dm * (double)dn)) / 1048576.0;
        ret = sparse ? (ret /= 75.0) : (ret /= 150.0);
        return ret;
    }

    private static double getInstTimeEstimate(String opcode, VarStats[] vs, String[] args, LopProperties.ExecType et) throws DMLRuntimeException {
        boolean inMR = et == LopProperties.ExecType.MR;
        return CostEstimatorStaticRuntime.getInstTimeEstimate(opcode, inMR, vs[0]._rlen, vs[0]._clen, vs[0]._nnz < 0.0 ? 1.0 : vs[0]._nnz / (double)vs[0]._rlen / (double)vs[0]._clen, vs[1]._rlen, vs[1]._clen, vs[1]._nnz < 0.0 ? 1.0 : vs[1]._nnz / (double)vs[1]._rlen / (double)vs[1]._clen, vs[2]._rlen, vs[2]._clen, vs[2]._nnz < 0.0 ? 1.0 : vs[2]._nnz / (double)vs[2]._rlen / (double)vs[2]._clen, args);
    }

    private static double getInstTimeEstimate(String opcode, boolean inMR, long d1m, long d1n, double d1s, long d2m, long d2n, double d2s, long d3m, long d3n, double d3s, String[] args) throws DMLRuntimeException {
        double nflops = CostEstimatorStaticRuntime.getNFLOP(opcode, inMR, d1m, d1n, d1s, d2m, d2n, d2s, d3m, d3n, d3s, args);
        double time = nflops / 2.147483648E9;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Cost[" + opcode + "] = " + time + "s, " + nflops + " flops (" + d1m + "," + d1n + "," + d1s + "," + d2m + "," + d2n + "," + d2s + "," + d3m + "," + d3n + "," + d3s + ")."));
        }
        return time;
    }

    private static double getNFLOP(String optype, boolean inMR, long d1m, long d1n, double d1s, long d2m, long d2n, double d2s, long d3m, long d3n, double d3s, String[] args) throws DMLRuntimeException {
        block137: {
            block136: {
                boolean leftSparse = MatrixBlock.evalSparseFormatInMemory(d1m, d1n, (long)(d1s * (double)d1m * (double)d1n));
                boolean rightSparse = MatrixBlock.evalSparseFormatInMemory(d2m, d2n, (long)(d2s * (double)d2m * (double)d2n));
                boolean onlyLeft = d1m >= 0L && d1n >= 0L && d2m < 0L && d2n < 0L;
                boolean allExists = d1m >= 0L && d1n >= 0L && d2m >= 0L && d2n >= 0L && d3m >= 0L && d3n >= 0L;
                CPInstruction.CPType cptype = CPInstructionParser.String2CPInstructionType.get(optype);
                if (cptype != null) {
                    switch (cptype) {
                        case AggregateBinary: {
                            if (optype.equals("ba+*")) {
                                if (!leftSparse && !rightSparse) {
                                    return 2.0 * ((double)(d1m * d1n) * (d2n > 1L ? d1s : 1.0) * (double)d2n) / 2.0;
                                }
                                if (!leftSparse && rightSparse) {
                                    return 2.0 * ((double)(d1m * d1n) * d1s * (double)d2n * d2s) / 2.0;
                                }
                                if (leftSparse && !rightSparse) {
                                    return 2.0 * ((double)(d1m * d1n) * d1s * (double)d2n) / 2.0;
                                }
                                return 2.0 * ((double)(d1m * d1n) * d1s * (double)d2n * d2s) / 2.0;
                            }
                            if (optype.equals("cov")) {
                                return 23L * d1m;
                            }
                            return 0.0;
                        }
                        case MMChain: {
                            if (!leftSparse) {
                                return 4L * (d1m * d1n) / 2L;
                            }
                            return 4.0 * ((double)(d1m * d1n) * d1s) / 2.0;
                        }
                        case AggregateTernary: {
                            return 6L * d1m * d1n;
                        }
                        case AggregateUnary: {
                            if (optype.equals("nrow") || optype.equals("ncol") || optype.equals("length")) {
                                return 10.0;
                            }
                            if (optype.equals("cm")) {
                                double xcm = 1.0;
                                switch (Integer.parseInt(args[0])) {
                                    case 0: {
                                        xcm = 1.0;
                                        break;
                                    }
                                    case 1: {
                                        xcm = 8.0;
                                        break;
                                    }
                                    case 2: {
                                        xcm = 16.0;
                                        break;
                                    }
                                    case 3: {
                                        xcm = 31.0;
                                        break;
                                    }
                                    case 4: {
                                        xcm = 51.0;
                                        break;
                                    }
                                    case 5: {
                                        xcm = 16.0;
                                    }
                                }
                                return leftSparse ? xcm * ((double)d1m * d1s + 1.0) : xcm * (double)d1m;
                            }
                            if (optype.equals("uatrace") || optype.equals("uaktrace")) {
                                return 2L * d1m * d1n;
                            }
                            if (optype.equals("ua+") || optype.equals("uar+") || optype.equals("uac+")) {
                                if (!leftSparse) {
                                    return d1m * d1n;
                                }
                                return (double)(d1m * d1n) * d1s;
                            }
                            if (optype.equals("uak+") || optype.equals("uark+") || optype.equals("uack+")) {
                                return 4L * d1m * d1n;
                            }
                            if (optype.equals("uasqk+") || optype.equals("uarsqk+") || optype.equals("uacsqk+")) {
                                return 5L * d1m * d1n;
                            }
                            if (optype.equals("uamean") || optype.equals("uarmean") || optype.equals("uacmean")) {
                                return 7L * d1m * d1n;
                            }
                            if (optype.equals("uavar") || optype.equals("uarvar") || optype.equals("uacvar")) {
                                return 14L * d1m * d1n;
                            }
                            if (optype.equals("uamax") || optype.equals("uarmax") || optype.equals("uacmax") || optype.equals("uamin") || optype.equals("uarmin") || optype.equals("uacmin") || optype.equals("uarimax") || optype.equals("ua*")) {
                                return d1m * d1n;
                            }
                            return 0.0;
                        }
                        case Binary: {
                            if (optype.equals("+") || optype.equals("-") && (leftSparse || rightSparse)) {
                                return (double)(d1m * d1n) * d1s + (double)(d2m * d2n) * d2s;
                            }
                            if (optype.equals("solve")) {
                                return d1m * d1n * d1n;
                            }
                            return d3m * d3n;
                        }
                        case Ternary: {
                            return 2L * d1m * d1n;
                        }
                        case Ctable: {
                            if (optype.equals("ctable")) {
                                if (leftSparse) {
                                    return (double)(d1m * d1n) * d1s;
                                }
                                return d1m * d1n;
                            }
                            return 0.0;
                        }
                        case Builtin: {
                            if (allExists) {
                                return 3L * d3m * d3n;
                            }
                            return d3m * d3n;
                        }
                        case Unary: {
                            if (optype.equals("print")) {
                                return 1.0;
                            }
                            double xbu = 1.0;
                            if (optype.equals("plogp")) {
                                xbu = 2.0;
                            } else if (optype.equals("round")) {
                                xbu = 4.0;
                            }
                            if (optype.equals("sin") || optype.equals("tan") || optype.equals("round") || optype.equals("abs") || optype.equals("sqrt") || optype.equals("sprop") || optype.equals("sigmoid") || optype.equals("sign")) {
                                if (leftSparse) {
                                    return xbu * (double)d1m * (double)d1n * d1s;
                                }
                                return xbu * (double)d1m * (double)d1n;
                            }
                            return xbu * (double)d1m * (double)d1n;
                        }
                        case Reorg: 
                        case MatrixReshape: {
                            if (leftSparse) {
                                return (double)(d1m * d1n) * d1s;
                            }
                            return d1m * d1n;
                        }
                        case Append: {
                            return 1.0 * ((leftSparse ? (double)(d1m * d1n) * d1s : (double)(d1m * d1n)) + (rightSparse ? (double)(d2m * d2n) * d2s : (double)(d2m * d2n)));
                        }
                        case Variable: {
                            if (optype.equals("write")) {
                                double xwrite;
                                boolean text = args[0].equals("textcell") || args[0].equals("csv");
                                double d = xwrite = text ? 350.0 : 1.0;
                                if (!leftSparse) {
                                    return (double)(d1m * d1n) * xwrite;
                                }
                                return (double)(d1m * d1n) * d1s * xwrite;
                            }
                            if (optype.equals("inmem-iqm")) {
                                return (double)(2L * d1m + 5L) + 0.25 * (double)d1m + 4.0 * (double)d1m;
                            }
                            return 10.0;
                        }
                        case Rand: {
                            if (optype.equals("rand")) {
                                int nflopRand = 32;
                                switch (Integer.parseInt(args[0])) {
                                    case 0: {
                                        return 10.0;
                                    }
                                    case 1: {
                                        return d3m * d3n * 8L;
                                    }
                                    case 2: {
                                        if (d3s == 1.0) {
                                            return d3m * d3n * (long)nflopRand + d3m * d3n * 8L;
                                        }
                                        return d3s >= 0.4 ? (double)(2L * d3m * d3n * (long)nflopRand + d3m * d3n * 8L) : (double)(3L * d3m * d3n) * d3s * (double)nflopRand + (double)(d3m * d3n) * d3s * 24.0;
                                    }
                                }
                            } else {
                                return (double)(d3m * d3n) * 1.0;
                            }
                        }
                        case StringInit: {
                            return (double)(d3m * d3n) * 1.0;
                        }
                        case External: {
                            return (double)(d1m * d1n) * d1s * 1.0;
                        }
                        case MultiReturnBuiltin: {
                            double xf = 2.0;
                            if (optype.equals("eigen")) {
                                xf = 32.0;
                            } else if (optype.equals("lu")) {
                                xf = 16.0;
                            } else if (optype.equals("svd")) {
                                xf = 32.0;
                            }
                            return xf * (double)d1m * (double)d1n * (double)d1n;
                        }
                        case ParameterizedBuiltin: {
                            if (optype.equals("cdf") || optype.equals("invcdf")) {
                                return 1.0;
                            }
                            if (optype.equals("groupedagg")) {
                                double xga = 1.0;
                                switch (Integer.parseInt(args[0])) {
                                    case 0: {
                                        xga = 4.0;
                                        break;
                                    }
                                    case 1: {
                                        xga = 1.0;
                                        break;
                                    }
                                    case 2: {
                                        xga = 8.0;
                                        break;
                                    }
                                    case 3: {
                                        xga = 16.0;
                                        break;
                                    }
                                    case 4: {
                                        xga = 31.0;
                                        break;
                                    }
                                    case 5: {
                                        xga = 51.0;
                                        break;
                                    }
                                    case 6: {
                                        xga = 16.0;
                                    }
                                }
                                return (double)(2L * d1m) + xga * (double)d1m;
                            }
                            if (optype.equals("rmempty")) {
                                switch (Integer.parseInt(args[0])) {
                                    case 0: {
                                        return (leftSparse ? (double)d1m : (double)d1m * Math.ceil(1.0 / d1s) / 2.0) + 1.0 * (double)d3m * (double)d2m;
                                    }
                                    case 1: {
                                        return (double)d1n * Math.ceil(1.0 / d1s) / 2.0 + 1.0 * (double)d3m * (double)d2m;
                                    }
                                }
                            }
                            return 0.0;
                        }
                        case QSort: {
                            if (optype.equals("sort")) {
                                double sortCosts = 0.0;
                                sortCosts = onlyLeft ? 1.0 * (double)d1m + (double)d1m : 1.0 * (leftSparse ? (double)d1m * d1s : (double)d1m);
                                return sortCosts + (double)(d1m * (long)((int)(Math.log(d1m) / Math.log(2.0)))) + 1.0 * (double)d1m;
                            }
                            return 0.0;
                        }
                        case MatrixIndexing: {
                            if (optype.equals("leftIndex")) {
                                return 1.0 * (leftSparse ? (double)(d1m * d1n) * d1s : (double)(d1m * d1n)) + 2.0 * (rightSparse ? (double)(d2m * d2n) * d2s : (double)(d2m * d2n));
                            }
                            if (optype.equals("rightIndex")) {
                                return 1.0 * (leftSparse ? (double)(d2m * d2n) * d2s : (double)(d2m * d2n));
                            }
                            return 0.0;
                        }
                        case MMTSJ: {
                            if (MMTSJ.MMTSJType.valueOf(args[0]).isLeft()) {
                                if (!rightSparse) {
                                    return (double)(d1m * d1n) * d1s * (double)d1n / 2.0;
                                }
                                return (double)(d1m * d1n) * d1s * (double)d1n * d1s / 2.0;
                            }
                            if (onlyLeft) {
                                if (!leftSparse) {
                                    return (double)d1m * (double)d1n * (double)d1m / 2.0;
                                }
                                return (double)(d1m * d1n) * d1s + (double)(d1m * d1n) * d1s * (double)d1n * d1s / 2.0;
                            }
                            return 0.0;
                        }
                        case Partition: {
                            return (double)(d1m * d1n) * d1s + (inMR ? 0.0 : CostEstimatorStaticRuntime.getHDFSWriteTime(d1m, d1n, d1s) * 2.147483648E9);
                        }
                    }
                    throw new DMLRuntimeException("CostEstimator: unsupported instruction type: " + optype);
                }
                MRInstruction.MRType mrtype = MRInstructionParser.String2MRInstructionType.get(optype);
                if (mrtype == null) break block136;
                switch (mrtype) {
                    case Aggregate: {
                        int numMap = Integer.parseInt(args[0]);
                        if (optype.equals("ak+")) {
                            return (double)((long)(4 * numMap) * d1m * d1n) * d1s;
                        }
                        if (optype.equals("asqk+")) {
                            return (double)((long)(5 * numMap) * d1m * d1n) * d1s;
                        }
                        if (optype.equals("avar")) {
                            return (double)((long)(14 * numMap) * d1m * d1n) * d1s;
                        }
                        return (double)((long)numMap * d1m * d1n) * d1s;
                    }
                    case AggregateBinary: {
                        if (optype.equals("cpmm") || optype.equals("rmm") || optype.equals("mapmm")) {
                            if (!leftSparse && !rightSparse) {
                                return 2.0 * ((double)(d1m * d1n) * (d2n > 1L ? d1s : 1.0) * (double)d2n) / 2.0;
                            }
                            if (!leftSparse && rightSparse) {
                                return 2.0 * ((double)(d1m * d1n) * d1s * (double)d2n * d2s) / 2.0;
                            }
                            if (leftSparse && !rightSparse) {
                                return 2.0 * ((double)(d1m * d1n) * d1s * (double)d2n) / 2.0;
                            }
                            return 2.0 * ((double)(d1m * d1n) * d1s * (double)d2n * d2s) / 2.0;
                        }
                        return 0.0;
                    }
                    case MapMultChain: {
                        return (double)(2L * d1m * d2n * d1n) * (d2n > 1L ? d1s : 1.0) + (double)(d1m * d2n) + (double)(d1m * d2n) + (double)(2L * d2n * d1n * d1m) * (leftSparse ? d1s : 1.0) + (double)(d2n * d1n);
                    }
                    case Binary: {
                        return d3m * d3n;
                    }
                    case CombineUnary: {
                        return (double)(d1m * d1n) * d1s;
                    }
                    case CombineBinary: {
                        return (double)(d1m * d1n) * d1s + (double)(d2m * d2n) * d2s;
                    }
                    case CombineTernary: {
                        return (double)(d1m * d1n) * d1s + (double)(d2m * d2n) * d2s + (double)(d3m * d3n) * d3s;
                    }
                    case Unary: {
                        return d3m * d3n;
                    }
                    case Ctable: {
                        if (leftSparse) {
                            return (double)(d1m * d1n) * d1s;
                        }
                        return d1m * d1n;
                    }
                    case Quaternary: {
                        return (double)(d1m * d1n) * d1s * 4.0;
                    }
                    case Reblock: {
                        return 1.0 * (leftSparse ? (double)(d1m * d1n) * d1s : (double)(d1m * d1n));
                    }
                    case Replicate: {
                        return 1.0 * (leftSparse ? (double)(d1m * d1n) * d1s : (double)(d1m * d1n));
                    }
                    case CM_N_COV: {
                        double xcm = 8.0;
                        return leftSparse ? xcm * ((double)d1m * d1s + 1.0) : xcm * (double)d1m;
                    }
                    case GroupedAggregate: {
                        double xga = 1.0;
                        switch (Integer.parseInt(args[0])) {
                            case 0: {
                                xga = 4.0;
                                break;
                            }
                            case 1: {
                                xga = 1.0;
                                break;
                            }
                            case 2: {
                                xga = 8.0;
                                break;
                            }
                            case 3: {
                                xga = 16.0;
                                break;
                            }
                            case 4: {
                                xga = 31.0;
                                break;
                            }
                            case 5: {
                                xga = 51.0;
                                break;
                            }
                            case 6: {
                                xga = 16.0;
                            }
                        }
                        return (double)(2L * d1m) + xga * (double)d1m;
                    }
                    case PickByCount: {
                        break block137;
                    }
                    case RightIndex: {
                        if (optype.equals("rightIndex")) {
                            return 1.0 * (leftSparse ? (double)(d2m * d2n) * d2s : (double)(d2m * d2n));
                        }
                        return 1.0 * (leftSparse ? (double)(d1m * d1n) * d1s : (double)(d1m * d1n)) + 1.0 * (rightSparse ? (double)(d2m * d2n) * d2s : (double)(d2m * d2n));
                    }
                    case ZeroOut: {
                        return 1.0 * (leftSparse ? (double)(d1m * d1n) * d1s : (double)(d1m * d1n)) + 1.0 * (rightSparse ? (double)(d2m * d2n) * d2s : (double)(d2m * d2n));
                    }
                    default: {
                        return 0.0;
                    }
                }
            }
            throw new DMLRuntimeException("CostEstimator: unsupported instruction type: " + optype);
        }
        return -1.0;
    }
}

