/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.codegen.cplan;

import java.util.ArrayList;
import org.apache.sysml.hops.codegen.cplan.CNode;
import org.apache.sysml.hops.codegen.cplan.CNodeData;
import org.apache.sysml.hops.codegen.template.TemplateUtils;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.util.UtilFunctions;

public class CNodeNary
extends CNode {
    private final NaryType _type;

    public CNodeNary(CNode[] inputs, NaryType type) {
        for (CNode in : inputs) {
            this._inputs.add(in);
        }
        this._type = type;
        this.setOutputDims();
    }

    public NaryType getType() {
        return this._type;
    }

    @Override
    public String codegen(boolean sparse) {
        if (this.isGenerated()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (CNode in : this._inputs) {
            sb.append(in.codegen(sparse));
        }
        String var = this.createVarname();
        String tmp = this._type.getTemplate(sparse, this._cols, this._inputs);
        tmp = tmp.replace("%TMP%", var);
        sb.append(tmp);
        this._generated = true;
        return sb.toString();
    }

    public String toString() {
        switch (this._type) {
            case VECT_CBIND: {
                return "n(cbind)";
            }
        }
        return "m(" + this._type.name().toLowerCase() + ")";
    }

    @Override
    public void setOutputDims() {
        switch (this._type) {
            case VECT_CBIND: {
                this._rows = ((CNode)this._inputs.get((int)0))._rows;
                this._cols = 0L;
                for (CNode in : this._inputs) {
                    this._cols += in._cols;
                }
                this._dataType = Expression.DataType.MATRIX;
            }
        }
    }

    @Override
    public int hashCode() {
        if (this._hash == 0) {
            this._hash = UtilFunctions.intHashCode(super.hashCode(), this._type.hashCode());
        }
        return this._hash;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CNodeNary)) {
            return false;
        }
        CNodeNary that = (CNodeNary)o;
        return super.equals(that) && this._type == that._type;
    }

    public static enum NaryType {
        VECT_CBIND;


        public static boolean contains(String value) {
            for (NaryType bt : NaryType.values()) {
                if (!bt.name().equals(value)) continue;
                return true;
            }
            return false;
        }

        public String getTemplate(boolean sparseGen, long len, ArrayList<CNode> inputs) {
            switch (this) {
                case VECT_CBIND: {
                    StringBuilder sb = new StringBuilder();
                    sb.append("    double[] %TMP% = LibSpoofPrimitives.allocVector(" + len + ", true); //nary cbind\n");
                    int off = 0;
                    for (int i = 0; i < inputs.size(); ++i) {
                        String pos;
                        CNode input = inputs.get(i);
                        boolean sparseInput = sparseGen && input instanceof CNodeData && input.getVarname().startsWith("a");
                        String varj = input.getVarname();
                        String string = input instanceof CNodeData && input.getDataType().isMatrix() ? (!varj.startsWith("b") ? varj + "i" : (TemplateUtils.isMatrix(input) ? varj + ".pos(rix)" : "0")) : (pos = "0");
                        sb.append(sparseInput ? "    LibSpoofPrimitives.vectWrite(" + varj + "vals, %TMP%, " + varj + "ix, " + pos + ", " + off + ", " + input._cols + ");\n" : "    LibSpoofPrimitives.vectWrite(" + (varj.startsWith("b") ? varj + ".values(rix)" : varj) + ", %TMP%, " + pos + ", " + off + ", " + input._cols + ");\n");
                        off = (int)((long)off + input._cols);
                    }
                    return sb.toString();
                }
            }
            throw new RuntimeException("Invalid nary type: " + this.toString());
        }

        public boolean isVectorPrimitive() {
            return this == VECT_CBIND;
        }
    }
}

