/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.algorithms;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;

public class Stratstats
extends Script {
    public Stratstats() {
        String string = "scripts/algorithms/stratstats.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Matrix sqrt_failsafe(Object object) {
        String string = "source('scripts/algorithms/stratstats.dml') as mlcontextns;output_A = mlcontextns::sqrt_failsafe(input_A);";
        Script script = new Script(string);
        script.in("input_A", object).out("output_A");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("output_A");
        return matrix;
    }

    public String sqrt_failsafe__docs() {
        String string = "sqrt_failsafe = function (Matrix[double] input_A) return (Matrix[double] output_A)\n{\n    mask_A = (input_A >= 0);\n    prep_A = input_A * mask_A;\n    mask_A = mask_A * (prep_A == prep_A);\n    prep_A = replace (target = prep_A, pattern = 0.0/0.0, replacement = 0);\n    output_A = sqrt (prep_A) / mask_A;\n}\n";
        return string;
    }

    public String sqrt_failsafe__source() {
        String string = "sqrt_failsafe = function (Matrix[double] input_A) return (Matrix[double] output_A)\n{\n    mask_A = (input_A >= 0);\n    prep_A = input_A * mask_A;\n    mask_A = mask_A * (prep_A == prep_A);\n    prep_A = replace (target = prep_A, pattern = 0.0/0.0, replacement = 0);\n    output_A = sqrt (prep_A) / mask_A;\n}\n";
        return string;
    }

    public Matrix fStat_tailprob(Object object, Object object2, Object object3) {
        String string = "source('scripts/algorithms/stratstats.dml') as mlcontextns;tailprob = mlcontextns::fStat_tailprob(fStat, df_1, df_2);";
        Script script = new Script(string);
        script.in("fStat", object).in("df_1", object2).in("df_2", object3).out("tailprob");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("tailprob");
        return matrix;
    }

    public String fStat_tailprob__docs() {
        String string = "fStat_tailprob = function (Matrix[double] fStat, Matrix[double] df_1, Matrix[double] df_2) return (Matrix[double] tailprob)\n{ # TEMPORARY IMPLEMENTATION\n    tailprob = fStat;\n    for (i in 1:nrow(fStat)) {\n      for (j in 1:ncol(fStat)) {\n        q = as.scalar (fStat [i, j]);\n        d1 = as.scalar (df_1 [i, j]);\n        d2 = as.scalar (df_2 [i, j]);\n        if (d1 >= 1 & d2 >= 1 & q >= 0) {\n            tailprob  [i, j] = pf(target = q, df1 = d1, df2 = d2, lower.tail=FALSE);\n        } else {\n            tailprob  [i, j] = 0/0;\n        }\n    } }\n}\n";
        return string;
    }

    public String fStat_tailprob__source() {
        String string = "fStat_tailprob = function (Matrix[double] fStat, Matrix[double] df_1, Matrix[double] df_2) return (Matrix[double] tailprob)\n{ # TEMPORARY IMPLEMENTATION\n    tailprob = fStat;\n    for (i in 1:nrow(fStat)) {\n      for (j in 1:ncol(fStat)) {\n        q = as.scalar (fStat [i, j]);\n        d1 = as.scalar (df_1 [i, j]);\n        d2 = as.scalar (df_2 [i, j]);\n        if (d1 >= 1 & d2 >= 1 & q >= 0) {\n            tailprob  [i, j] = pf(target = q, df1 = d1, df2 = d2, lower.tail=FALSE);\n        } else {\n            tailprob  [i, j] = 0/0;\n        }\n    } }\n}\n";
        return string;
    }
}

