/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import java.util.ArrayList;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryMRInstructionBase;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;

public class ReplicateInstruction
extends UnaryMRInstructionBase {
    private boolean _repCols = true;
    private long _lenM = -1L;

    private ReplicateInstruction(byte in, byte out, boolean repCols, long lenM, String istr) {
        super(MRInstruction.MRType.Reorg, null, in, out);
        this.instString = istr;
        this._repCols = repCols;
        this._lenM = lenM;
    }

    public void computeOutputDimension(MatrixCharacteristics mcIn, MatrixCharacteristics mcOut) {
        if (this._repCols) {
            mcOut.set(mcIn.getRows(), this._lenM, mcIn.getRowsPerBlock(), mcIn.getColsPerBlock(), mcIn.getCols());
        } else {
            mcOut.set(this._lenM, mcIn.getCols(), mcIn.getRowsPerBlock(), mcIn.getColsPerBlock(), mcIn.getRows());
        }
    }

    public static ReplicateInstruction parseInstruction(String str) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(str, 4);
        String[] parts = InstructionUtils.getInstructionParts(str);
        byte in = Byte.parseByte(parts[1]);
        boolean repCols = Boolean.parseBoolean(parts[2]);
        long len = Long.parseLong(parts[3]);
        byte out = Byte.parseByte(parts[4]);
        return new ReplicateInstruction(in, out, repCols, len, str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        ArrayList<IndexedMatrixValue> blkList = cachedValues.get(this.input);
        if (blkList != null) {
            for (IndexedMatrixValue in : blkList) {
                MatrixIndexes repIX;
                IndexedMatrixValue repV;
                long i;
                long numRep;
                if (in == null) continue;
                IndexedMatrixValue out = this.input == this.output ? tempValue : cachedValues.holdPlace(this.output, valueClass);
                MatrixIndexes inIx = in.getIndexes();
                MatrixValue inVal = in.getValue();
                if (this._repCols) {
                    if (blockColFactor <= 1) {
                        LOG.warn("Block size of input matrix is: brlen=" + blockRowFactor + ", bclen=" + blockColFactor + ".");
                    }
                    numRep = (long)Math.ceil((double)this._lenM / (double)blockColFactor) - 1L;
                    for (i = 0L; i < numRep; ++i) {
                        repV = cachedValues.holdPlace(this.output, valueClass);
                        repIX = repV.getIndexes();
                        repIX.setIndexes(inIx.getRowIndex(), 2L + i);
                        repV.set(repIX, inVal);
                    }
                    out.set(inIx, inVal);
                } else {
                    if (blockRowFactor <= 1) {
                        LOG.warn("Block size of input matrix is: brlen=" + blockRowFactor + ", bclen=" + blockColFactor + ".");
                    }
                    numRep = (long)Math.ceil((double)this._lenM / (double)blockRowFactor) - 1L;
                    for (i = 0L; i < numRep; ++i) {
                        repV = cachedValues.holdPlace(this.output, valueClass);
                        repIX = repV.getIndexes();
                        repIX.setIndexes(2L + i, inIx.getColumnIndex());
                        repV.set(repIX, inVal);
                    }
                    out.set(inIx, inVal);
                }
                if (out != tempValue) continue;
                cachedValues.add(this.output, out);
            }
        }
    }
}

