/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MetaDataFormat;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.util.MapReduceTool;

public abstract class DataPartitioner {
    protected static final Log LOG = LogFactory.getLog(DataPartitioner.class.getName());
    protected static final double SPARSITY_CELL_THRESHOLD = 0.1;
    protected static final String NAME_SUFFIX = "_dp";
    protected ParForProgramBlock.PDataPartitionFormat _format = null;
    protected int _n = -1;
    protected boolean _allowBinarycell = true;

    protected DataPartitioner(ParForProgramBlock.PDataPartitionFormat dpf, int n) {
        this._format = dpf;
        this._n = n;
    }

    public MatrixObject createPartitionedMatrixObject(MatrixObject in, String fnameNew) throws DMLRuntimeException {
        return this.createPartitionedMatrixObject(in, fnameNew, false);
    }

    public MatrixObject createPartitionedMatrixObject(MatrixObject in, String fnameNew, boolean force) throws DMLRuntimeException {
        MatrixObject out = new MatrixObject(in.getValueType(), fnameNew);
        return this.createPartitionedMatrixObject(in, out, force);
    }

    public MatrixObject createPartitionedMatrixObject(MatrixObject in, MatrixObject out, boolean force) throws DMLRuntimeException {
        double sparsity;
        if (this._format == ParForProgramBlock.PDataPartitionFormat.NONE) {
            return in;
        }
        MetaDataFormat meta = (MetaDataFormat)in.getMetaData();
        MatrixCharacteristics mc = meta.getMatrixCharacteristics();
        InputInfo ii = meta.getInputInfo();
        OutputInfo oi = meta.getOutputInfo();
        long rows = mc.getRows();
        long cols = mc.getCols();
        int brlen = mc.getRowsPerBlock();
        int bclen = mc.getColsPerBlock();
        long nonZeros = mc.getNonZeros();
        double d = sparsity = mc.dimsKnown(true) ? (double)nonZeros / (double)(rows * cols) : 1.0;
        if (!force) {
            if (rows < 2000L && cols < 2000L) {
                return in;
            }
            if (this._format == ParForProgramBlock.PDataPartitionFormat.ROW_WISE && cols < 2000L) {
                LOG.debug("Changing format from " + (Object)((Object)ParForProgramBlock.PDataPartitionFormat.ROW_WISE) + " to " + (Object)((Object)ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE) + ".");
                this._format = ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE;
            }
            if (this._format == ParForProgramBlock.PDataPartitionFormat.COLUMN_WISE && rows < 2000L) {
                LOG.debug("Changing format from " + (Object)((Object)ParForProgramBlock.PDataPartitionFormat.COLUMN_WISE) + " to " + (Object)((Object)ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE) + ".");
                this._format = ParForProgramBlock.PDataPartitionFormat.COLUMN_BLOCK_WISE;
            }
        }
        boolean convertBlock2Cell = false;
        if (ii == InputInfo.BinaryBlockInputInfo && this._allowBinarycell && this._format == ParForProgramBlock.PDataPartitionFormat.COLUMN_WISE && sparsity < 0.1) {
            LOG.debug("Changing partition outputinfo from binaryblock to binarycell due to sparsity=" + sparsity);
            oi = OutputInfo.BinaryCellOutputInfo;
            convertBlock2Cell = true;
        }
        String fnameNew = out.getFileName();
        try {
            MapReduceTool.deleteFileIfExistOnHDFS(fnameNew);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        this.partitionMatrix(in, fnameNew, ii, oi, rows, cols, brlen, bclen);
        out.setPartitioned(this._format, this._n);
        MatrixCharacteristics mcNew = new MatrixCharacteristics(rows, cols, brlen, bclen);
        mcNew.setNonZeros(nonZeros);
        if (convertBlock2Cell) {
            ii = InputInfo.BinaryCellInputInfo;
        }
        MetaDataFormat metaNew = new MetaDataFormat(mcNew, oi, ii);
        out.setMetaData(metaNew);
        return out;
    }

    public void disableBinaryCell() {
        this._allowBinarycell = false;
    }

    protected abstract void partitionMatrix(MatrixObject var1, String var2, InputInfo var3, OutputInfo var4, long var5, long var7, int var9, int var10) throws DMLRuntimeException;

    public static MatrixBlock createReuseMatrixBlock(ParForProgramBlock.PDataPartitionFormat dpf, int rows, int cols) {
        MatrixBlock tmp = null;
        switch (dpf) {
            case ROW_WISE: {
                tmp = new MatrixBlock(1, cols, true, (int)((double)cols * 0.1));
                break;
            }
            case COLUMN_WISE: {
                tmp = new MatrixBlock(rows, 1, false);
                break;
            }
        }
        return tmp;
    }
}

