/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.ParseInfo;
import org.apache.sysml.parser.VariableSet;

public abstract class Statement
implements ParseInfo {
    protected static final Log LOG = LogFactory.getLog(Statement.class.getName());
    public static final String OUTPUTSTATEMENT = "WRITE";
    public static final String SEQ_FROM = "from";
    public static final String SEQ_TO = "to";
    public static final String SEQ_INCR = "incr";
    public static final String SOURCE = "source";
    public static final String SETWD = "setwd";
    public static final String MATRIX_DATA_TYPE = "matrix";
    public static final String FRAME_DATA_TYPE = "frame";
    public static final String SCALAR_DATA_TYPE = "scalar";
    public static final String DOUBLE_VALUE_TYPE = "double";
    public static final String BOOLEAN_VALUE_TYPE = "boolean";
    public static final String INT_VALUE_TYPE = "int";
    public static final String STRING_VALUE_TYPE = "string";
    public static final String GAGG_TARGET = "target";
    public static final String GAGG_GROUPS = "groups";
    public static final String GAGG_WEIGHTS = "weights";
    public static final String GAGG_FN = "fn";
    public static final String GAGG_FN_SUM = "sum";
    public static final String GAGG_FN_COUNT = "count";
    public static final String GAGG_FN_MEAN = "mean";
    public static final String GAGG_FN_VARIANCE = "variance";
    public static final String GAGG_FN_CM = "centralmoment";
    public static final String GAGG_FN_CM_ORDER = "order";
    public static final String GAGG_NUM_GROUPS = "ngroups";
    private boolean isEmptyNewLineStatement = false;
    private String _filename;
    private int _beginLine;
    private int _beginColumn;
    private int _endLine;
    private int _endColumn;
    private String _text;

    public abstract boolean controlStatement();

    public abstract VariableSet variablesRead();

    public abstract VariableSet variablesUpdated();

    public abstract void initializeforwardLV(VariableSet var1) throws LanguageException;

    public abstract VariableSet initializebackwardLV(VariableSet var1) throws LanguageException;

    public abstract Statement rewriteStatement(String var1) throws LanguageException;

    public boolean isEmptyNewLineStatement() {
        return this.isEmptyNewLineStatement;
    }

    public void setEmptyNewLineStatement(boolean isEmptyNewLineStatement) {
        this.isEmptyNewLineStatement = isEmptyNewLineStatement;
    }

    @Override
    public void setFilename(String passed) {
        this._filename = passed;
    }

    @Override
    public void setBeginLine(int passed) {
        this._beginLine = passed;
    }

    @Override
    public void setBeginColumn(int passed) {
        this._beginColumn = passed;
    }

    @Override
    public void setEndLine(int passed) {
        this._endLine = passed;
    }

    @Override
    public void setEndColumn(int passed) {
        this._endColumn = passed;
    }

    public void setCtxValues(ParserRuleContext ctx) {
        this.setBeginLine(ctx.start.getLine());
        this.setBeginColumn(ctx.start.getCharPositionInLine());
        this.setEndLine(ctx.stop.getLine());
        this.setEndColumn(ctx.stop.getCharPositionInLine());
        if (ctx.start != null && ctx.stop != null && ctx.start.getStartIndex() != -1 && ctx.stop.getStopIndex() != -1 && ctx.start.getStartIndex() <= ctx.stop.getStopIndex() && ctx.start.getInputStream() != null) {
            String text = ctx.start.getInputStream().getText(Interval.of(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
            if (text != null) {
                text = text.trim();
            }
            this.setText(text);
        } else {
            String text = ctx.getText();
            if (text != null) {
                text = text.trim();
            }
            this.setText(text);
        }
    }

    public void setCtxValuesAndFilename(ParserRuleContext ctx, String filename) {
        this.setCtxValues(ctx);
        this.setFilename(filename);
    }

    @Override
    public int getBeginLine() {
        return this._beginLine;
    }

    @Override
    public int getBeginColumn() {
        return this._beginColumn;
    }

    @Override
    public int getEndLine() {
        return this._endLine;
    }

    @Override
    public int getEndColumn() {
        return this._endColumn;
    }

    @Override
    public String getFilename() {
        return this._filename;
    }

    public String printErrorLocation() {
        String file = this._filename;
        file = file == null ? "" : file + " ";
        if (this.getText() != null) {
            return "ERROR: " + file + "[line " + this._beginLine + ":" + this._beginColumn + "] -> " + this.getText() + " -- ";
        }
        return "ERROR: " + file + "[line " + this._beginLine + ":" + this._beginColumn + "] -- ";
    }

    public String printWarningLocation() {
        String file = this._filename;
        file = file == null ? "" : file + " ";
        if (this.getText() != null) {
            return "WARNING: " + file + "[line " + this._beginLine + ":" + this._beginColumn + "] -> " + this.getText() + " -- ";
        }
        return "WARNING: " + file + "[line " + this._beginLine + ":" + this._beginColumn + "] -- ";
    }

    public void raiseValidateError(String msg, boolean conditional) throws LanguageException {
        this.raiseValidateError(msg, conditional, null);
    }

    public void raiseValidateError(String msg, boolean conditional, String errorCode) throws LanguageException {
        if (!conditional) {
            String fullMsg = this.printErrorLocation() + msg;
            if (errorCode != null) {
                throw new LanguageException(fullMsg, errorCode);
            }
            throw new LanguageException(fullMsg);
        }
        String fullMsg = this.printWarningLocation() + msg;
        LOG.warn(fullMsg);
    }

    @Override
    public String getText() {
        return this._text;
    }

    @Override
    public void setText(String text) {
        this._text = text;
    }

    public void setParseInfo(ParseInfo parseInfo) {
        this._beginLine = parseInfo.getBeginLine();
        this._beginColumn = parseInfo.getBeginColumn();
        this._endLine = parseInfo.getEndLine();
        this._endColumn = parseInfo.getEndColumn();
        this._text = parseInfo.getText();
        this._filename = parseInfo.getFilename();
    }
}

