/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.OutputParameters;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class ReBlock
extends Lop {
    public static final String OPCODE = "rblk";
    private boolean _outputEmptyBlocks = true;
    private Long _rows_per_block;
    private Long _cols_per_block;

    public ReBlock(Lop input, Long rows_per_block, Long cols_per_block, Expression.DataType dt, Expression.ValueType vt, boolean outputEmptyBlocks, LopProperties.ExecType et) throws LopsException {
        super(Lop.Type.ReBlock, dt, vt);
        this.addInput(input);
        input.addOutput(this);
        this._rows_per_block = rows_per_block;
        this._cols_per_block = cols_per_block;
        this._outputEmptyBlocks = outputEmptyBlocks;
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = true;
        this.lps.addCompatibility(JobType.REBLOCK);
        if (et == LopProperties.ExecType.MR) {
            this.lps.setProperties(this.inputs, LopProperties.ExecType.MR, LopProperties.ExecLocation.MapAndReduce, breaksAlignment, aligner, definesMRJob);
        } else if (et == LopProperties.ExecType.SPARK) {
            this.lps.setProperties(this.inputs, LopProperties.ExecType.SPARK, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        } else {
            throw new LopsException("Incorrect execution type for Reblock:" + (Object)((Object)et));
        }
    }

    @Override
    public String toString() {
        return "Reblock - rows per block = " + this._rows_per_block + " cols per block  " + this._cols_per_block;
    }

    @Override
    public String getInstructions(int input_index, int output_index) {
        return this.getInstructions(String.valueOf(input_index), String.valueOf(output_index));
    }

    @Override
    public String getInstructions(String input1, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        sb.append(this._rows_per_block);
        sb.append("\u00b0");
        sb.append(this._cols_per_block);
        sb.append("\u00b0");
        sb.append(this._outputEmptyBlocks);
        return sb.toString();
    }

    private OutputParameters.Format getChildFormat(Lop node) throws LopsException {
        if (node.getOutputParameters().getFile_name() != null || node.getOutputParameters().getLabel() != null) {
            return node.getOutputParameters().getFormat();
        }
        if (node.getInputs().size() > 1) {
            throw new LopsException(this.printErrorLocation() + "Should only have one child! \n");
        }
        return node.getInputs().get(0).getOutputParameters().getFormat();
    }
}

