/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.rewrite;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.rewrite.HopRewriteRule;
import org.apache.sysml.hops.rewrite.ProgramRewriteStatus;

public class RewriteCommonSubexpressionElimination
extends HopRewriteRule {
    private boolean _mergeLeafs = true;

    public RewriteCommonSubexpressionElimination() {
        this(true);
    }

    public RewriteCommonSubexpressionElimination(boolean mergeLeafs) {
        this._mergeLeafs = mergeLeafs;
    }

    @Override
    public ArrayList<Hop> rewriteHopDAGs(ArrayList<Hop> roots, ProgramRewriteStatus state) throws HopsException {
        if (roots == null) {
            return null;
        }
        HashMap<String, Hop> dataops = new HashMap<String, Hop>();
        HashMap<String, Hop> literalops = new HashMap<String, Hop>();
        for (Hop h : roots) {
            int cseMerged = 0;
            if (this._mergeLeafs) {
                cseMerged += this.rule_CommonSubexpressionElimination_MergeLeafs(h, dataops, literalops);
                h.resetVisitStatus();
            }
            if ((cseMerged += this.rule_CommonSubexpressionElimination(h)) <= 0) continue;
            LOG.debug("Common Subexpression Elimination - removed " + cseMerged + " operators.");
        }
        return roots;
    }

    @Override
    public Hop rewriteHopDAG(Hop root, ProgramRewriteStatus state) throws HopsException {
        if (root == null) {
            return null;
        }
        HashMap<String, Hop> dataops = new HashMap<String, Hop>();
        HashMap<String, Hop> literalops = new HashMap<String, Hop>();
        int cseMerged = 0;
        if (this._mergeLeafs) {
            cseMerged += this.rule_CommonSubexpressionElimination_MergeLeafs(root, dataops, literalops);
            root.resetVisitStatus();
        }
        if ((cseMerged += this.rule_CommonSubexpressionElimination(root)) > 0) {
            LOG.debug("Common Subexpression Elimination - removed " + cseMerged + " operators.");
        }
        return root;
    }

    private int rule_CommonSubexpressionElimination_MergeLeafs(Hop hop, HashMap<String, Hop> dataops, HashMap<String, Hop> literalops) throws HopsException {
        int ret;
        block9: {
            block7: {
                block8: {
                    ret = 0;
                    if (hop.isVisited()) {
                        return ret;
                    }
                    if (!hop.getInput().isEmpty()) break block7;
                    if (!(hop instanceof LiteralOp)) break block8;
                    String key = (Object)((Object)hop.getValueType()) + "_" + hop.getName();
                    if (!literalops.containsKey(key)) {
                        literalops.put(key, hop);
                    }
                    break block9;
                }
                if (!(hop instanceof DataOp) || !((DataOp)hop).isRead() || dataops.containsKey(hop.getName())) break block9;
                dataops.put(hop.getName(), hop);
                break block9;
            }
            for (int i = 0; i < hop.getInput().size(); ++i) {
                Hop tmp;
                Hop hi = hop.getInput().get(i);
                String litKey = (Object)((Object)hi.getValueType()) + "_" + hi.getName();
                if (hi instanceof DataOp && ((DataOp)hi).isRead() && dataops.containsKey(hi.getName())) {
                    tmp = dataops.get(hi.getName());
                    if (tmp != hi) {
                        tmp.getParent().add(hop);
                        tmp.setVisited();
                        hop.getInput().set(i, tmp);
                        ++ret;
                    }
                } else if (hi instanceof LiteralOp && literalops.containsKey(litKey) && (tmp = literalops.get(litKey)) != hi) {
                    tmp.getParent().add(hop);
                    tmp.setVisited();
                    hop.getInput().set(i, tmp);
                    ++ret;
                }
                ret += this.rule_CommonSubexpressionElimination_MergeLeafs(hi, dataops, literalops);
            }
        }
        hop.setVisited();
        return ret;
    }

    private int rule_CommonSubexpressionElimination(Hop hop) throws HopsException {
        int ret = 0;
        if (hop.isVisited()) {
            return ret;
        }
        for (Hop hi : hop.getInput()) {
            ret += this.rule_CommonSubexpressionElimination(hi);
        }
        if (hop.getParent().size() > 1) {
            for (int i = 0; i < hop.getParent().size() - 1; ++i) {
                for (int j = i + 1; j < hop.getParent().size(); ++j) {
                    Hop h2;
                    Hop h1 = hop.getParent().get(i);
                    if (h1 == (h2 = hop.getParent().get(j)) || !h1.compare(h2)) continue;
                    hop.getParent().remove(j);
                    ArrayList<Hop> parent = h2.getParent();
                    for (Hop p : parent) {
                        for (int k = 0; k < p.getInput().size(); ++k) {
                            if (p.getInput().get(k) != h2) continue;
                            p.getInput().set(k, h1);
                            h1.getParent().add(p);
                            h1.setVisited();
                        }
                    }
                    for (Hop in : h2.getInput()) {
                        in.getParent().remove(h2);
                    }
                    ++ret;
                    --j;
                }
            }
        }
        hop.setVisited();
        return ret;
    }
}

