/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.globalopt;

import java.util.ArrayList;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.FunctionOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.globalopt.InterestingProperties;
import org.apache.sysml.hops.globalopt.RewriteConfig;
import org.apache.sysml.hops.globalopt.gdfgraph.GDFNode;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;

public class Plan {
    private static IDSequence _seqID = new IDSequence();
    private long _ID = _seqID.getNextID();
    private GDFNode _node = null;
    private InterestingProperties _ips = null;
    private RewriteConfig _conf = null;
    private ArrayList<Plan> _childs = null;
    private double _costs = -1.0;

    public Plan(GDFNode node, InterestingProperties ips, RewriteConfig rc, ArrayList<Plan> childs) {
        this._node = node;
        this._ips = ips;
        this._conf = rc;
        this._childs = childs != null && !childs.isEmpty() ? childs : new ArrayList();
    }

    public Plan(Plan p) {
        this._node = p._node;
        this._ips = new InterestingProperties(p._ips);
        this._conf = new RewriteConfig(p._conf);
        this._costs = p._costs;
        this._childs = p._childs != null && !p._childs.isEmpty() ? new ArrayList<Plan>(p._childs) : new ArrayList();
    }

    public GDFNode getNode() {
        return this._node;
    }

    public void addChild(Plan c) {
        this._childs.add(c);
    }

    public ArrayList<Plan> getChilds() {
        return this._childs;
    }

    public InterestingProperties getInterestingProperties() {
        return this._ips;
    }

    public RewriteConfig getRewriteConfig() {
        return this._conf;
    }

    public void setCosts(double costs) {
        this._costs = costs;
    }

    public double getCosts() {
        return this._costs;
    }

    public boolean checkValidBlocksizesInMR() {
        int size0;
        LopProperties.ExecType CLUSTER;
        boolean ret = true;
        LopProperties.ExecType execType = CLUSTER = OptimizerUtils.isSparkExecutionMode() ? LopProperties.ExecType.SPARK : LopProperties.ExecType.MR;
        if (this._conf.getExecType() == CLUSTER && this._childs != null && this._childs.size() > 1 && (size0 = this._childs.get((int)0)._conf.getBlockSize()) > 0) {
            for (Plan c : this._childs) {
                ret &= c._conf.getBlockSize() == size0 || c._conf.getBlockSize() <= 0;
            }
        }
        return ret;
    }

    public boolean checkValidBlocksizesTRead() {
        boolean ret = true;
        if (this._node.getNodeType() == GDFNode.NodeType.HOP_NODE && this._node.getHop() instanceof DataOp && ((DataOp)this._node.getHop()).getDataOpType() == Hop.DataOpTypes.TRANSIENTREAD) {
            for (Plan c : this._childs) {
                ret &= this._conf.getBlockSize() == c._conf.getBlockSize();
            }
        }
        if (this._node.getNodeType() == GDFNode.NodeType.CROSS_BLOCK_NODE) {
            for (Plan c : this._childs) {
                ret &= this._conf.getBlockSize() == c._conf.getBlockSize();
            }
        }
        return ret;
    }

    public boolean checkValidFormatInMR() {
        LopProperties.ExecType CLUSTER;
        boolean ret = true;
        LopProperties.ExecType execType = CLUSTER = OptimizerUtils.isSparkExecutionMode() ? LopProperties.ExecType.SPARK : LopProperties.ExecType.MR;
        if (this._conf.getExecType() == CLUSTER && this._childs != null) {
            for (Plan c : this._childs) {
                ret &= this._node.isValidInputFormatForOperation(c._conf.getFormat());
            }
        }
        return ret;
    }

    public boolean checkValidExecutionType() {
        boolean ret = true;
        return ret &= !(this._node.getHop() instanceof FunctionOp) || this._conf.getExecType() == LopProperties.ExecType.CP;
    }

    public boolean isPreferredPlan() {
        boolean ret = true;
        for (Plan c : this._childs) {
            if (c.getNode().getDataType() != Expression.DataType.MATRIX) continue;
            ret &= this._ips.equals(c.getInterestingProperties());
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PLAN(" + this._ID + ") [");
        sb.append(this._ips.toString());
        sb.append(",");
        sb.append(this._conf.toString());
        sb.append(",{");
        for (Plan c : this._childs) {
            sb.append(c._ID);
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        sb.append("},");
        sb.append(this._costs);
        sb.append("]");
        return sb.toString();
    }
}

