/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MetaData;
import org.apache.sysml.runtime.matrix.MetaDataFormat;
import org.apache.sysml.runtime.matrix.MetaDataNumItemsByEachReducer;
import org.apache.sysml.runtime.matrix.data.OutputInfo;

public class JobReturn {
    public boolean successful;
    public MetaData[] metadata = null;

    public JobReturn() {
        this.successful = false;
        this.metadata = null;
    }

    public JobReturn(MatrixCharacteristics[] sts, boolean success) {
        this.successful = success;
        this.metadata = new MetaData[sts.length];
        for (int i = 0; i < sts.length; ++i) {
            this.metadata[i] = new MetaData(sts[i]);
        }
    }

    public JobReturn(MatrixCharacteristics[] sts, OutputInfo[] infos, boolean success) throws DMLRuntimeException {
        this.successful = success;
        this.metadata = new MetaDataFormat[sts.length];
        for (int i = 0; i < sts.length; ++i) {
            this.metadata[i] = new MetaDataFormat(sts[i], infos[i], OutputInfo.getMatchingInputInfo(infos[i]));
        }
    }

    public JobReturn(MatrixCharacteristics sts, OutputInfo info, boolean success) throws DMLRuntimeException {
        this.successful = success;
        this.metadata = new MetaDataFormat[1];
        this.metadata[0] = new MetaDataFormat(sts, info, OutputInfo.getMatchingInputInfo(info));
    }

    public JobReturn(MatrixCharacteristics mc, long[] items, int partition0, long number0s, boolean success) {
        this.successful = success;
        this.metadata = new MetaDataNumItemsByEachReducer[1];
        this.metadata[0] = new MetaDataNumItemsByEachReducer(mc, items, partition0, number0s);
    }

    public boolean checkReturnStatus() throws DMLRuntimeException {
        if (!this.successful) {
            throw new DMLRuntimeException("Error in executing the DML program.");
        }
        return this.successful;
    }

    public MetaData[] getMetaData() {
        return this.metadata;
    }

    public MetaData getMetaData(int i) {
        return this.metadata[i];
    }
}

