/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions;

import java.util.HashMap;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionParser;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.gpu.AggregateBinaryGPUInstruction;
import org.apache.sysml.runtime.instructions.gpu.AggregateUnaryGPUInstruction;
import org.apache.sysml.runtime.instructions.gpu.ArithmeticBinaryGPUInstruction;
import org.apache.sysml.runtime.instructions.gpu.BuiltinBinaryGPUInstruction;
import org.apache.sysml.runtime.instructions.gpu.BuiltinUnaryGPUInstruction;
import org.apache.sysml.runtime.instructions.gpu.ConvolutionGPUInstruction;
import org.apache.sysml.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysml.runtime.instructions.gpu.MMTSJGPUInstruction;
import org.apache.sysml.runtime.instructions.gpu.MatrixAppendGPUInstruction;
import org.apache.sysml.runtime.instructions.gpu.MatrixIndexingGPUInstruction;
import org.apache.sysml.runtime.instructions.gpu.MatrixMatrixAxpyGPUInstruction;
import org.apache.sysml.runtime.instructions.gpu.RelationalBinaryGPUInstruction;
import org.apache.sysml.runtime.instructions.gpu.ReorgGPUInstruction;

public class GPUInstructionParser
extends InstructionParser {
    static final HashMap<String, GPUInstruction.GPUINSTRUCTION_TYPE> String2GPUInstructionType = new HashMap();

    public static GPUInstruction parseSingleInstruction(String str) throws DMLRuntimeException {
        if (str == null || str.isEmpty()) {
            return null;
        }
        GPUInstruction.GPUINSTRUCTION_TYPE cptype = InstructionUtils.getGPUType(str);
        if (cptype == null) {
            throw new DMLRuntimeException("Unable derive cptype for instruction: " + str);
        }
        GPUInstruction cpinst = GPUInstructionParser.parseSingleInstruction(cptype, str);
        if (cpinst == null) {
            throw new DMLRuntimeException("Unable to parse instruction: " + str);
        }
        return cpinst;
    }

    public static GPUInstruction parseSingleInstruction(GPUInstruction.GPUINSTRUCTION_TYPE gputype, String str) throws DMLRuntimeException {
        if (str == null || str.isEmpty()) {
            return null;
        }
        if (gputype == null) {
            throw new DMLRuntimeException("The instruction is not GPU-enabled:" + str);
        }
        switch (gputype) {
            case AggregateUnary: {
                return AggregateUnaryGPUInstruction.parseInstruction(str);
            }
            case AggregateBinary: {
                return AggregateBinaryGPUInstruction.parseInstruction(str);
            }
            case BuiltinUnary: {
                return BuiltinUnaryGPUInstruction.parseInstruction(str);
            }
            case BuiltinBinary: {
                return BuiltinBinaryGPUInstruction.parseInstruction(str);
            }
            case Append: {
                return MatrixAppendGPUInstruction.parseInstruction(str);
            }
            case Convolution: {
                return ConvolutionGPUInstruction.parseInstruction(str);
            }
            case MMTSJ: {
                return MMTSJGPUInstruction.parseInstruction(str);
            }
            case Reorg: {
                return ReorgGPUInstruction.parseInstruction(str);
            }
            case ArithmeticBinary: {
                String opcode = InstructionUtils.getOpCode(str);
                if (opcode.equals("+*") || opcode.equals("-*")) {
                    return MatrixMatrixAxpyGPUInstruction.parseInstruction(str);
                }
                return ArithmeticBinaryGPUInstruction.parseInstruction(str);
            }
            case RelationalBinary: {
                return RelationalBinaryGPUInstruction.parseInstruction(str);
            }
            case MatrixIndexing: {
                return MatrixIndexingGPUInstruction.parseInstruction(str);
            }
        }
        throw new DMLRuntimeException("Invalid GPU Instruction Type: " + (Object)((Object)gputype));
    }

    static {
        String2GPUInstructionType.put("relu_backward", GPUInstruction.GPUINSTRUCTION_TYPE.Convolution);
        String2GPUInstructionType.put("conv2d", GPUInstruction.GPUINSTRUCTION_TYPE.Convolution);
        String2GPUInstructionType.put("conv2d_bias_add", GPUInstruction.GPUINSTRUCTION_TYPE.Convolution);
        String2GPUInstructionType.put("conv2d_backward_filter", GPUInstruction.GPUINSTRUCTION_TYPE.Convolution);
        String2GPUInstructionType.put("conv2d_backward_data", GPUInstruction.GPUINSTRUCTION_TYPE.Convolution);
        String2GPUInstructionType.put("maxpooling", GPUInstruction.GPUINSTRUCTION_TYPE.Convolution);
        String2GPUInstructionType.put("maxpooling_backward", GPUInstruction.GPUINSTRUCTION_TYPE.Convolution);
        String2GPUInstructionType.put("avgpooling", GPUInstruction.GPUINSTRUCTION_TYPE.Convolution);
        String2GPUInstructionType.put("avgpooling_backward", GPUInstruction.GPUINSTRUCTION_TYPE.Convolution);
        String2GPUInstructionType.put("bias_add", GPUInstruction.GPUINSTRUCTION_TYPE.Convolution);
        String2GPUInstructionType.put("bias_multiply", GPUInstruction.GPUINSTRUCTION_TYPE.Convolution);
        String2GPUInstructionType.put("channel_sums", GPUInstruction.GPUINSTRUCTION_TYPE.Convolution);
        String2GPUInstructionType.put("ba+*", GPUInstruction.GPUINSTRUCTION_TYPE.AggregateBinary);
        String2GPUInstructionType.put("tsmm", GPUInstruction.GPUINSTRUCTION_TYPE.MMTSJ);
        String2GPUInstructionType.put("r'", GPUInstruction.GPUINSTRUCTION_TYPE.Reorg);
        String2GPUInstructionType.put("append", GPUInstruction.GPUINSTRUCTION_TYPE.Append);
        String2GPUInstructionType.put("+", GPUInstruction.GPUINSTRUCTION_TYPE.ArithmeticBinary);
        String2GPUInstructionType.put("-", GPUInstruction.GPUINSTRUCTION_TYPE.ArithmeticBinary);
        String2GPUInstructionType.put("*", GPUInstruction.GPUINSTRUCTION_TYPE.ArithmeticBinary);
        String2GPUInstructionType.put("/", GPUInstruction.GPUINSTRUCTION_TYPE.ArithmeticBinary);
        String2GPUInstructionType.put("%%", GPUInstruction.GPUINSTRUCTION_TYPE.ArithmeticBinary);
        String2GPUInstructionType.put("%/%", GPUInstruction.GPUINSTRUCTION_TYPE.ArithmeticBinary);
        String2GPUInstructionType.put("^", GPUInstruction.GPUINSTRUCTION_TYPE.ArithmeticBinary);
        String2GPUInstructionType.put("1-*", GPUInstruction.GPUINSTRUCTION_TYPE.ArithmeticBinary);
        String2GPUInstructionType.put("^2", GPUInstruction.GPUINSTRUCTION_TYPE.ArithmeticBinary);
        String2GPUInstructionType.put("*2", GPUInstruction.GPUINSTRUCTION_TYPE.ArithmeticBinary);
        String2GPUInstructionType.put("-nz", GPUInstruction.GPUINSTRUCTION_TYPE.ArithmeticBinary);
        String2GPUInstructionType.put("+*", GPUInstruction.GPUINSTRUCTION_TYPE.ArithmeticBinary);
        String2GPUInstructionType.put("-*", GPUInstruction.GPUINSTRUCTION_TYPE.ArithmeticBinary);
        String2GPUInstructionType.put("exp", GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary);
        String2GPUInstructionType.put("log", GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary);
        String2GPUInstructionType.put("abs", GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary);
        String2GPUInstructionType.put("sqrt", GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary);
        String2GPUInstructionType.put("round", GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary);
        String2GPUInstructionType.put("floor", GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary);
        String2GPUInstructionType.put("ceil", GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary);
        String2GPUInstructionType.put("sin", GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary);
        String2GPUInstructionType.put("cos", GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary);
        String2GPUInstructionType.put("tan", GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary);
        String2GPUInstructionType.put("sinh", GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary);
        String2GPUInstructionType.put("cosh", GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary);
        String2GPUInstructionType.put("tanh", GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary);
        String2GPUInstructionType.put("asin", GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary);
        String2GPUInstructionType.put("acos", GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary);
        String2GPUInstructionType.put("atan", GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary);
        String2GPUInstructionType.put("sign", GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary);
        String2GPUInstructionType.put("sigmoid", GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary);
        String2GPUInstructionType.put("softmax", GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary);
        String2GPUInstructionType.put("solve", GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinBinary);
        String2GPUInstructionType.put("min", GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinBinary);
        String2GPUInstructionType.put("max", GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinBinary);
        String2GPUInstructionType.put("ua+", GPUInstruction.GPUINSTRUCTION_TYPE.AggregateUnary);
        String2GPUInstructionType.put("uak+", GPUInstruction.GPUINSTRUCTION_TYPE.AggregateUnary);
        String2GPUInstructionType.put("uar+", GPUInstruction.GPUINSTRUCTION_TYPE.AggregateUnary);
        String2GPUInstructionType.put("uark+", GPUInstruction.GPUINSTRUCTION_TYPE.AggregateUnary);
        String2GPUInstructionType.put("uac+", GPUInstruction.GPUINSTRUCTION_TYPE.AggregateUnary);
        String2GPUInstructionType.put("uack+", GPUInstruction.GPUINSTRUCTION_TYPE.AggregateUnary);
        String2GPUInstructionType.put("ua*", GPUInstruction.GPUINSTRUCTION_TYPE.AggregateUnary);
        String2GPUInstructionType.put("uamean", GPUInstruction.GPUINSTRUCTION_TYPE.AggregateUnary);
        String2GPUInstructionType.put("uarmean", GPUInstruction.GPUINSTRUCTION_TYPE.AggregateUnary);
        String2GPUInstructionType.put("uacmean", GPUInstruction.GPUINSTRUCTION_TYPE.AggregateUnary);
        String2GPUInstructionType.put("uamax", GPUInstruction.GPUINSTRUCTION_TYPE.AggregateUnary);
        String2GPUInstructionType.put("uarmax", GPUInstruction.GPUINSTRUCTION_TYPE.AggregateUnary);
        String2GPUInstructionType.put("uacmax", GPUInstruction.GPUINSTRUCTION_TYPE.AggregateUnary);
        String2GPUInstructionType.put("uamin", GPUInstruction.GPUINSTRUCTION_TYPE.AggregateUnary);
        String2GPUInstructionType.put("uarmin", GPUInstruction.GPUINSTRUCTION_TYPE.AggregateUnary);
        String2GPUInstructionType.put("uacmin", GPUInstruction.GPUINSTRUCTION_TYPE.AggregateUnary);
        String2GPUInstructionType.put("uasqk+", GPUInstruction.GPUINSTRUCTION_TYPE.AggregateUnary);
        String2GPUInstructionType.put("uarsqk+", GPUInstruction.GPUINSTRUCTION_TYPE.AggregateUnary);
        String2GPUInstructionType.put("uacsqk+", GPUInstruction.GPUINSTRUCTION_TYPE.AggregateUnary);
        String2GPUInstructionType.put("uavar", GPUInstruction.GPUINSTRUCTION_TYPE.AggregateUnary);
        String2GPUInstructionType.put("uarvar", GPUInstruction.GPUINSTRUCTION_TYPE.AggregateUnary);
        String2GPUInstructionType.put("uacvar", GPUInstruction.GPUINSTRUCTION_TYPE.AggregateUnary);
        String2GPUInstructionType.put("==", GPUInstruction.GPUINSTRUCTION_TYPE.RelationalBinary);
        String2GPUInstructionType.put("!=", GPUInstruction.GPUINSTRUCTION_TYPE.RelationalBinary);
        String2GPUInstructionType.put("<", GPUInstruction.GPUINSTRUCTION_TYPE.RelationalBinary);
        String2GPUInstructionType.put(">", GPUInstruction.GPUINSTRUCTION_TYPE.RelationalBinary);
        String2GPUInstructionType.put("<=", GPUInstruction.GPUINSTRUCTION_TYPE.RelationalBinary);
        String2GPUInstructionType.put(">=", GPUInstruction.GPUINSTRUCTION_TYPE.RelationalBinary);
        String2GPUInstructionType.put("rightIndex", GPUInstruction.GPUINSTRUCTION_TYPE.MatrixIndexing);
    }
}

