/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.functionobjects;

import java.util.HashMap;
import org.apache.commons.math3.util.FastMath;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.DMLScriptException;
import org.apache.sysml.runtime.functionobjects.ValueFunction;

public class Builtin
extends ValueFunction {
    private static final long serialVersionUID = 3836744687789840574L;
    public BuiltinCode bFunc;
    private static final boolean FASTMATH = true;
    public static HashMap<String, BuiltinCode> String2BuiltinCode = new HashMap();
    private static Builtin sinObj;
    private static Builtin cosObj;
    private static Builtin tanObj;
    private static Builtin sinhObj;
    private static Builtin coshObj;
    private static Builtin tanhObj;
    private static Builtin asinObj;
    private static Builtin acosObj;
    private static Builtin atanObj;
    private static Builtin logObj;
    private static Builtin lognzObj;
    private static Builtin minObj;
    private static Builtin maxObj;
    private static Builtin maxindexObj;
    private static Builtin minindexObj;
    private static Builtin absObj;
    private static Builtin signObj;
    private static Builtin sqrtObj;
    private static Builtin expObj;
    private static Builtin plogpObj;
    private static Builtin printObj;
    private static Builtin printfObj;
    private static Builtin nrowObj;
    private static Builtin ncolObj;
    private static Builtin lengthObj;
    private static Builtin roundObj;
    private static Builtin ceilObj;
    private static Builtin floorObj;
    private static Builtin inverseObj;
    private static Builtin cumsumObj;
    private static Builtin cumprodObj;
    private static Builtin cumminObj;
    private static Builtin cummaxObj;
    private static Builtin stopObj;
    private static Builtin spropObj;
    private static Builtin sigmoidObj;

    private Builtin(BuiltinCode bf) {
        this.bFunc = bf;
    }

    public BuiltinCode getBuiltinCode() {
        return this.bFunc;
    }

    public static boolean isBuiltinCode(ValueFunction fn, BuiltinCode code) {
        return fn instanceof Builtin && ((Builtin)fn).getBuiltinCode() == code;
    }

    public static boolean isBuiltinFnObject(String str) {
        return String2BuiltinCode.containsKey(str);
    }

    public static Builtin getBuiltinFnObject(String str) {
        BuiltinCode code = String2BuiltinCode.get(str);
        return Builtin.getBuiltinFnObject(code);
    }

    public static Builtin getBuiltinFnObject(BuiltinCode code) {
        if (code == null) {
            return null;
        }
        switch (code) {
            case SIN: {
                if (sinObj == null) {
                    sinObj = new Builtin(BuiltinCode.SIN);
                }
                return sinObj;
            }
            case COS: {
                if (cosObj == null) {
                    cosObj = new Builtin(BuiltinCode.COS);
                }
                return cosObj;
            }
            case TAN: {
                if (tanObj == null) {
                    tanObj = new Builtin(BuiltinCode.TAN);
                }
                return tanObj;
            }
            case SINH: {
                if (sinhObj == null) {
                    sinhObj = new Builtin(BuiltinCode.SINH);
                }
                return sinhObj;
            }
            case COSH: {
                if (coshObj == null) {
                    coshObj = new Builtin(BuiltinCode.COSH);
                }
                return coshObj;
            }
            case TANH: {
                if (tanhObj == null) {
                    tanhObj = new Builtin(BuiltinCode.TANH);
                }
                return tanhObj;
            }
            case ASIN: {
                if (asinObj == null) {
                    asinObj = new Builtin(BuiltinCode.ASIN);
                }
                return asinObj;
            }
            case ACOS: {
                if (acosObj == null) {
                    acosObj = new Builtin(BuiltinCode.ACOS);
                }
                return acosObj;
            }
            case ATAN: {
                if (atanObj == null) {
                    atanObj = new Builtin(BuiltinCode.ATAN);
                }
                return atanObj;
            }
            case LOG: {
                if (logObj == null) {
                    logObj = new Builtin(BuiltinCode.LOG);
                }
                return logObj;
            }
            case LOG_NZ: {
                if (lognzObj == null) {
                    lognzObj = new Builtin(BuiltinCode.LOG_NZ);
                }
                return lognzObj;
            }
            case MAX: {
                if (maxObj == null) {
                    maxObj = new Builtin(BuiltinCode.MAX);
                }
                return maxObj;
            }
            case MAXINDEX: {
                if (maxindexObj == null) {
                    maxindexObj = new Builtin(BuiltinCode.MAXINDEX);
                }
                return maxindexObj;
            }
            case MIN: {
                if (minObj == null) {
                    minObj = new Builtin(BuiltinCode.MIN);
                }
                return minObj;
            }
            case MININDEX: {
                if (minindexObj == null) {
                    minindexObj = new Builtin(BuiltinCode.MININDEX);
                }
                return minindexObj;
            }
            case ABS: {
                if (absObj == null) {
                    absObj = new Builtin(BuiltinCode.ABS);
                }
                return absObj;
            }
            case SIGN: {
                if (signObj == null) {
                    signObj = new Builtin(BuiltinCode.SIGN);
                }
                return signObj;
            }
            case SQRT: {
                if (sqrtObj == null) {
                    sqrtObj = new Builtin(BuiltinCode.SQRT);
                }
                return sqrtObj;
            }
            case EXP: {
                if (expObj == null) {
                    expObj = new Builtin(BuiltinCode.EXP);
                }
                return expObj;
            }
            case PLOGP: {
                if (plogpObj == null) {
                    plogpObj = new Builtin(BuiltinCode.PLOGP);
                }
                return plogpObj;
            }
            case PRINT: {
                if (printObj == null) {
                    printObj = new Builtin(BuiltinCode.PRINT);
                }
                return printObj;
            }
            case PRINTF: {
                if (printfObj == null) {
                    printfObj = new Builtin(BuiltinCode.PRINTF);
                }
                return printfObj;
            }
            case NROW: {
                if (nrowObj == null) {
                    nrowObj = new Builtin(BuiltinCode.NROW);
                }
                return nrowObj;
            }
            case NCOL: {
                if (ncolObj == null) {
                    ncolObj = new Builtin(BuiltinCode.NCOL);
                }
                return ncolObj;
            }
            case LENGTH: {
                if (lengthObj == null) {
                    lengthObj = new Builtin(BuiltinCode.LENGTH);
                }
                return lengthObj;
            }
            case ROUND: {
                if (roundObj == null) {
                    roundObj = new Builtin(BuiltinCode.ROUND);
                }
                return roundObj;
            }
            case CEIL: {
                if (ceilObj == null) {
                    ceilObj = new Builtin(BuiltinCode.CEIL);
                }
                return ceilObj;
            }
            case FLOOR: {
                if (floorObj == null) {
                    floorObj = new Builtin(BuiltinCode.FLOOR);
                }
                return floorObj;
            }
            case CUMSUM: {
                if (cumsumObj == null) {
                    cumsumObj = new Builtin(BuiltinCode.CUMSUM);
                }
                return cumsumObj;
            }
            case CUMPROD: {
                if (cumprodObj == null) {
                    cumprodObj = new Builtin(BuiltinCode.CUMPROD);
                }
                return cumprodObj;
            }
            case CUMMIN: {
                if (cumminObj == null) {
                    cumminObj = new Builtin(BuiltinCode.CUMMIN);
                }
                return cumminObj;
            }
            case CUMMAX: {
                if (cummaxObj == null) {
                    cummaxObj = new Builtin(BuiltinCode.CUMMAX);
                }
                return cummaxObj;
            }
            case INVERSE: {
                if (inverseObj == null) {
                    inverseObj = new Builtin(BuiltinCode.INVERSE);
                }
                return inverseObj;
            }
            case STOP: {
                if (stopObj == null) {
                    stopObj = new Builtin(BuiltinCode.STOP);
                }
                return stopObj;
            }
            case SPROP: {
                if (spropObj == null) {
                    spropObj = new Builtin(BuiltinCode.SPROP);
                }
                return spropObj;
            }
            case SIGMOID: {
                if (sigmoidObj == null) {
                    sigmoidObj = new Builtin(BuiltinCode.SIGMOID);
                }
                return sigmoidObj;
            }
        }
        return null;
    }

    @Override
    public double execute(double in) throws DMLRuntimeException {
        switch (this.bFunc) {
            case SIN: {
                return FastMath.sin((double)in);
            }
            case COS: {
                return FastMath.cos((double)in);
            }
            case TAN: {
                return FastMath.tan((double)in);
            }
            case ASIN: {
                return FastMath.asin((double)in);
            }
            case ACOS: {
                return FastMath.acos((double)in);
            }
            case ATAN: {
                return Math.atan(in);
            }
            case SINH: {
                return FastMath.sinh((double)in);
            }
            case COSH: {
                return FastMath.cosh((double)in);
            }
            case TANH: {
                return FastMath.tanh((double)in);
            }
            case CEIL: {
                return FastMath.ceil((double)in);
            }
            case FLOOR: {
                return FastMath.floor((double)in);
            }
            case LOG: {
                return Math.log(in);
            }
            case LOG_NZ: {
                return in == 0.0 ? 0.0 : Math.log(in);
            }
            case ABS: {
                return Math.abs(in);
            }
            case SIGN: {
                return FastMath.signum((double)in);
            }
            case SQRT: {
                return Math.sqrt(in);
            }
            case EXP: {
                return FastMath.exp((double)in);
            }
            case ROUND: {
                return Math.round(in);
            }
            case PLOGP: {
                if (in == 0.0) {
                    return 0.0;
                }
                if (in < 0.0) {
                    return Double.NaN;
                }
                return in * Math.log(in);
            }
            case SPROP: {
                return in * (1.0 - in);
            }
            case SIGMOID: {
                return 1.0 / (1.0 + FastMath.exp((double)(-in)));
            }
        }
        throw new DMLRuntimeException("Builtin.execute(): Unknown operation: " + (Object)((Object)this.bFunc));
    }

    @Override
    public double execute(long in) throws DMLRuntimeException {
        return this.execute((double)in);
    }

    @Override
    public double execute(double in1, double in2) throws DMLRuntimeException {
        switch (this.bFunc) {
            case MAX: 
            case CUMMAX: {
                return in1 >= in2 ? in1 : in2;
            }
            case MIN: 
            case CUMMIN: {
                return in1 <= in2 ? in1 : in2;
            }
            case MAXINDEX: {
                if (in1 == in2) {
                    return 2.0;
                }
                if (in1 > in2) {
                    return 1.0;
                }
                return 0.0;
            }
            case MININDEX: {
                if (in1 == in2) {
                    return 2.0;
                }
                if (in1 < in2) {
                    return 1.0;
                }
                return 0.0;
            }
            case LOG: {
                return Math.log(in1) / Math.log(in2);
            }
            case LOG_NZ: {
                return in1 == 0.0 ? 0.0 : Math.log(in1) / Math.log(in2);
            }
        }
        throw new DMLRuntimeException("Builtin.execute(): Unknown operation: " + (Object)((Object)this.bFunc));
    }

    public double execute2(double in1, double in2) {
        switch (this.bFunc) {
            case MAX: 
            case CUMMAX: {
                return in1 >= in2 ? in1 : in2;
            }
            case MIN: 
            case CUMMIN: {
                return in1 <= in2 ? in1 : in2;
            }
            case MAXINDEX: {
                return in1 >= in2 ? 1.0 : 0.0;
            }
            case MININDEX: {
                return in1 <= in2 ? 1.0 : 0.0;
            }
        }
        return -1.0;
    }

    @Override
    public double execute(long in1, long in2) throws DMLRuntimeException {
        switch (this.bFunc) {
            case MAX: 
            case CUMMAX: {
                return in1 >= in2 ? in1 : in2;
            }
            case MIN: 
            case CUMMIN: {
                return in1 <= in2 ? in1 : in2;
            }
            case MAXINDEX: {
                return in1 >= in2 ? 1.0 : 0.0;
            }
            case MININDEX: {
                return in1 <= in2 ? 1.0 : 0.0;
            }
            case LOG: {
                return Math.log(in1) / Math.log(in2);
            }
            case LOG_NZ: {
                return in1 == 0L ? 0.0 : Math.log(in1) / Math.log(in2);
            }
        }
        throw new DMLRuntimeException("Builtin.execute(): Unknown operation: " + (Object)((Object)this.bFunc));
    }

    @Override
    public String execute(String in1) throws DMLRuntimeException {
        switch (this.bFunc) {
            case PRINT: {
                if (!DMLScript.suppressPrint2Stdout()) {
                    System.out.println(in1);
                }
                return null;
            }
            case PRINTF: {
                if (!DMLScript.suppressPrint2Stdout()) {
                    System.out.println(in1);
                }
                return null;
            }
            case STOP: {
                throw new DMLScriptException(in1);
            }
        }
        throw new DMLRuntimeException("Builtin.execute(): Unknown operation: " + (Object)((Object)this.bFunc));
    }

    static {
        String2BuiltinCode.put("sin", BuiltinCode.SIN);
        String2BuiltinCode.put("cos", BuiltinCode.COS);
        String2BuiltinCode.put("tan", BuiltinCode.TAN);
        String2BuiltinCode.put("sinh", BuiltinCode.SINH);
        String2BuiltinCode.put("cosh", BuiltinCode.COSH);
        String2BuiltinCode.put("tanh", BuiltinCode.TANH);
        String2BuiltinCode.put("asin", BuiltinCode.ASIN);
        String2BuiltinCode.put("acos", BuiltinCode.ACOS);
        String2BuiltinCode.put("atan", BuiltinCode.ATAN);
        String2BuiltinCode.put("log", BuiltinCode.LOG);
        String2BuiltinCode.put("log_nz", BuiltinCode.LOG_NZ);
        String2BuiltinCode.put("min", BuiltinCode.MIN);
        String2BuiltinCode.put("max", BuiltinCode.MAX);
        String2BuiltinCode.put("maxindex", BuiltinCode.MAXINDEX);
        String2BuiltinCode.put("minindex", BuiltinCode.MININDEX);
        String2BuiltinCode.put("abs", BuiltinCode.ABS);
        String2BuiltinCode.put("sign", BuiltinCode.SIGN);
        String2BuiltinCode.put("sqrt", BuiltinCode.SQRT);
        String2BuiltinCode.put("exp", BuiltinCode.EXP);
        String2BuiltinCode.put("plogp", BuiltinCode.PLOGP);
        String2BuiltinCode.put("print", BuiltinCode.PRINT);
        String2BuiltinCode.put("printf", BuiltinCode.PRINTF);
        String2BuiltinCode.put("eval", BuiltinCode.EVAL);
        String2BuiltinCode.put("nrow", BuiltinCode.NROW);
        String2BuiltinCode.put("ncol", BuiltinCode.NCOL);
        String2BuiltinCode.put("length", BuiltinCode.LENGTH);
        String2BuiltinCode.put("round", BuiltinCode.ROUND);
        String2BuiltinCode.put("stop", BuiltinCode.STOP);
        String2BuiltinCode.put("ceil", BuiltinCode.CEIL);
        String2BuiltinCode.put("floor", BuiltinCode.FLOOR);
        String2BuiltinCode.put("ucumk+", BuiltinCode.CUMSUM);
        String2BuiltinCode.put("ucum*", BuiltinCode.CUMPROD);
        String2BuiltinCode.put("ucummin", BuiltinCode.CUMMIN);
        String2BuiltinCode.put("ucummax", BuiltinCode.CUMMAX);
        String2BuiltinCode.put("inverse", BuiltinCode.INVERSE);
        String2BuiltinCode.put("sprop", BuiltinCode.SPROP);
        String2BuiltinCode.put("sigmoid", BuiltinCode.SIGMOID);
        sinObj = null;
        cosObj = null;
        tanObj = null;
        sinhObj = null;
        coshObj = null;
        tanhObj = null;
        asinObj = null;
        acosObj = null;
        atanObj = null;
        logObj = null;
        lognzObj = null;
        minObj = null;
        maxObj = null;
        maxindexObj = null;
        minindexObj = null;
        absObj = null;
        signObj = null;
        sqrtObj = null;
        expObj = null;
        plogpObj = null;
        printObj = null;
        nrowObj = null;
        ncolObj = null;
        lengthObj = null;
        roundObj = null;
        ceilObj = null;
        floorObj = null;
        inverseObj = null;
        cumsumObj = null;
        cumprodObj = null;
        cumminObj = null;
        cummaxObj = null;
        stopObj = null;
        spropObj = null;
        sigmoidObj = null;
    }

    public static enum BuiltinCode {
        SIN,
        COS,
        TAN,
        SINH,
        COSH,
        TANH,
        ASIN,
        ACOS,
        ATAN,
        LOG,
        LOG_NZ,
        MIN,
        MAX,
        ABS,
        SIGN,
        SQRT,
        EXP,
        PLOGP,
        PRINT,
        PRINTF,
        NROW,
        NCOL,
        LENGTH,
        ROUND,
        MAXINDEX,
        MININDEX,
        STOP,
        CEIL,
        FLOOR,
        CUMSUM,
        CUMPROD,
        CUMMIN,
        CUMMAX,
        INVERSE,
        SPROP,
        SIGMOID,
        EVAL;

    }
}

