/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Data;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class Ctable
extends Lop {
    private boolean _ignoreZeros = false;
    OperationTypes operation;

    public Ctable(Lop[] inputLops, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        this(inputLops, op, dt, vt, false, et);
    }

    public Ctable(Lop[] inputLops, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, boolean ignoreZeros, LopProperties.ExecType et) {
        super(Lop.Type.Ctable, dt, vt);
        this.init(inputLops, op, et);
        this._ignoreZeros = ignoreZeros;
    }

    private void init(Lop[] inputLops, OperationTypes op, LopProperties.ExecType et) {
        this.operation = op;
        for (int i = 0; i < inputLops.length; ++i) {
            this.addInput(inputLops[i]);
            inputLops[i].addOutput(this);
        }
        boolean breaksAlignment = true;
        boolean aligner = false;
        boolean definesMRJob = false;
        if (et == LopProperties.ExecType.MR) {
            this.lps.addCompatibility(JobType.GMR);
            if (this.operation == OperationTypes.CTABLE_EXPAND_SCALAR_WEIGHT) {
                this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.Reduce, breaksAlignment, aligner, definesMRJob);
            } else {
                this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.Reduce, breaksAlignment, aligner, definesMRJob);
            }
        } else {
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    @Override
    public String toString() {
        return " Operation: " + (Object)((Object)this.operation);
    }

    public static OperationTypes findCtableOperationByInputDataTypes(Expression.DataType dt1, Expression.DataType dt2, Expression.DataType dt3) {
        if (dt1 == Expression.DataType.MATRIX) {
            if (dt2 == Expression.DataType.MATRIX && dt3 == Expression.DataType.SCALAR) {
                return OperationTypes.CTABLE_TRANSFORM_SCALAR_WEIGHT;
            }
            if (dt2 == Expression.DataType.SCALAR && dt3 == Expression.DataType.SCALAR) {
                return OperationTypes.CTABLE_TRANSFORM_HISTOGRAM;
            }
            if (dt2 == Expression.DataType.SCALAR && dt3 == Expression.DataType.MATRIX) {
                return OperationTypes.CTABLE_TRANSFORM_WEIGHTED_HISTOGRAM;
            }
            return OperationTypes.CTABLE_TRANSFORM;
        }
        return OperationTypes.INVALID;
    }

    public OperationTypes getOperationType() {
        return this.operation;
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String output) throws LopsException {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        if (this.operation != OperationTypes.CTABLE_EXPAND_SCALAR_WEIGHT) {
            sb.append("ctable");
        } else {
            sb.append("ctableexpand");
        }
        sb.append("\u00b0");
        if (this.getInputs().get(0).getDataType() == Expression.DataType.SCALAR) {
            sb.append(this.getInputs().get(0).prepScalarInputOperand(this.getExecType()));
        } else {
            sb.append(this.getInputs().get(0).prepInputOperand(input1));
        }
        sb.append("\u00b0");
        if (this.getInputs().get(1).getDataType() == Expression.DataType.SCALAR) {
            sb.append(this.getInputs().get(1).prepScalarInputOperand(this.getExecType()));
        } else {
            sb.append(this.getInputs().get(1).prepInputOperand(input2));
        }
        sb.append("\u00b0");
        if (this.getInputs().get(2).getDataType() == Expression.DataType.SCALAR) {
            sb.append(this.getInputs().get(2).prepScalarInputOperand(this.getExecType()));
        } else {
            sb.append(this.getInputs().get(2).prepInputOperand(input3));
        }
        sb.append("\u00b0");
        if (this.getInputs().size() > 3) {
            sb.append(this.getInputs().get(3).getOutputParameters().getLabel());
            sb.append("\u00b7");
            sb.append(this.getInputs().get(3).getType() == Lop.Type.Data && ((Data)this.getInputs().get(3)).isLiteral());
            sb.append("\u00b0");
            sb.append(this.getInputs().get(4).getOutputParameters().getLabel());
            sb.append("\u00b7");
            sb.append(this.getInputs().get(4).getType() == Lop.Type.Data && ((Data)this.getInputs().get(4)).isLiteral());
            sb.append("\u00b0");
        } else {
            sb.append(-1);
            sb.append("\u00b7");
            sb.append(true);
            sb.append("\u00b0");
            sb.append(-1);
            sb.append("\u00b7");
            sb.append(true);
            sb.append("\u00b0");
        }
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        sb.append(this._ignoreZeros);
        return sb.toString();
    }

    @Override
    public String getInstructions(int input_index1, int input_index2, int input_index3, int output_index) throws LopsException {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        switch (this.operation) {
            case CTABLE_TRANSFORM: {
                sb.append("ctabletransform");
                sb.append("\u00b0");
                sb.append(this.getInputs().get(0).prepInputOperand(input_index1));
                sb.append("\u00b0");
                sb.append(this.getInputs().get(1).prepInputOperand(input_index2));
                sb.append("\u00b0");
                sb.append(this.getInputs().get(2).prepInputOperand(input_index3));
                sb.append("\u00b0");
                break;
            }
            case CTABLE_TRANSFORM_SCALAR_WEIGHT: {
                if (input_index3 != -1) {
                    throw new LopsException(this.printErrorLocation() + "In Tertiary Lop, Unexpected input while computing the instructions for op: " + (Object)((Object)this.operation) + " \n");
                }
                int scalarIndex = 2;
                sb.append("ctabletransformscalarweight");
                sb.append("\u00b0");
                sb.append(this.getInputs().get(0).prepInputOperand(input_index1));
                sb.append("\u00b0");
                sb.append(this.getInputs().get(1).prepInputOperand(input_index2));
                sb.append("\u00b0");
                sb.append(this.getInputs().get(scalarIndex).prepScalarInputOperand(this.getExecType()));
                sb.append("\u00b0");
                break;
            }
            case CTABLE_EXPAND_SCALAR_WEIGHT: {
                if (input_index3 != -1) {
                    throw new LopsException(this.printErrorLocation() + "In Tertiary Lop, Unexpected input while computing the instructions for op: " + (Object)((Object)this.operation) + " \n");
                }
                int scalarIndex2 = 1;
                int scalarIndex3 = 2;
                sb.append("ctableexpandscalarweight");
                sb.append("\u00b0");
                sb.append(this.getInputs().get(0).prepInputOperand(input_index1));
                sb.append("\u00b0");
                sb.append(this.getInputs().get(scalarIndex2).prepScalarInputOperand(this.getExecType()));
                sb.append("\u00b0");
                sb.append(this.getInputs().get(scalarIndex3).prepScalarInputOperand(this.getExecType()));
                sb.append("\u00b0");
                break;
            }
            case CTABLE_TRANSFORM_HISTOGRAM: {
                if (input_index2 != -1 || input_index3 != -1) {
                    throw new LopsException(this.printErrorLocation() + "In Tertiary Lop, Unexpected input while computing the instructions for op: " + (Object)((Object)this.operation));
                }
                sb.append("ctabletransformhistogram");
                sb.append("\u00b0");
                sb.append(this.getInputs().get(0).prepInputOperand(input_index1));
                sb.append("\u00b0");
                sb.append(this.getInputs().get(1).prepScalarInputOperand(this.getExecType()));
                sb.append("\u00b0");
                sb.append(this.getInputs().get(2).prepScalarInputOperand(this.getExecType()));
                sb.append("\u00b0");
                break;
            }
            case CTABLE_TRANSFORM_WEIGHTED_HISTOGRAM: {
                if (input_index2 != -1) {
                    throw new LopsException(this.printErrorLocation() + "In Tertiary Lop, Unexpected input while computing the instructions for op: " + (Object)((Object)this.operation));
                }
                sb.append("ctabletransformweightedhistogram");
                sb.append("\u00b0");
                sb.append(this.getInputs().get(0).prepInputOperand(input_index1));
                sb.append("\u00b0");
                sb.append(this.getInputs().get(1).prepScalarInputOperand(this.getExecType()));
                sb.append("\u00b0");
                sb.append(this.getInputs().get(2).prepInputOperand(input_index3));
                sb.append("\u00b0");
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.printErrorLocation() + "Instruction is not defined for Tertiary operation: " + (Object)((Object)this.operation));
            }
        }
        long outputDim1 = -1L;
        long outputDim2 = -1L;
        if (this.getInputs().size() > 3) {
            sb.append(this.getInputs().get(3).prepScalarLabel());
            sb.append("\u00b0");
            sb.append(this.getInputs().get(4).prepScalarLabel());
            sb.append("\u00b0");
        } else {
            sb.append(outputDim1);
            sb.append("\u00b0");
            sb.append(outputDim2);
            sb.append("\u00b0");
        }
        sb.append(this.prepOutputOperand(output_index));
        return sb.toString();
    }

    public static OperationTypes getOperationType(String opcode) {
        OperationTypes op = null;
        if (opcode.equals("ctabletransform")) {
            op = OperationTypes.CTABLE_TRANSFORM;
        } else if (opcode.equals("ctabletransformscalarweight")) {
            op = OperationTypes.CTABLE_TRANSFORM_SCALAR_WEIGHT;
        } else if (opcode.equals("ctableexpandscalarweight")) {
            op = OperationTypes.CTABLE_EXPAND_SCALAR_WEIGHT;
        } else if (opcode.equals("ctabletransformhistogram")) {
            op = OperationTypes.CTABLE_TRANSFORM_HISTOGRAM;
        } else if (opcode.equals("ctabletransformweightedhistogram")) {
            op = OperationTypes.CTABLE_TRANSFORM_WEIGHTED_HISTOGRAM;
        } else {
            throw new UnsupportedOperationException("Tertiary operation code is not defined: " + opcode);
        }
        return op;
    }

    public static enum OperationTypes {
        CTABLE_TRANSFORM,
        CTABLE_TRANSFORM_SCALAR_WEIGHT,
        CTABLE_TRANSFORM_HISTOGRAM,
        CTABLE_TRANSFORM_WEIGHTED_HISTOGRAM,
        CTABLE_EXPAND_SCALAR_WEIGHT,
        INVALID;

    }
}

