/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.globalopt;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.cost.CostEstimationWrapper;
import org.apache.sysml.hops.globalopt.GlobalOptimizer;
import org.apache.sysml.hops.globalopt.InterestingProperties;
import org.apache.sysml.hops.globalopt.MemoStructure;
import org.apache.sysml.hops.globalopt.Plan;
import org.apache.sysml.hops.globalopt.PlanSet;
import org.apache.sysml.hops.globalopt.RewriteConfig;
import org.apache.sysml.hops.globalopt.Summary;
import org.apache.sysml.hops.globalopt.gdfgraph.GDFGraph;
import org.apache.sysml.hops.globalopt.gdfgraph.GDFLoopNode;
import org.apache.sysml.hops.globalopt.gdfgraph.GDFNode;
import org.apache.sysml.hops.globalopt.gdfresolve.GDFMismatchHeuristic;
import org.apache.sysml.hops.globalopt.gdfresolve.MismatchHeuristicFactory;
import org.apache.sysml.hops.recompile.Recompiler;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContextFactory;
import org.apache.sysml.runtime.controlprogram.parfor.stat.Timing;

public class GDFEnumOptimizer
extends GlobalOptimizer {
    private static final Log LOG = LogFactory.getLog(GDFEnumOptimizer.class);
    private static final boolean BRANCH_AND_BOUND_PRUNING = true;
    private static final boolean PREFERRED_PLAN_SELECTION = true;
    private static final boolean COST_FULL_PROGRAMS = false;
    private static final boolean ENUM_CP_BLOCKSIZES = false;
    private static final GDFMismatchHeuristic.MismatchHeuristicType DEFAULT_MISMATCH_HEURISTIC = GDFMismatchHeuristic.MismatchHeuristicType.FIRST;
    private static final int[] BLOCK_SIZES = new int[]{1024, 2048, 4096};
    private static final double BRANCH_AND_BOUND_REL_THRES = Math.pow(10.0, -5.0);
    private MemoStructure _memo = new MemoStructure();
    private static GDFMismatchHeuristic _resolve = null;
    private static long _enumeratedPlans = 0L;
    private static long _prunedInvalidPlans = 0L;
    private static long _prunedSuboptimalPlans = 0L;
    private static long _compiledPlans = 0L;
    private static long _costedPlans = 0L;
    private static long _planMismatches = 0L;

    public GDFEnumOptimizer() throws DMLRuntimeException {
        _resolve = MismatchHeuristicFactory.createMismatchHeuristic(DEFAULT_MISMATCH_HEURISTIC);
    }

    @Override
    public GDFGraph optimize(GDFGraph gdfgraph, Summary summary) throws DMLRuntimeException, HopsException, LopsException {
        Timing time = new Timing(true);
        Program prog = gdfgraph.getRuntimeProgram();
        ExecutionContext ec = ExecutionContextFactory.createContext(prog);
        ArrayList<GDFNode> roots = gdfgraph.getGraphRootNodes();
        double initCosts = Double.MAX_VALUE;
        initCosts = CostEstimationWrapper.getTimeEstimate(prog, ec);
        initCosts *= 1.0 + BRANCH_AND_BOUND_REL_THRES;
        ArrayList<Object> rootPlans = new ArrayList<Object>();
        for (GDFNode node : roots) {
            PlanSet ps = GDFEnumOptimizer.enumOpt(node, this._memo, initCosts);
            Plan optPlan = ps.getPlanWithMinCosts();
            rootPlans.add(optPlan);
        }
        long enumPlanMismatch = GDFEnumOptimizer.getPlanMismatches();
        HashMap<Long, Plan> memo = new HashMap<Long, Plan>();
        GDFEnumOptimizer.resetPlanMismatches();
        for (Plan plan : rootPlans) {
            GDFEnumOptimizer.rSetRuntimePlanConfig(plan, memo);
        }
        long finalPlanMismatch = GDFEnumOptimizer.getPlanMismatches();
        Recompiler.recompileProgramBlockHierarchy(prog.getProgramBlocks(), new LocalVariableMap(), 0L, Recompiler.ResetType.NO_RESET);
        ec = ExecutionContextFactory.createContext(prog);
        double optCosts = CostEstimationWrapper.getTimeEstimate(prog, ec);
        summary.setCostsInitial(initCosts);
        summary.setCostsOptimal(optCosts);
        summary.setNumEnumPlans(_enumeratedPlans);
        summary.setNumPrunedInvalidPlans(_prunedInvalidPlans);
        summary.setNumPrunedSuboptPlans(_prunedSuboptimalPlans);
        summary.setNumCompiledPlans(_compiledPlans);
        summary.setNumCostedPlans(_costedPlans);
        summary.setNumEnumPlanMismatch(enumPlanMismatch);
        summary.setNumFinalPlanMismatch(finalPlanMismatch);
        summary.setTimeOptim(time.stop());
        return gdfgraph;
    }

    public static PlanSet enumOpt(GDFNode node, MemoStructure memo, double maxCosts) throws DMLRuntimeException {
        if (memo.constainsEntry(node)) {
            return memo.getEntry(node);
        }
        PlanSet P = GDFEnumOptimizer.enumNodePlans(node, memo, maxCosts);
        for (GDFNode c : node.getInputs()) {
            PlanSet Pc = GDFEnumOptimizer.enumOpt(c, memo, maxCosts);
            if (c instanceof GDFLoopNode) {
                Pc = Pc.selectChild(node);
            }
            P = P.crossProductChild(Pc);
            _enumeratedPlans += (long)P.size();
            GDFEnumOptimizer.pruneInvalidPlans(P);
        }
        GDFEnumOptimizer.pruneSuboptimalPlans(P, maxCosts);
        memo.putEntry(node, P);
        return P;
    }

    private static PlanSet enumNodePlans(GDFNode node, MemoStructure memo, double maxCosts) throws DMLRuntimeException {
        LopProperties.ExecType CLUSTER;
        ArrayList<Plan> plans = new ArrayList<Plan>();
        LopProperties.ExecType execType = CLUSTER = OptimizerUtils.isSparkExecutionMode() ? LopProperties.ExecType.SPARK : LopProperties.ExecType.MR;
        if (node.getNodeType() == GDFNode.NodeType.HOP_NODE && !(node.getHop() instanceof DataOp)) {
            GDFEnumOptimizer.enumHopNodePlans(node, plans);
        } else if (node.getHop() instanceof DataOp) {
            DataOp dhop = (DataOp)node.getHop();
            if (dhop.getDataOpType() == Hop.DataOpTypes.PERSISTENTREAD) {
                int[] blocksizes;
                int[] nArray;
                LopProperties.ExecType et;
                LopProperties.ExecType execType2 = et = dhop.getMemEstimate() > OptimizerUtils.getLocalMemBudget() || HopRewriteUtils.alwaysRequiresReblock(dhop) ? CLUSTER : LopProperties.ExecType.CP;
                if (et == CLUSTER) {
                    nArray = BLOCK_SIZES;
                } else {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = BLOCK_SIZES[0];
                }
                int[] nArray3 = blocksizes = nArray;
                int n = nArray3.length;
                for (int i = 0; i < n; ++i) {
                    Integer bs = nArray3[i];
                    RewriteConfig rcmr = new RewriteConfig(et, bs, Hop.FileFormatTypes.BINARY);
                    InterestingProperties ipsmr = rcmr.deriveInterestingProperties();
                    Plan mrplan = new Plan(node, ipsmr, rcmr, null);
                    plans.add(mrplan);
                }
            } else if (dhop.getDataOpType() == Hop.DataOpTypes.PERSISTENTWRITE) {
                LopProperties.ExecType et = dhop.getMemEstimate() > OptimizerUtils.getLocalMemBudget() ? CLUSTER : LopProperties.ExecType.CP;
                RewriteConfig rcmr = new RewriteConfig(et, (int)dhop.getRowsInBlock(), dhop.getInputFormatType());
                InterestingProperties ipsmr = rcmr.deriveInterestingProperties();
                Plan mrplan = new Plan(node, ipsmr, rcmr, null);
                plans.add(mrplan);
            } else if (dhop.getDataOpType() == Hop.DataOpTypes.TRANSIENTREAD || dhop.getDataOpType() == Hop.DataOpTypes.TRANSIENTWRITE) {
                GDFEnumOptimizer.enumHopNodePlans(node, plans);
            }
        } else if (node.getNodeType() == GDFNode.NodeType.LOOP_NODE) {
            GDFLoopNode lnode = (GDFLoopNode)node;
            for (GDFNode in : lnode.getLoopInputs().values()) {
                GDFEnumOptimizer.enumOpt(in, memo, maxCosts);
            }
            RewriteConfig rc = new RewriteConfig(LopProperties.ExecType.CP, -1, null);
            InterestingProperties ips = rc.deriveInterestingProperties();
            Plan lplan = new Plan(node, ips, rc, null);
            plans.add(lplan);
            if (lnode.getLoopPredicate() != null) {
                GDFEnumOptimizer.enumOpt(lnode.getLoopPredicate(), memo, maxCosts);
            }
            PlanSet Pout = new PlanSet();
            for (GDFNode out : lnode.getLoopOutputs().values()) {
                Pout = Pout.union(GDFEnumOptimizer.enumOpt(out, memo, maxCosts));
            }
            plans.addAll(Pout.getPlans());
        } else if (node.getNodeType() == GDFNode.NodeType.CROSS_BLOCK_NODE) {
            // empty if block
        }
        return new PlanSet(plans);
    }

    private static void enumHopNodePlans(GDFNode node, ArrayList<Plan> plans) {
        int n;
        LopProperties.ExecType CLUSTER;
        LopProperties.ExecType execType = CLUSTER = OptimizerUtils.isSparkExecutionMode() ? LopProperties.ExecType.SPARK : LopProperties.ExecType.MR;
        if (node.getHop().getMemEstimate() < OptimizerUtils.getLocalMemBudget()) {
            int[] bstmp;
            int[] nArray = bstmp = new int[]{BLOCK_SIZES[0]};
            n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer bs = nArray[i];
                RewriteConfig rccp = new RewriteConfig(LopProperties.ExecType.CP, bs, Hop.FileFormatTypes.BINARY);
                InterestingProperties ipscp = rccp.deriveInterestingProperties();
                Plan cpplan = new Plan(node, ipscp, rccp, null);
                plans.add(cpplan);
            }
        }
        if (node.requiresMREnumeration()) {
            int[] nArray = BLOCK_SIZES;
            int n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                Integer bs = nArray[n];
                RewriteConfig rcmr = new RewriteConfig(CLUSTER, bs, Hop.FileFormatTypes.BINARY);
                InterestingProperties ipsmr = rcmr.deriveInterestingProperties();
                Plan mrplan = new Plan(node, ipsmr, rcmr, null);
                plans.add(mrplan);
            }
        }
    }

    private static void pruneInvalidPlans(PlanSet plans) {
        ArrayList<Plan> valid = new ArrayList<Plan>();
        for (Plan plan : plans.getPlans()) {
            if (!plan.checkValidBlocksizesInMR() || !plan.checkValidBlocksizesTRead() || !plan.checkValidFormatInMR() || !plan.checkValidExecutionType()) continue;
            valid.add(plan);
        }
        int sizeBefore = plans.size();
        int sizeAfter = valid.size();
        _prunedInvalidPlans += (long)(sizeBefore - sizeAfter);
        LOG.debug((Object)("Pruned invalid plans: " + sizeBefore + " --> " + sizeAfter));
        plans.setPlans(valid);
    }

    private static void pruneSuboptimalPlans(PlanSet plans, double maxCosts) throws DMLRuntimeException {
        for (Plan plan : plans.getPlans()) {
            plan.setCosts(GDFEnumOptimizer.costRuntimePlan(plan));
        }
        HashMap<InterestingProperties, Plan> probeMap = new HashMap<InterestingProperties, Plan>();
        for (Plan p : plans.getPlans()) {
            Plan best;
            if (p.getCosts() > maxCosts || (best = (Plan)probeMap.get(p.getInterestingProperties())) != null && p.getCosts() > best.getCosts() || best != null && p.getCosts() == best.getCosts() && !p.isPreferredPlan()) continue;
            probeMap.put(p.getInterestingProperties(), p);
        }
        ArrayList<Plan> arrayList = new ArrayList<Plan>(probeMap.values());
        int sizeBefore = plans.size();
        int sizeAfter = arrayList.size();
        _prunedSuboptimalPlans += (long)(sizeBefore - sizeAfter);
        LOG.debug((Object)("Pruned suboptimal plans: " + sizeBefore + " --> " + sizeAfter));
        plans.setPlans(arrayList);
    }

    private static double costRuntimePlan(Plan p) throws DMLRuntimeException {
        Program prog = p.getNode().getProgram();
        if (prog == null) {
            throw new DMLRuntimeException("Program not available for runtime plan costing.");
        }
        GDFEnumOptimizer.rSetRuntimePlanConfig(p, new HashMap<Long, Plan>());
        double costs = -1.0;
        if (p.getNode().getHop() == null || p.getNode().getProgramBlock() == null) {
            Recompiler.recompileProgramBlockHierarchy(prog.getProgramBlocks(), new LocalVariableMap(), 0L, Recompiler.ResetType.NO_RESET);
            ++_compiledPlans;
            ExecutionContext ec = ExecutionContextFactory.createContext(prog);
            costs = CostEstimationWrapper.getTimeEstimate(prog, ec);
        } else {
            Hop currentHop = p.getNode().getHop();
            ProgramBlock pb = p.getNode().getProgramBlock();
            ArrayList<Hop> oldRoots = pb.getStatementBlock().getHops();
            DataOp tmpHop = null;
            if (!(currentHop instanceof DataOp) || !((DataOp)currentHop).isWrite()) {
                ArrayList<Hop> newRoots = new ArrayList<Hop>();
                tmpHop = new DataOp("_tmp", currentHop.getDataType(), currentHop.getValueType(), currentHop, Hop.DataOpTypes.TRANSIENTWRITE, "tmp");
                tmpHop.setVisited();
                newRoots.add(tmpHop);
                pb.getStatementBlock().setHops(newRoots);
            }
            Recompiler.recompileProgramBlockHierarchy(prog.getProgramBlocks(), new LocalVariableMap(), 0L, Recompiler.ResetType.NO_RESET);
            ++_compiledPlans;
            ExecutionContext ec = ExecutionContextFactory.createContext(prog);
            costs = CostEstimationWrapper.getTimeEstimate(prog, ec);
            if (tmpHop != null) {
                HopRewriteUtils.removeChildReference(tmpHop, currentHop);
            }
            pb.getStatementBlock().setHops(oldRoots);
        }
        GDFEnumOptimizer.rResetRuntimePlanConfig(p, new HashMap<Long, Plan>());
        ++_costedPlans;
        return costs;
    }

    private static void rSetRuntimePlanConfig(Plan p, HashMap<Long, Plan> memo) {
        Hop hop;
        LopProperties.ExecType CLUSTER;
        LopProperties.ExecType execType = CLUSTER = OptimizerUtils.isSparkExecutionMode() ? LopProperties.ExecType.SPARK : LopProperties.ExecType.MR;
        if (memo.containsKey(p.getNode().getID())) {
            Plan pmemo = memo.get(p.getNode().getID());
            if (!p.getInterestingProperties().equals(pmemo.getInterestingProperties())) {
                if (_resolve.resolveMismatch(pmemo.getRewriteConfig(), p.getRewriteConfig())) {
                    memo.put(p.getNode().getID(), p);
                }
                LOG.warn((Object)("Configuration mismatch on shared node (" + p.getNode().getHop().getHopID() + "). Falling back to heuristic '" + _resolve.getName() + "'."));
                LOG.warn((Object)p.getInterestingProperties().toString());
                LOG.warn((Object)memo.get(p.getNode().getID()).getInterestingProperties());
                ++_planMismatches;
                return;
            }
        }
        if ((hop = p.getNode().getHop()) != null) {
            RewriteConfig rc = p.getRewriteConfig();
            hop.setForcedExecType(rc.getExecType());
            hop.setRowsInBlock(rc.getBlockSize());
            hop.setColsInBlock(rc.getBlockSize());
            if (rc.getExecType() == CLUSTER) {
                boolean reblock = HopRewriteUtils.alwaysRequiresReblock(hop) || hop.hasMatrixInputWithDifferentBlocksizes() && !(hop instanceof DataOp);
                hop.setRequiresReblock(reblock);
            } else {
                hop.setRequiresReblock(false);
            }
        }
        if (p.getChilds() != null) {
            for (Plan c : p.getChilds()) {
                GDFEnumOptimizer.rSetRuntimePlanConfig(c, memo);
            }
        }
        memo.put(p.getNode().getID(), p);
    }

    private static void rResetRuntimePlanConfig(Plan p, HashMap<Long, Plan> memo) {
        if (memo.containsKey(p.getNode().getID())) {
            return;
        }
        Hop hop = p.getNode().getHop();
        if (hop != null) {
            hop.setForcedExecType(null);
            hop.setRowsInBlock(ConfigurationManager.getBlocksize());
            hop.setColsInBlock(ConfigurationManager.getBlocksize());
            if (!HopRewriteUtils.alwaysRequiresReblock(hop)) {
                hop.setRequiresReblock(false);
            }
        }
        if (p.getChilds() != null) {
            for (Plan c : p.getChilds()) {
                GDFEnumOptimizer.rResetRuntimePlanConfig(c, memo);
            }
        }
        memo.put(p.getNode().getID(), p);
    }

    private static long getPlanMismatches() {
        return _planMismatches;
    }

    private static void resetPlanMismatches() {
        _planMismatches = 0L;
    }
}

