/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser.dml;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.parser.AssignmentStatement;
import org.apache.sysml.parser.ConditionalPredicate;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.ExpressionList;
import org.apache.sysml.parser.ExternalFunctionStatement;
import org.apache.sysml.parser.ForStatement;
import org.apache.sysml.parser.FunctionCallIdentifier;
import org.apache.sysml.parser.FunctionStatement;
import org.apache.sysml.parser.IfStatement;
import org.apache.sysml.parser.ImportStatement;
import org.apache.sysml.parser.IndexedIdentifier;
import org.apache.sysml.parser.IterablePredicate;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.ParForStatement;
import org.apache.sysml.parser.ParameterExpression;
import org.apache.sysml.parser.ParseException;
import org.apache.sysml.parser.ParserWrapper;
import org.apache.sysml.parser.PathStatement;
import org.apache.sysml.parser.Statement;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.WhileStatement;
import org.apache.sysml.parser.common.CommonSyntacticValidator;
import org.apache.sysml.parser.common.CustomErrorListener;
import org.apache.sysml.parser.common.ExpressionInfo;
import org.apache.sysml.parser.common.StatementInfo;
import org.apache.sysml.parser.dml.DMLParserWrapper;
import org.apache.sysml.parser.dml.DmlListener;
import org.apache.sysml.parser.dml.DmlParser;

public class DmlSyntacticValidator
extends CommonSyntacticValidator
implements DmlListener {
    public DmlSyntacticValidator(CustomErrorListener errorListener, Map<String, String> argVals, String sourceNamespace, Set<String> prepFunctions) {
        super(errorListener, argVals, sourceNamespace, prepFunctions);
    }

    @Override
    public String namespaceResolutionOp() {
        return "::";
    }

    @Override
    public String trueStringLiteral() {
        return "TRUE";
    }

    @Override
    public String falseStringLiteral() {
        return "FALSE";
    }

    protected ArrayList<ParameterExpression> getParameterExpressionList(List<DmlParser.ParameterizedExpressionContext> paramExprs) {
        ArrayList<ParameterExpression> retVal = new ArrayList<ParameterExpression>();
        for (DmlParser.ParameterizedExpressionContext ctx : paramExprs) {
            String paramName = null;
            if (ctx.paramName != null && ctx.paramName.getText() != null && !ctx.paramName.getText().isEmpty()) {
                paramName = ctx.paramName.getText();
            }
            ParameterExpression myArg = new ParameterExpression(paramName, ctx.paramVal.info.expr);
            retVal.add(myArg);
        }
        return retVal;
    }

    @Override
    public void enterEveryRule(ParserRuleContext arg0) {
        if (arg0 instanceof DmlParser.StatementContext && ((DmlParser.StatementContext)arg0).info == null) {
            ((DmlParser.StatementContext)arg0).info = new StatementInfo();
        }
        if (arg0 instanceof DmlParser.FunctionStatementContext && ((DmlParser.FunctionStatementContext)arg0).info == null) {
            ((DmlParser.FunctionStatementContext)arg0).info = new StatementInfo();
        }
        if (arg0 instanceof DmlParser.ExpressionContext && ((DmlParser.ExpressionContext)arg0).info == null) {
            ((DmlParser.ExpressionContext)arg0).info = new ExpressionInfo();
        }
        if (arg0 instanceof DmlParser.DataIdentifierContext && ((DmlParser.DataIdentifierContext)arg0).dataInfo == null) {
            ((DmlParser.DataIdentifierContext)arg0).dataInfo = new ExpressionInfo();
        }
    }

    @Override
    public void exitAddSubExpression(DmlParser.AddSubExpressionContext ctx) {
        this.binaryExpressionHelper(ctx, ctx.left.info, ctx.right.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitModIntDivExpression(DmlParser.ModIntDivExpressionContext ctx) {
        this.binaryExpressionHelper(ctx, ctx.left.info, ctx.right.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitUnaryExpression(DmlParser.UnaryExpressionContext ctx) {
        this.unaryExpressionHelper(ctx, ctx.left.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitMultDivExpression(DmlParser.MultDivExpressionContext ctx) {
        this.binaryExpressionHelper(ctx, ctx.left.info, ctx.right.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitPowerExpression(DmlParser.PowerExpressionContext ctx) {
        this.binaryExpressionHelper(ctx, ctx.left.info, ctx.right.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitMatrixMulExpression(DmlParser.MatrixMulExpressionContext ctx) {
        this.binaryExpressionHelper(ctx, ctx.left.info, ctx.right.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitRelationalExpression(DmlParser.RelationalExpressionContext ctx) {
        this.relationalExpressionHelper(ctx, ctx.left.info, ctx.right.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitBooleanAndExpression(DmlParser.BooleanAndExpressionContext ctx) {
        this.booleanExpressionHelper(ctx, ctx.left.info, ctx.right.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitBooleanOrExpression(DmlParser.BooleanOrExpressionContext ctx) {
        this.booleanExpressionHelper(ctx, ctx.left.info, ctx.right.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitBooleanNotExpression(DmlParser.BooleanNotExpressionContext ctx) {
        this.unaryBooleanExpressionHelper(ctx, ctx.left.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitAtomicExpression(DmlParser.AtomicExpressionContext ctx) {
        ctx.info.expr = ctx.left.info.expr;
        this.setFileLineColumn(ctx.info.expr, (ParserRuleContext)ctx);
    }

    @Override
    public void exitConstFalseExpression(DmlParser.ConstFalseExpressionContext ctx) {
        this.booleanIdentifierHelper(ctx, false, ctx.info);
    }

    @Override
    public void exitConstTrueExpression(DmlParser.ConstTrueExpressionContext ctx) {
        this.booleanIdentifierHelper(ctx, true, ctx.info);
    }

    @Override
    public void exitConstDoubleIdExpression(DmlParser.ConstDoubleIdExpressionContext ctx) {
        this.constDoubleIdExpressionHelper(ctx, ctx.info);
    }

    @Override
    public void exitConstIntIdExpression(DmlParser.ConstIntIdExpressionContext ctx) {
        this.constIntIdExpressionHelper(ctx, ctx.info);
    }

    @Override
    public void exitConstStringIdExpression(DmlParser.ConstStringIdExpressionContext ctx) {
        this.constStringIdExpressionHelper(ctx, ctx.info);
    }

    @Override
    public void exitDataIdExpression(DmlParser.DataIdExpressionContext ctx) {
        this.exitDataIdExpressionHelper(ctx, ctx.info, ctx.dataIdentifier().dataInfo);
    }

    @Override
    public void exitSimpleDataIdentifierExpression(DmlParser.SimpleDataIdentifierExpressionContext ctx) {
        ctx.dataInfo.expr = new DataIdentifier(ctx.getText());
        this.setFileLineColumn(ctx.dataInfo.expr, (ParserRuleContext)ctx);
    }

    @Override
    public void exitIndexedExpression(DmlParser.IndexedExpressionContext ctx) {
        boolean isRowLower = ctx.rowLower != null && !ctx.rowLower.isEmpty() && ctx.rowLower.info.expr != null;
        boolean isRowUpper = ctx.rowUpper != null && !ctx.rowUpper.isEmpty() && ctx.rowUpper.info.expr != null;
        boolean isColLower = ctx.colLower != null && !ctx.colLower.isEmpty() && ctx.colLower.info.expr != null;
        boolean isColUpper = ctx.colUpper != null && !ctx.colUpper.isEmpty() && ctx.colUpper.info.expr != null;
        ExpressionInfo rowLower = isRowLower ? ctx.rowLower.info : null;
        ExpressionInfo rowUpper = isRowUpper ? ctx.rowUpper.info : null;
        ExpressionInfo colLower = isColLower ? ctx.colLower.info : null;
        ExpressionInfo colUpper = isColUpper ? ctx.colUpper.info : null;
        ctx.dataInfo.expr = new IndexedIdentifier(ctx.name.getText(), false, false);
        this.setFileLineColumn(ctx.dataInfo.expr, (ParserRuleContext)ctx);
        try {
            ArrayList<ArrayList<Expression>> exprList = new ArrayList<ArrayList<Expression>>();
            ArrayList<Expression> rowIndices = new ArrayList<Expression>();
            ArrayList<Expression> colIndices = new ArrayList<Expression>();
            if (!isRowLower && !isRowUpper) {
                rowIndices.add(null);
                rowIndices.add(null);
            } else if (isRowLower && isRowUpper) {
                rowIndices.add(rowLower.expr);
                rowIndices.add(rowUpper.expr);
            } else if (isRowLower && !isRowUpper) {
                rowIndices.add(rowLower.expr);
            } else {
                this.notifyErrorListeners("incorrect index expression for row", ctx.start);
                return;
            }
            if (!isColLower && !isColUpper) {
                colIndices.add(null);
                colIndices.add(null);
            } else if (isColLower && isColUpper) {
                colIndices.add(colLower.expr);
                colIndices.add(colUpper.expr);
            } else if (isColLower && !isColUpper) {
                colIndices.add(colLower.expr);
            } else {
                this.notifyErrorListeners("incorrect index expression for column", ctx.start);
                return;
            }
            exprList.add(rowIndices);
            exprList.add(colIndices);
            ((IndexedIdentifier)ctx.dataInfo.expr).setIndices(exprList);
        }
        catch (Exception e) {
            this.notifyErrorListeners("cannot set the indices", ctx.start);
            return;
        }
    }

    @Override
    public void exitCommandlineParamExpression(DmlParser.CommandlineParamExpressionContext ctx) {
        this.handleCommandlineArgumentExpression(ctx);
    }

    @Override
    public void exitCommandlinePositionExpression(DmlParser.CommandlinePositionExpressionContext ctx) {
        this.handleCommandlineArgumentExpression(ctx);
    }

    private void handleCommandlineArgumentExpression(DmlParser.DataIdentifierContext ctx) {
        String varName = ctx.getText().trim();
        this.fillExpressionInfoCommandLineParameters(ctx, varName, ctx.dataInfo);
        if (ctx.dataInfo.expr == null && !(ctx.parent instanceof DmlParser.IfdefAssignmentStatementContext)) {
            String msg = "The parameter " + varName + " either needs to be passed through commandline or initialized to default value.";
            if (ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.IGNORE_UNSPECIFIED_ARGS)) {
                ctx.dataInfo.expr = this.getConstIdFromString(ctx, " ");
                if (!ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.MLCONTEXT)) {
                    this.raiseWarning(msg, ctx.start);
                }
            } else {
                this.notifyErrorListeners(msg, ctx.start);
            }
        }
    }

    @Override
    public void exitImportStatement(DmlParser.ImportStatementContext ctx) {
        File file;
        String filePath = ctx.filePath.getText();
        String namespace = ".defaultNS";
        if (ctx.namespace != null && ctx.namespace.getText() != null && !ctx.namespace.getText().isEmpty()) {
            namespace = ctx.namespace.getText();
        }
        if (filePath.startsWith("\"") && filePath.endsWith("\"") || filePath.startsWith("'") && filePath.endsWith("'")) {
            filePath = filePath.substring(1, filePath.length() - 1);
        }
        if (!(file = new File(filePath)).isAbsolute()) {
            filePath = this._workingDir + File.separator + filePath;
        }
        this.validateNamespace(namespace, filePath, ctx);
        String scriptID = DMLProgram.constructFunctionKey(namespace, filePath);
        DMLProgram prog = null;
        if (!((HashMap)_scripts.get()).containsKey(scriptID)) {
            ((HashMap)_scripts.get()).put(scriptID, namespace);
            try {
                prog = new DMLParserWrapper().doParse(filePath, null, this.getQualifiedNamespace(namespace), this.argVals);
            }
            catch (ParseException e) {
                this.notifyErrorListeners(e.getMessage(), ctx.start);
                return;
            }
            if (prog == null) {
                this.notifyErrorListeners("One or more errors found during importing a program from file " + filePath, ctx.start);
                return;
            }
            ctx.info.namespaces = new HashMap();
            ctx.info.namespaces.put(this.getQualifiedNamespace(namespace), prog);
            ctx.info.stmt = new ImportStatement();
            ((ImportStatement)ctx.info.stmt).setCompletePath(filePath);
            ((ImportStatement)ctx.info.stmt).setFilePath(ctx.filePath.getText());
            ((ImportStatement)ctx.info.stmt).setNamespace(namespace);
        } else {
            prog = new DMLProgram();
            ctx.info.namespaces = new HashMap();
            ctx.info.namespaces.put(this.getQualifiedNamespace(namespace), prog);
            ctx.info.stmt = new ImportStatement();
            ((ImportStatement)ctx.info.stmt).setCompletePath(filePath);
            ((ImportStatement)ctx.info.stmt).setFilePath(ctx.filePath.getText());
            ((ImportStatement)ctx.info.stmt).setNamespace(namespace);
        }
    }

    @Override
    public void exitAssignmentStatement(DmlParser.AssignmentStatementContext ctx) {
        if (ctx.targetList == null) {
            this.notifyErrorListeners("incorrect parsing for assignment", ctx.start);
            return;
        }
        this.exitAssignmentStatementHelper(ctx, ctx.targetList.getText(), ctx.targetList.dataInfo, ctx.targetList.start, ctx.source.info, ctx.info);
    }

    @Override
    public CommonSyntacticValidator.ConvertedDMLSyntax convertToDMLSyntax(ParserRuleContext ctx, String namespace, String functionName, ArrayList<ParameterExpression> paramExpression, Token fnName) {
        return new CommonSyntacticValidator.ConvertedDMLSyntax(namespace, functionName, paramExpression);
    }

    @Override
    protected Expression handleLanguageSpecificFunction(ParserRuleContext ctx, String functionName, ArrayList<ParameterExpression> paramExpressions) {
        return null;
    }

    @Override
    public void exitFunctionCallAssignmentStatement(DmlParser.FunctionCallAssignmentStatementContext ctx) {
        HashSet<String> printStatements = new HashSet<String>();
        printStatements.add("print");
        printStatements.add("stop");
        printStatements.add("assert");
        HashSet<String> outputStatements = new HashSet<String>();
        outputStatements.add("write");
        String[] fnNames = this.getQualifiedNames(ctx.name.getText());
        if (fnNames == null) {
            String errorMsg = "incorrect function name (only namespace " + this.namespaceResolutionOp() + " functionName allowed. Hint: If you are trying to use builtin functions, you can skip the namespace)";
            this.notifyErrorListeners(errorMsg, ctx.name);
            return;
        }
        String namespace = fnNames[0];
        String functionName = fnNames[1];
        ArrayList<ParameterExpression> paramExpression = this.getParameterExpressionList(ctx.paramExprs);
        this.castAsScalarDeprecationCheck(functionName, ctx);
        boolean hasLHS = ctx.targetList != null;
        this.functionCallAssignmentStatementHelper(ctx, printStatements, outputStatements, hasLHS ? ctx.targetList.dataInfo.expr : null, ctx.info, ctx.name, hasLHS ? ctx.targetList.start : null, namespace, functionName, paramExpression, hasLHS);
    }

    private void castAsScalarDeprecationCheck(String functionName, ParserRuleContext ctx) {
        if ("castAsScalar".equalsIgnoreCase(functionName)) {
            this.raiseWarning("castAsScalar() has been deprecated. Please use as.scalar().", ctx.start);
        }
    }

    @Override
    public void exitBuiltinFunctionExpression(DmlParser.BuiltinFunctionExpressionContext ctx) {
        String[] names = this.getQualifiedNames(ctx.name.getText());
        if (names == null) {
            this.notifyErrorListeners("incorrect function name (only namespace " + this.namespaceResolutionOp() + " functionName allowed. Hint: If you are trying to use builtin functions, you can skip the namespace)", ctx.name);
            return;
        }
        String namespace = names[0];
        String functionName = names[1];
        ArrayList<ParameterExpression> paramExpression = this.getParameterExpressionList(ctx.paramExprs);
        this.castAsScalarDeprecationCheck(functionName, ctx);
        CommonSyntacticValidator.ConvertedDMLSyntax convertedSyntax = this.convertToDMLSyntax(ctx, namespace, functionName, paramExpression, ctx.name);
        if (convertedSyntax == null) {
            return;
        }
        functionName = convertedSyntax.functionName;
        paramExpression = convertedSyntax.paramExpression;
        ctx.info.expr = this.buildForBuiltInFunction(ctx, functionName, paramExpression);
        if (ctx.info.expr != null) {
            return;
        }
        ctx.info.expr = this.createFunctionCall(ctx, namespace, functionName, paramExpression);
    }

    @Override
    public void exitFunctionCallMultiAssignmentStatement(DmlParser.FunctionCallMultiAssignmentStatementContext ctx) {
        Expression e;
        String[] names = this.getQualifiedNames(ctx.name.getText());
        if (names == null) {
            this.notifyErrorListeners("incorrect function name (only namespace.functionName allowed. Hint: If you are trying to use builtin functions, you can skip the namespace)", ctx.name);
            return;
        }
        String namespace = names[0];
        String functionName = names[1];
        ArrayList<ParameterExpression> paramExpression = this.getParameterExpressionList(ctx.paramExprs);
        CommonSyntacticValidator.ConvertedDMLSyntax convertedSyntax = this.convertToDMLSyntax(ctx, namespace, functionName, paramExpression, ctx.name);
        if (convertedSyntax == null) {
            return;
        }
        namespace = convertedSyntax.namespace;
        functionName = convertedSyntax.functionName;
        paramExpression = convertedSyntax.paramExpression;
        FunctionCallIdentifier functCall = new FunctionCallIdentifier(paramExpression);
        functCall.setFunctionName(functionName);
        functCall.setFunctionNamespace(namespace);
        ArrayList<DataIdentifier> targetList = new ArrayList<DataIdentifier>();
        for (DmlParser.DataIdentifierContext dataCtx : ctx.targetList) {
            if (dataCtx.dataInfo.expr instanceof DataIdentifier) {
                targetList.add((DataIdentifier)dataCtx.dataInfo.expr);
                continue;
            }
            this.notifyErrorListeners("incorrect type for variable ", dataCtx.start);
            return;
        }
        if (namespace.equals(".defaultNS") && (e = this.buildForBuiltInFunction(ctx, functionName, paramExpression)) != null) {
            this.setMultiAssignmentStatement(targetList, e, ctx, ctx.info);
            return;
        }
        String inferNamespace = this.sourceNamespace != null && this.sourceNamespace.length() > 0 && ".defaultNS".equals(namespace) ? this.sourceNamespace : namespace;
        functCall.setFunctionNamespace(inferNamespace);
        this.setMultiAssignmentStatement(targetList, functCall, ctx, ctx.info);
    }

    private static StatementBlock getStatementBlock(Statement current) {
        return ParserWrapper.getStatementBlock(current);
    }

    @Override
    public void exitIfStatement(DmlParser.IfStatementContext ctx) {
        IfStatement ifStmt = new IfStatement();
        ConditionalPredicate predicate = new ConditionalPredicate(ctx.predicate.info.expr);
        ifStmt.setConditionalPredicate(predicate);
        ifStmt.setCtxValuesAndFilename(ctx, this.currentFile);
        if (ctx.ifBody.size() > 0) {
            for (DmlParser.StatementContext stmtCtx : ctx.ifBody) {
                ifStmt.addStatementBlockIfBody(DmlSyntacticValidator.getStatementBlock(stmtCtx.info.stmt));
            }
            ifStmt.mergeStatementBlocksIfBody();
        }
        if (ctx.elseBody.size() > 0) {
            for (DmlParser.StatementContext stmtCtx : ctx.elseBody) {
                ifStmt.addStatementBlockElseBody(DmlSyntacticValidator.getStatementBlock(stmtCtx.info.stmt));
            }
            ifStmt.mergeStatementBlocksElseBody();
        }
        ctx.info.stmt = ifStmt;
        this.setFileLineColumn(ctx.info.stmt, (ParserRuleContext)ctx);
    }

    @Override
    public void exitWhileStatement(DmlParser.WhileStatementContext ctx) {
        WhileStatement whileStmt = new WhileStatement();
        ConditionalPredicate predicate = new ConditionalPredicate(ctx.predicate.info.expr);
        whileStmt.setPredicate(predicate);
        whileStmt.setCtxValuesAndFilename(ctx, this.currentFile);
        if (ctx.body.size() > 0) {
            for (DmlParser.StatementContext stmtCtx : ctx.body) {
                whileStmt.addStatementBlock(DmlSyntacticValidator.getStatementBlock(stmtCtx.info.stmt));
            }
            whileStmt.mergeStatementBlocks();
        }
        ctx.info.stmt = whileStmt;
        this.setFileLineColumn(ctx.info.stmt, (ParserRuleContext)ctx);
    }

    @Override
    public void exitForStatement(DmlParser.ForStatementContext ctx) {
        ForStatement forStmt = new ForStatement();
        DataIdentifier iterVar = new DataIdentifier(ctx.iterVar.getText());
        HashMap<String, String> parForParamValues = null;
        Expression incrementExpr = null;
        if (ctx.iterPred.info.increment != null) {
            incrementExpr = ctx.iterPred.info.increment;
        }
        IterablePredicate predicate = new IterablePredicate(ctx, iterVar, ctx.iterPred.info.from, ctx.iterPred.info.to, incrementExpr, parForParamValues, this.currentFile);
        forStmt.setPredicate(predicate);
        if (ctx.body.size() > 0) {
            for (DmlParser.StatementContext stmtCtx : ctx.body) {
                forStmt.addStatementBlock(DmlSyntacticValidator.getStatementBlock(stmtCtx.info.stmt));
            }
            forStmt.mergeStatementBlocks();
        }
        ctx.info.stmt = forStmt;
    }

    @Override
    public void exitParForStatement(DmlParser.ParForStatementContext ctx) {
        ParForStatement parForStmt = new ParForStatement();
        DataIdentifier iterVar = new DataIdentifier(ctx.iterVar.getText());
        HashMap<String, String> parForParamValues = new HashMap<String, String>();
        if (ctx.parForParams != null && ctx.parForParams.size() > 0) {
            for (DmlParser.StrictParameterizedExpressionContext parForParamCtx : ctx.parForParams) {
                String paramVal = parForParamCtx.paramVal.getText();
                if (this.argVals.containsKey(paramVal)) {
                    paramVal = (String)this.argVals.get(paramVal);
                }
                parForParamValues.put(parForParamCtx.paramName.getText(), paramVal);
            }
        }
        Expression incrementExpr = null;
        if (ctx.iterPred.info.increment != null) {
            incrementExpr = ctx.iterPred.info.increment;
        }
        IterablePredicate predicate = new IterablePredicate(ctx, iterVar, ctx.iterPred.info.from, ctx.iterPred.info.to, incrementExpr, parForParamValues, this.currentFile);
        parForStmt.setPredicate(predicate);
        if (ctx.body.size() > 0) {
            for (DmlParser.StatementContext stmtCtx : ctx.body) {
                parForStmt.addStatementBlock(DmlSyntacticValidator.getStatementBlock(stmtCtx.info.stmt));
            }
            parForStmt.mergeStatementBlocks();
        }
        ctx.info.stmt = parForStmt;
    }

    private ArrayList<DataIdentifier> getFunctionParameters(List<DmlParser.TypedArgNoAssignContext> ctx) {
        ArrayList<DataIdentifier> retVal = new ArrayList<DataIdentifier>();
        for (DmlParser.TypedArgNoAssignContext paramCtx : ctx) {
            DataIdentifier dataId = new DataIdentifier(paramCtx.paramName.getText());
            String dataType = null;
            String valueType = null;
            dataType = paramCtx.paramType == null || paramCtx.paramType.dataType() == null || paramCtx.paramType.dataType().getText() == null || paramCtx.paramType.dataType().getText().isEmpty() ? "scalar" : paramCtx.paramType.dataType().getText();
            this.checkValidDataType(dataType, paramCtx.start);
            if (dataType.equalsIgnoreCase("matrix")) {
                dataId.setDataType(Expression.DataType.MATRIX);
            } else if (dataType.equalsIgnoreCase("frame")) {
                dataId.setDataType(Expression.DataType.FRAME);
            } else if (dataType.equalsIgnoreCase("scalar")) {
                dataId.setDataType(Expression.DataType.SCALAR);
            }
            valueType = paramCtx.paramType.valueType().getText();
            if (valueType.equals("int") || valueType.equals("integer") || valueType.equals("Int") || valueType.equals("Integer")) {
                dataId.setValueType(Expression.ValueType.INT);
            } else if (valueType.equals("string") || valueType.equals("String")) {
                dataId.setValueType(Expression.ValueType.STRING);
            } else if (valueType.equals("boolean") || valueType.equals("Boolean")) {
                dataId.setValueType(Expression.ValueType.BOOLEAN);
            } else if (valueType.equals("double") || valueType.equals("Double")) {
                dataId.setValueType(Expression.ValueType.DOUBLE);
            } else {
                if (valueType.equals("bool")) {
                    this.notifyErrorListeners("invalid valuetype " + valueType + " (Quickfix: use 'boolean' instead)", paramCtx.start);
                    return null;
                }
                this.notifyErrorListeners("invalid valuetype " + valueType, paramCtx.start);
                return null;
            }
            retVal.add(dataId);
        }
        return retVal;
    }

    @Override
    public void exitIterablePredicateColonExpression(DmlParser.IterablePredicateColonExpressionContext ctx) {
        ctx.info.from = ctx.from.info.expr;
        ctx.info.to = ctx.to.info.expr;
        ctx.info.increment = null;
    }

    @Override
    public void exitIterablePredicateSeqExpression(DmlParser.IterablePredicateSeqExpressionContext ctx) {
        if (!ctx.ID().getText().equals("seq")) {
            this.notifyErrorListeners("incorrect function:'" + ctx.ID().getText() + "'. expected 'seq'", ctx.start);
            return;
        }
        ctx.info.from = ctx.from.info.expr;
        ctx.info.to = ctx.to.info.expr;
        if (ctx.increment != null && ctx.increment.info != null) {
            ctx.info.increment = ctx.increment.info.expr;
        }
    }

    @Override
    public void exitInternalFunctionDefExpression(DmlParser.InternalFunctionDefExpressionContext ctx) {
        ArrayList<StatementBlock> body;
        FunctionStatement functionStmt = new FunctionStatement();
        ArrayList<DataIdentifier> functionInputs = this.getFunctionParameters(ctx.inputParams);
        functionStmt.setInputParams(functionInputs);
        ArrayList<DataIdentifier> functionOutputs = this.getFunctionParameters(ctx.outputParams);
        functionStmt.setOutputParams(functionOutputs);
        functionStmt.setName(ctx.name.getText());
        if (ctx.body.size() > 0) {
            body = new ArrayList<StatementBlock>();
            for (DmlParser.StatementContext stmtCtx : ctx.body) {
                body.add(DmlSyntacticValidator.getStatementBlock(stmtCtx.info.stmt));
            }
        } else {
            this.notifyErrorListeners("functions with no statements are not allowed", ctx.start);
            return;
        }
        functionStmt.setBody(body);
        functionStmt.mergeStatementBlocks();
        ctx.info.stmt = functionStmt;
        this.setFileLineColumn(ctx.info.stmt, (ParserRuleContext)ctx);
        ctx.info.functionName = ctx.name.getText();
    }

    @Override
    public void exitExternalFunctionDefExpression(DmlParser.ExternalFunctionDefExpressionContext ctx) {
        ExternalFunctionStatement functionStmt = new ExternalFunctionStatement();
        ArrayList<DataIdentifier> functionInputs = this.getFunctionParameters(ctx.inputParams);
        functionStmt.setInputParams(functionInputs);
        ArrayList<DataIdentifier> functionOutputs = this.getFunctionParameters(ctx.outputParams);
        functionStmt.setOutputParams(functionOutputs);
        functionStmt.setName(ctx.name.getText());
        HashMap<String, String> otherParams = new HashMap<String, String>();
        boolean atleastOneClassName = false;
        for (DmlParser.StrictParameterizedKeyValueStringContext otherParamCtx : ctx.otherParams) {
            String paramName = otherParamCtx.paramName.getText();
            String val = "";
            String text = otherParamCtx.paramVal.getText();
            if (text.startsWith("\"") && text.endsWith("\"") || text.startsWith("'") && text.endsWith("'")) {
                if (text.length() > 2) {
                    val = text.substring(1, text.length() - 1);
                }
            } else {
                this.notifyErrorListeners("the value of user parameter for external function should be of type string", ctx.start);
                return;
            }
            otherParams.put(paramName, val);
            if (!paramName.equals("classname")) continue;
            atleastOneClassName = true;
        }
        functionStmt.setOtherParams(otherParams);
        if (!atleastOneClassName) {
            this.notifyErrorListeners("The 'classname' argument needs to be passed to the externalFunction 'implemented in' clause.", ctx.start);
            return;
        }
        ctx.info.stmt = functionStmt;
        this.setFileLineColumn(ctx.info.stmt, (ParserRuleContext)ctx);
        ctx.info.functionName = ctx.name.getText();
    }

    @Override
    public void exitPathStatement(DmlParser.PathStatementContext ctx) {
        PathStatement stmt = new PathStatement(ctx.pathValue.getText());
        String filePath = ctx.pathValue.getText();
        if (filePath.startsWith("\"") && filePath.endsWith("\"") || filePath.startsWith("'") && filePath.endsWith("'")) {
            filePath = filePath.substring(1, filePath.length() - 1);
        }
        this._workingDir = filePath;
        ctx.info.stmt = stmt;
    }

    @Override
    public void exitIfdefAssignmentStatement(DmlParser.IfdefAssignmentStatementContext ctx) {
        if (!ctx.commandLineParam.getText().startsWith("$")) {
            this.notifyErrorListeners("the first argument of ifdef function should be a commandline argument parameter (which starts with $)", ctx.commandLineParam.start);
            return;
        }
        if (ctx.targetList == null) {
            this.notifyErrorListeners("ifdef assignment needs an lvalue ", ctx.start);
            return;
        }
        String targetListText = ctx.targetList.getText();
        if (targetListText.startsWith("$")) {
            this.notifyErrorListeners("lhs of ifdef function cannot be a commandline parameters. Use local variable instead", ctx.start);
            return;
        }
        DataIdentifier target = null;
        if (ctx.targetList.dataInfo.expr instanceof DataIdentifier) {
            target = (DataIdentifier)ctx.targetList.dataInfo.expr;
            Expression source = null;
            source = ctx.commandLineParam.dataInfo.expr != null ? ctx.commandLineParam.dataInfo.expr : ctx.source.info.expr;
            try {
                ctx.info.stmt = new AssignmentStatement(ctx, target, source, this.currentFile);
            }
            catch (LanguageException e) {
                this.notifyErrorListeners("invalid assignment for ifdef function", ctx.targetList.start);
                return;
            }
        } else {
            this.notifyErrorListeners("incorrect lvalue in ifdef function ", ctx.targetList.start);
            return;
        }
    }

    @Override
    public void exitAccumulatorAssignmentStatement(DmlParser.AccumulatorAssignmentStatementContext ctx) {
        if (ctx.targetList == null) {
            this.notifyErrorListeners("incorrect parsing for accumulator assignment", ctx.start);
            return;
        }
        this.exitAssignmentStatementHelper(ctx, ctx.targetList.getText(), ctx.targetList.dataInfo, ctx.targetList.start, ctx.source.info, ctx.info);
        ((AssignmentStatement)ctx.info.stmt).setAccumulator(true);
    }

    @Override
    public void exitMatrixDataTypeCheck(DmlParser.MatrixDataTypeCheckContext ctx) {
        this.checkValidDataType(ctx.ID().getText(), ctx.start);
    }

    @Override
    public void visitTerminal(TerminalNode node) {
    }

    @Override
    public void visitErrorNode(ErrorNode node) {
    }

    @Override
    public void exitEveryRule(ParserRuleContext ctx) {
    }

    @Override
    public void enterModIntDivExpression(DmlParser.ModIntDivExpressionContext ctx) {
    }

    @Override
    public void enterExternalFunctionDefExpression(DmlParser.ExternalFunctionDefExpressionContext ctx) {
    }

    @Override
    public void enterBooleanNotExpression(DmlParser.BooleanNotExpressionContext ctx) {
    }

    @Override
    public void enterPowerExpression(DmlParser.PowerExpressionContext ctx) {
    }

    @Override
    public void enterInternalFunctionDefExpression(DmlParser.InternalFunctionDefExpressionContext ctx) {
    }

    @Override
    public void enterBuiltinFunctionExpression(DmlParser.BuiltinFunctionExpressionContext ctx) {
    }

    @Override
    public void enterConstIntIdExpression(DmlParser.ConstIntIdExpressionContext ctx) {
    }

    @Override
    public void enterAtomicExpression(DmlParser.AtomicExpressionContext ctx) {
    }

    @Override
    public void enterIfdefAssignmentStatement(DmlParser.IfdefAssignmentStatementContext ctx) {
    }

    @Override
    public void enterAccumulatorAssignmentStatement(DmlParser.AccumulatorAssignmentStatementContext ctx) {
    }

    @Override
    public void enterConstStringIdExpression(DmlParser.ConstStringIdExpressionContext ctx) {
    }

    @Override
    public void enterConstTrueExpression(DmlParser.ConstTrueExpressionContext ctx) {
    }

    @Override
    public void enterParForStatement(DmlParser.ParForStatementContext ctx) {
    }

    @Override
    public void enterUnaryExpression(DmlParser.UnaryExpressionContext ctx) {
    }

    @Override
    public void enterImportStatement(DmlParser.ImportStatementContext ctx) {
    }

    @Override
    public void enterPathStatement(DmlParser.PathStatementContext ctx) {
    }

    @Override
    public void enterWhileStatement(DmlParser.WhileStatementContext ctx) {
    }

    @Override
    public void enterCommandlineParamExpression(DmlParser.CommandlineParamExpressionContext ctx) {
    }

    @Override
    public void enterFunctionCallAssignmentStatement(DmlParser.FunctionCallAssignmentStatementContext ctx) {
    }

    @Override
    public void enterAddSubExpression(DmlParser.AddSubExpressionContext ctx) {
    }

    @Override
    public void enterIfStatement(DmlParser.IfStatementContext ctx) {
    }

    @Override
    public void enterConstDoubleIdExpression(DmlParser.ConstDoubleIdExpressionContext ctx) {
    }

    @Override
    public void enterMatrixMulExpression(DmlParser.MatrixMulExpressionContext ctx) {
    }

    @Override
    public void enterMatrixDataTypeCheck(DmlParser.MatrixDataTypeCheckContext ctx) {
    }

    @Override
    public void enterCommandlinePositionExpression(DmlParser.CommandlinePositionExpressionContext ctx) {
    }

    @Override
    public void enterIterablePredicateColonExpression(DmlParser.IterablePredicateColonExpressionContext ctx) {
    }

    @Override
    public void enterAssignmentStatement(DmlParser.AssignmentStatementContext ctx) {
    }

    @Override
    public void enterValueType(DmlParser.ValueTypeContext ctx) {
    }

    @Override
    public void exitValueType(DmlParser.ValueTypeContext ctx) {
    }

    @Override
    public void enterMl_type(DmlParser.Ml_typeContext ctx) {
    }

    @Override
    public void exitMl_type(DmlParser.Ml_typeContext ctx) {
    }

    @Override
    public void enterBooleanAndExpression(DmlParser.BooleanAndExpressionContext ctx) {
    }

    @Override
    public void enterForStatement(DmlParser.ForStatementContext ctx) {
    }

    @Override
    public void enterRelationalExpression(DmlParser.RelationalExpressionContext ctx) {
    }

    @Override
    public void enterTypedArgNoAssign(DmlParser.TypedArgNoAssignContext ctx) {
    }

    @Override
    public void exitTypedArgNoAssign(DmlParser.TypedArgNoAssignContext ctx) {
    }

    @Override
    public void enterStrictParameterizedExpression(DmlParser.StrictParameterizedExpressionContext ctx) {
    }

    @Override
    public void exitStrictParameterizedExpression(DmlParser.StrictParameterizedExpressionContext ctx) {
    }

    @Override
    public void enterMultDivExpression(DmlParser.MultDivExpressionContext ctx) {
    }

    @Override
    public void enterConstFalseExpression(DmlParser.ConstFalseExpressionContext ctx) {
    }

    @Override
    public void enterStrictParameterizedKeyValueString(DmlParser.StrictParameterizedKeyValueStringContext ctx) {
    }

    @Override
    public void exitStrictParameterizedKeyValueString(DmlParser.StrictParameterizedKeyValueStringContext ctx) {
    }

    @Override
    public void enterProgramroot(DmlParser.ProgramrootContext ctx) {
    }

    @Override
    public void exitProgramroot(DmlParser.ProgramrootContext ctx) {
    }

    @Override
    public void enterDataIdExpression(DmlParser.DataIdExpressionContext ctx) {
    }

    @Override
    public void enterIndexedExpression(DmlParser.IndexedExpressionContext ctx) {
    }

    @Override
    public void enterParameterizedExpression(DmlParser.ParameterizedExpressionContext ctx) {
    }

    @Override
    public void exitParameterizedExpression(DmlParser.ParameterizedExpressionContext ctx) {
    }

    @Override
    public void enterFunctionCallMultiAssignmentStatement(DmlParser.FunctionCallMultiAssignmentStatementContext ctx) {
    }

    @Override
    public void enterIterablePredicateSeqExpression(DmlParser.IterablePredicateSeqExpressionContext ctx) {
    }

    @Override
    public void enterSimpleDataIdentifierExpression(DmlParser.SimpleDataIdentifierExpressionContext ctx) {
    }

    @Override
    public void enterBooleanOrExpression(DmlParser.BooleanOrExpressionContext ctx) {
    }

    @Override
    public void enterMultiIdExpression(DmlParser.MultiIdExpressionContext ctx) {
    }

    @Override
    public void exitMultiIdExpression(DmlParser.MultiIdExpressionContext ctx) {
        ArrayList<Expression> values = new ArrayList<Expression>();
        for (DmlParser.ExpressionContext elem : ctx.targetList) {
            values.add(elem.info.expr);
        }
        ctx.info.expr = new ExpressionList(values);
    }
}

