/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.util.HashMap;
import org.apache.sysml.parser.ConstIdentifier;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.IndexPair;
import org.apache.sysml.parser.IndexedIdentifier;
import org.apache.sysml.parser.LanguageException;

public abstract class Identifier
extends Expression {
    protected Expression.DataType _dataType = Expression.DataType.UNKNOWN;
    protected Expression.ValueType _valueType = Expression.ValueType.UNKNOWN;
    protected long _dim1 = -1L;
    protected long _dim2 = -1L;
    protected long _rows_in_block = -1L;
    protected long _columns_in_block = -1L;
    protected long _nnz = -1L;
    protected Expression.FormatType _formatType;

    public Identifier() {
        this.setOutput(this);
        this._formatType = null;
    }

    public void setProperties(Identifier i) {
        if (i == null) {
            return;
        }
        this._dataType = i.getDataType();
        this._valueType = i.getValueType();
        if (i instanceof IndexedIdentifier) {
            this._dim1 = ((IndexedIdentifier)i).getOrigDim1();
            this._dim2 = ((IndexedIdentifier)i).getOrigDim2();
        } else {
            this._dim1 = i.getDim1();
            this._dim2 = i.getDim2();
        }
        this._rows_in_block = i.getRowsInBlock();
        this._columns_in_block = i.getColumnsInBlock();
        this._nnz = i.getNnz();
        this._formatType = i.getFormatType();
    }

    public void setDimensionValueProperties(Identifier i) {
        if (i instanceof IndexedIdentifier) {
            IndexedIdentifier ixi = (IndexedIdentifier)i;
            this._dim1 = ixi.getOrigDim1();
            this._dim2 = ixi.getOrigDim2();
        } else {
            this._dim1 = i.getDim1();
            this._dim2 = i.getDim2();
        }
        this._nnz = i.getNnz();
        this._dataType = i.getDataType();
        this._valueType = i.getValueType();
    }

    public void setDataType(Expression.DataType dt) {
        this._dataType = dt;
    }

    public void setValueType(Expression.ValueType vt) {
        this._valueType = vt;
    }

    public void setFormatType(Expression.FormatType ft) {
        this._formatType = ft;
    }

    public void setDimensions(long dim1, long dim2) {
        this._dim1 = dim1;
        this._dim2 = dim2;
    }

    public void setBlockDimensions(long dim1, long dim2) {
        this._rows_in_block = dim1;
        this._columns_in_block = dim2;
    }

    public void setNnz(long nnzs) {
        this._nnz = nnzs;
    }

    public long getDim1() {
        return this._dim1;
    }

    public long getDim2() {
        return this._dim2;
    }

    public Expression.DataType getDataType() {
        return this._dataType;
    }

    public Expression.ValueType getValueType() {
        return this._valueType;
    }

    public Expression.FormatType getFormatType() {
        return this._formatType;
    }

    public long getRowsInBlock() {
        return this._rows_in_block;
    }

    public long getColumnsInBlock() {
        return this._columns_in_block;
    }

    public long getNnz() {
        return this._nnz;
    }

    @Override
    public void validateExpression(HashMap<String, DataIdentifier> ids, HashMap<String, ConstIdentifier> constVars, boolean conditional) throws LanguageException {
        if (this.getOutput() instanceof DataIdentifier) {
            String name = ((DataIdentifier)this.getOutput()).getName();
            Identifier id = ids.get(name);
            if (id == null) {
                this.raiseValidateError("Undefined Variable (" + name + ") used in statement", false, "Invalid Parameters");
            }
            this.getOutput().setProperties(id);
            if (this.getOutput() instanceof IndexedIdentifier) {
                Expression tempExpr;
                IndexedIdentifier indexedIdentiferOut = (IndexedIdentifier)this.getOutput();
                if (indexedIdentiferOut.getRowLowerBound() != null) {
                    indexedIdentiferOut.getRowLowerBound().validateExpression(ids, constVars, conditional);
                    tempExpr = indexedIdentiferOut.getRowLowerBound();
                    if (tempExpr.getOutput().getDataType() == Expression.DataType.MATRIX) {
                        this.raiseValidateError("Matrix values for row lower index bound are not supported, which includes indexed identifiers.", conditional);
                    }
                }
                if (indexedIdentiferOut.getRowUpperBound() != null) {
                    indexedIdentiferOut.getRowUpperBound().validateExpression(ids, constVars, conditional);
                    tempExpr = indexedIdentiferOut.getRowUpperBound();
                    if (tempExpr.getOutput().getDataType() == Expression.DataType.MATRIX) {
                        this.raiseValidateError("Matrix values for row upper index bound are not supported, which includes indexed identifiers.", conditional);
                    }
                }
                if (indexedIdentiferOut.getColLowerBound() != null) {
                    indexedIdentiferOut.getColLowerBound().validateExpression(ids, constVars, conditional);
                    tempExpr = indexedIdentiferOut.getColLowerBound();
                    if (tempExpr.getOutput().getDataType() == Expression.DataType.MATRIX) {
                        this.raiseValidateError("Matrix values for column lower index bound are not supported, which includes indexed identifiers.", conditional);
                    }
                }
                if (indexedIdentiferOut.getColUpperBound() != null) {
                    indexedIdentiferOut.getColUpperBound().validateExpression(ids, constVars, conditional);
                    tempExpr = indexedIdentiferOut.getColUpperBound();
                    if (tempExpr.getOutput().getDataType() == Expression.DataType.MATRIX) {
                        this.raiseValidateError("Matrix values for column upper index bound are not supported, which includes indexed identifiers.", conditional);
                    }
                }
                IndexPair updatedIndices = ((IndexedIdentifier)this.getOutput()).calculateIndexedDimensions(ids, constVars, conditional);
                ((IndexedIdentifier)this.getOutput()).setDimensions(updatedIndices._row, updatedIndices._col);
            }
        } else {
            this.getOutput().setProperties(this.getOutput());
        }
    }

    public void computeDataType() {
        this._dataType = this._dim1 == 0L && this._dim2 == 0L ? Expression.DataType.SCALAR : (this._dim1 >= 1L || this._dim2 >= 1L ? Expression.DataType.MATRIX : Expression.DataType.UNKNOWN);
    }

    public void setBooleanProperties() {
        this._dataType = Expression.DataType.SCALAR;
        this._valueType = Expression.ValueType.BOOLEAN;
        this._dim1 = 0L;
        this._dim2 = 0L;
        this._rows_in_block = 0L;
        this._columns_in_block = 0L;
        this._nnz = -1L;
        this._formatType = null;
    }

    public void setIntProperties() {
        this._dataType = Expression.DataType.SCALAR;
        this._valueType = Expression.ValueType.INT;
        this._dim1 = 0L;
        this._dim2 = 0L;
        this._rows_in_block = 0L;
        this._columns_in_block = 0L;
        this._nnz = -1L;
        this._formatType = null;
    }

    public boolean isScalarBoolean() {
        return this._valueType == Expression.ValueType.BOOLEAN && this._dataType == Expression.DataType.SCALAR;
    }

    public boolean dimsKnown() {
        return this._dim1 >= 0L && this._dim2 >= 0L;
    }
}

