/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class Binary
extends Lop {
    private OperationTypes operation;
    private int numThreads = -1;
    boolean isLeftTransposed;
    boolean isRightTransposed;

    public Binary(Lop input1, Lop input2, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        this(input1, input2, op, dt, vt, et, 1);
    }

    public Binary(Lop input1, Lop input2, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et, int k) {
        super(Lop.Type.Binary, dt, vt);
        this.init(input1, input2, op, dt, vt, et);
        this.numThreads = k;
    }

    public Binary(Lop input1, Lop input2, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et, boolean isLeftTransposed, boolean isRightTransposed) {
        super(Lop.Type.Binary, dt, vt);
        this.init(input1, input2, op, dt, vt, et);
        this.isLeftTransposed = isLeftTransposed;
        this.isRightTransposed = isRightTransposed;
    }

    private void init(Lop input1, Lop input2, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        this.operation = op;
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        if (et == LopProperties.ExecType.MR) {
            this.lps.addCompatibility(JobType.GMR);
            this.lps.addCompatibility(JobType.DATAGEN);
            this.lps.addCompatibility(JobType.REBLOCK);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.Reduce, breaksAlignment, aligner, definesMRJob);
        } else if (et == LopProperties.ExecType.CP || et == LopProperties.ExecType.SPARK || et == LopProperties.ExecType.GPU) {
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    @Override
    public String toString() {
        return " Operation: " + (Object)((Object)this.operation);
    }

    public OperationTypes getOperationType() {
        return this.operation;
    }

    private String getOpcode() {
        return Binary.getOpcode(this.operation);
    }

    public static String getOpcode(OperationTypes op) {
        switch (op) {
            case ADD: {
                return "+";
            }
            case SUBTRACT: {
                return "-";
            }
            case MULTIPLY: {
                return "*";
            }
            case DIVIDE: {
                return "/";
            }
            case MODULUS: {
                return "%%";
            }
            case INTDIV: {
                return "%/%";
            }
            case MATMULT: {
                return "ba+*";
            }
            case MINUS1_MULTIPLY: {
                return "1-*";
            }
            case LESS_THAN: {
                return "<";
            }
            case LESS_THAN_OR_EQUALS: {
                return "<=";
            }
            case GREATER_THAN: {
                return ">";
            }
            case GREATER_THAN_OR_EQUALS: {
                return ">=";
            }
            case EQUALS: {
                return "==";
            }
            case NOT_EQUALS: {
                return "!=";
            }
            case AND: {
                return "&&";
            }
            case OR: {
                return "||";
            }
            case XOR: {
                return "xor";
            }
            case BW_AND: {
                return "bitwAnd";
            }
            case BW_OR: {
                return "bitwOr";
            }
            case BW_XOR: {
                return "bitwXor";
            }
            case BW_SHIFTL: {
                return "bitwShiftL";
            }
            case BW_SHIFTR: {
                return "bitwShiftR";
            }
            case MIN: {
                return "min";
            }
            case MAX: {
                return "max";
            }
            case POW: {
                return "^";
            }
            case SOLVE: {
                return "solve";
            }
        }
        throw new UnsupportedOperationException("Instruction is not defined for Binary operation: " + (Object)((Object)op));
    }

    @Override
    public String getInstructions(int input_index1, int input_index2, int output_index) throws LopsException {
        return this.getInstructions(String.valueOf(input_index1), String.valueOf(input_index2), String.valueOf(output_index));
    }

    @Override
    public String getInstructions(String input1, String input2, String output) throws LopsException {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input2));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        if (this.operation == OperationTypes.MATMULT && this.getExecType() == LopProperties.ExecType.CP) {
            sb.append("\u00b0");
            sb.append(this.numThreads);
        } else if (this.operation == OperationTypes.MATMULT && this.getExecType() == LopProperties.ExecType.GPU) {
            sb.append("\u00b0");
            sb.append(this.isLeftTransposed);
            sb.append("\u00b0");
            sb.append(this.isRightTransposed);
        }
        return sb.toString();
    }

    public static enum OperationTypes {
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        MINUS1_MULTIPLY,
        MODULUS,
        INTDIV,
        MATMULT,
        LESS_THAN,
        LESS_THAN_OR_EQUALS,
        GREATER_THAN,
        GREATER_THAN_OR_EQUALS,
        EQUALS,
        NOT_EQUALS,
        AND,
        OR,
        XOR,
        MAX,
        MIN,
        POW,
        SOLVE,
        NOTSUPPORTED,
        BW_AND,
        BW_OR,
        BW_XOR,
        BW_SHIFTL,
        BW_SHIFTR;

    }
}

