/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.rewrite;

import java.util.ArrayList;
import java.util.List;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.hops.rewrite.ProgramRewriteStatus;
import org.apache.sysml.hops.rewrite.StatementBlockRewriteRule;
import org.apache.sysml.parser.IfStatement;
import org.apache.sysml.parser.IfStatementBlock;
import org.apache.sysml.parser.StatementBlock;

public class RewriteRemoveUnnecessaryBranches
extends StatementBlockRewriteRule {
    @Override
    public boolean createsSplitDag() {
        return false;
    }

    @Override
    public List<StatementBlock> rewriteStatementBlock(StatementBlock sb, ProgramRewriteStatus state) throws HopsException {
        ArrayList<StatementBlock> ret = new ArrayList<StatementBlock>();
        if (sb instanceof IfStatementBlock) {
            IfStatementBlock isb = (IfStatementBlock)sb;
            Hop pred = isb.getPredicateHops().getInput().get(0);
            if (pred instanceof LiteralOp) {
                IfStatement istmt = (IfStatement)isb.getStatement(0);
                LiteralOp litpred = (LiteralOp)pred;
                boolean condition = HopRewriteUtils.getBooleanValue(litpred);
                if (condition) {
                    if (!istmt.getIfBody().isEmpty()) {
                        ret.addAll(istmt.getIfBody());
                    }
                } else if (!istmt.getElseBody().isEmpty()) {
                    ret.addAll(istmt.getElseBody());
                }
                state.setRemovedBranches();
                LOG.debug((Object)("Applied removeUnnecessaryBranches (lines " + sb.getBeginLine() + "-" + sb.getEndLine() + ")."));
            } else {
                ret.add(sb);
            }
        } else {
            ret.add(sb);
        }
        return ret;
    }

    @Override
    public List<StatementBlock> rewriteStatementBlocks(List<StatementBlock> sbs, ProgramRewriteStatus sate) throws HopsException {
        return sbs;
    }
}

