/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.DMLScriptException;
import org.apache.sysml.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContextFactory;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObjectFactory;

public class FunctionCallCPInstruction
extends CPInstruction {
    private final String _functionName;
    private final String _namespace;
    private final CPOperand[] _boundInputs;
    private final ArrayList<String> _boundInputNames;
    private final ArrayList<String> _boundOutputNames;

    public FunctionCallCPInstruction(String namespace, String functName, CPOperand[] boundInputs, ArrayList<String> boundInputNames, ArrayList<String> boundOutputNames, String istr) {
        super(CPInstruction.CPType.External, null, functName, istr);
        this._functionName = functName;
        this._namespace = namespace;
        this._boundInputs = boundInputs;
        this._boundInputNames = boundInputNames;
        this._boundOutputNames = boundOutputNames;
    }

    public String getFunctionName() {
        return this._functionName;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public static FunctionCallCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        int i;
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String namespace = parts[1];
        String functionName = parts[2];
        int numInputs = Integer.valueOf(parts[3]);
        int numOutputs = Integer.valueOf(parts[4]);
        CPOperand[] boundInputs = new CPOperand[numInputs];
        ArrayList<String> boundInputNames = new ArrayList<String>();
        ArrayList<String> boundOutputNames = new ArrayList<String>();
        for (i = 0; i < numInputs; ++i) {
            boundInputs[i] = new CPOperand(parts[5 + i]);
            boundInputNames.add(boundInputs[i].getName());
        }
        for (i = 0; i < numOutputs; ++i) {
            boundOutputNames.add(parts[5 + numInputs + i]);
        }
        return new FunctionCallCPInstruction(namespace, functionName, boundInputs, boundInputNames, boundOutputNames, str);
    }

    @Override
    public Instruction preprocessInstruction(ExecutionContext ec) throws DMLRuntimeException {
        Instruction tmp = super.preprocessInstruction(ec);
        if (DMLScript.ENABLE_DEBUG_MODE) {
            ec.handleDebugFunctionEntry((FunctionCallCPInstruction)tmp);
        }
        return tmp;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        void var8_14;
        FunctionProgramBlock fpb;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Executing instruction : " + this.toString()));
        }
        if (this._boundInputs.length < (fpb = ec.getProgram().getFunctionProgramBlock(this._namespace, this._functionName)).getInputParams().size()) {
            throw new DMLRuntimeException("Number of bound input parameters does not match the function signature (" + this._boundInputs.length + ", but " + fpb.getInputParams().size() + " expected)");
        }
        LocalVariableMap functionVariables = new LocalVariableMap();
        for (int i = 0; i < fpb.getInputParams().size(); ++i) {
            CPOperand input = this._boundInputs[i];
            if (!input.isLiteral() && !ec.containsVariable(input.getName())) {
                throw new DMLRuntimeException("Input variable '" + input.getName() + "' not existing on call of " + DMLProgram.constructFunctionKey(this._namespace, this._functionName) + " (line " + this.getLineNum() + ").");
            }
            DataIdentifier currFormalParam = fpb.getInputParams().get(i);
            Data value = ec.getVariable(input);
            if (value.getDataType() == Expression.DataType.SCALAR && value.getValueType() != currFormalParam.getValueType()) {
                value = ScalarObjectFactory.createScalarObject(currFormalParam.getValueType(), (ScalarObject)value);
            }
            functionVariables.put(currFormalParam.getName(), value);
        }
        boolean[] pinStatus = ec.pinVariables(this._boundInputNames);
        ExecutionContext fn_ec = ExecutionContextFactory.createContext(false, ec.getProgram());
        if (DMLScript.USE_ACCELERATOR) {
            fn_ec.setGPUContexts(ec.getGPUContexts());
            fn_ec.getGPUContext(0).initializeThread();
        }
        fn_ec.setVariables(functionVariables);
        try {
            fpb._functionName = this._functionName;
            fpb._namespace = this._namespace;
            fpb.execute(fn_ec);
        }
        catch (DMLScriptException e) {
            throw e;
        }
        catch (Exception e) {
            String fname = DMLProgram.constructFunctionKey(this._namespace, this._functionName);
            throw new DMLRuntimeException("error executing function " + (String)fname, e);
        }
        HashSet<String> expectRetVars = new HashSet<String>();
        for (DataIdentifier dataIdentifier : fpb.getOutputParams()) {
            expectRetVars.add(dataIdentifier.getName());
        }
        LocalVariableMap retVars = fn_ec.getVariables();
        for (Map.Entry<String, Data> entry : retVars.entrySet()) {
            if (expectRetVars.contains(entry.getKey()) || !(entry.getValue() instanceof CacheableData)) continue;
            fn_ec.cleanupCacheableData((CacheableData)entry.getValue());
        }
        ec.unpinVariables(this._boundInputNames, pinStatus);
        boolean bl = false;
        while (var8_14 < fpb.getOutputParams().size()) {
            String string = this._boundOutputNames.get((int)var8_14);
            Data boundValue = retVars.get(fpb.getOutputParams().get((int)var8_14).getName());
            if (boundValue == null) {
                throw new DMLRuntimeException(string + " was not assigned a return value");
            }
            Data exdata = ec.removeVariable(string);
            if (exdata != null && exdata instanceof CacheableData && exdata != boundValue) {
                ec.cleanupCacheableData((CacheableData)exdata);
            }
            ec.setVariable(string, boundValue);
            ++var8_14;
        }
    }

    @Override
    public void postprocessInstruction(ExecutionContext ec) throws DMLRuntimeException {
        if (DMLScript.ENABLE_DEBUG_MODE) {
            ec.handleDebugFunctionExit(this);
        }
        super.postprocessInstruction(ec);
    }

    @Override
    public void printMe() {
        LOG.debug((Object)("ExternalBuiltInFunction: " + this.toString()));
    }

    public ArrayList<String> getBoundInputParamNames() {
        return this._boundInputNames;
    }

    public ArrayList<String> getBoundOutputParamNames() {
        return this._boundOutputNames;
    }

    public String updateInstStringFunctionName(String pattern, String replace) {
        String[] parts = this.instString.split("\u00b0");
        if (parts[3].equals(pattern)) {
            parts[3] = replace;
        }
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            sb.append(part);
            sb.append("\u00b0");
        }
        return sb.substring(0, sb.length() - "\u00b0".length());
    }
}

