/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Aggregate;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class CumulativePartialAggregate
extends Lop {
    private Aggregate.OperationTypes _op;

    public CumulativePartialAggregate(Lop input, Expression.DataType dt, Expression.ValueType vt, Aggregate.OperationTypes op, LopProperties.ExecType et) throws LopsException {
        super(Lop.Type.CumulativePartialAggregate, dt, vt);
        if (op != Aggregate.OperationTypes.KahanSum && op != Aggregate.OperationTypes.Product && op != Aggregate.OperationTypes.Min && op != Aggregate.OperationTypes.Max) {
            throw new LopsException("Unsupported aggregate operation type: " + (Object)((Object)op));
        }
        this._op = op;
        this.init(input, dt, vt, et);
    }

    private void init(Lop input, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        this.addInput(input);
        input.addOutput(this);
        if (et == LopProperties.ExecType.MR) {
            boolean breaksAlignment = true;
            boolean aligner = false;
            boolean definesMRJob = false;
            this.lps.addCompatibility(JobType.GMR);
            this.lps.addCompatibility(JobType.DATAGEN);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.Map, breaksAlignment, aligner, definesMRJob);
        } else {
            boolean breaksAlignment = false;
            boolean aligner = false;
            boolean definesMRJob = false;
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    @Override
    public String toString() {
        return "CumulativePartialAggregate";
    }

    private String getOpcode() {
        switch (this._op) {
            case KahanSum: {
                return "ucumack+";
            }
            case Product: {
                return "ucumac*";
            }
            case Min: {
                return "ucumacmin";
            }
            case Max: {
                return "ucumacmax";
            }
        }
        return null;
    }

    @Override
    public String getInstructions(int input_index, int output_index) {
        return this.getInstructions(String.valueOf(input_index), String.valueOf(output_index));
    }

    @Override
    public String getInstructions(String input, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }
}

