/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.udf;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysml.udf.FunctionParameter;

public abstract class PackageFunction
implements Serializable {
    private static final long serialVersionUID = 3274150928865462856L;
    private ArrayList<FunctionParameter> _function_inputs = new ArrayList();
    private String _configurationFile;
    private String _baseDir;
    private IDSequence _seq = new IDSequence();

    public final int getNumFunctionInputs() {
        if (this._function_inputs == null) {
            throw new RuntimeException("function inputs null");
        }
        return this._function_inputs.size();
    }

    public final FunctionParameter getFunctionInput(int pos) {
        if (this._function_inputs == null || this._function_inputs.size() <= pos) {
            throw new RuntimeException("function inputs null or size <= pos");
        }
        return this._function_inputs.get(pos);
    }

    public abstract int getNumFunctionOutputs();

    public abstract FunctionParameter getFunctionOutput(int var1);

    public final void setFunctionInputs(ArrayList<FunctionParameter> inputs) {
        this.setNumFunctionInputs(inputs.size());
        for (int i = 0; i < inputs.size(); ++i) {
            this.setInput(inputs.get(i), i);
        }
    }

    public final void setNumFunctionInputs(int numInputs) {
        if (this._function_inputs == null) {
            throw new RuntimeException("function inputs null");
        }
        if (this._function_inputs.size() > numInputs) {
            throw new RuntimeException("function inputs size > numInputs -- cannot reduce size");
        }
        while (this._function_inputs.size() < numInputs) {
            this._function_inputs.add(null);
        }
    }

    public final void setInput(FunctionParameter input, int pos) {
        if (this._function_inputs == null || this._function_inputs.size() <= pos) {
            throw new RuntimeException("function inputs null or size <= pos");
        }
        this._function_inputs.set(pos, input);
    }

    public final void setConfiguration(String fName) {
        this._configurationFile = fName;
    }

    public final String getConfiguration() {
        return this._configurationFile;
    }

    public void setBaseDir(String dir) {
        this._baseDir = dir;
    }

    public String getBaseDir() {
        return this._baseDir;
    }

    public String createOutputFilePathAndName(String fname) {
        return this._baseDir + fname + this._seq.getNextID();
    }

    public abstract void execute();

    public void execute(ExecutionContext ec) {
        this.execute();
    }
}

