/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import org.apache.sysml.lops.runtime.RunMRJobs;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.SPInstructionParser;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.utils.Statistics;

public abstract class SPInstruction
extends Instruction {
    protected final SPType _sptype;
    protected final Operator _optr;
    protected final boolean _requiresLabelUpdate;

    protected SPInstruction(SPType type, String opcode, String istr) {
        this(type, null, opcode, istr);
    }

    protected SPInstruction(SPType type, Operator op, String opcode, String istr) {
        this._sptype = type;
        this._optr = op;
        this.type = Instruction.IType.SPARK;
        this.instString = istr;
        this.instOpcode = opcode;
        this._requiresLabelUpdate = super.requiresLabelUpdate();
    }

    public SPType getSPInstructionType() {
        return this._sptype;
    }

    @Override
    public boolean requiresLabelUpdate() {
        return this._requiresLabelUpdate;
    }

    @Override
    public String getGraphString() {
        return this.getOpcode();
    }

    @Override
    public Instruction preprocessInstruction(ExecutionContext ec) throws DMLRuntimeException {
        Instruction tmp = super.preprocessInstruction(ec);
        if (tmp.requiresLabelUpdate()) {
            String updInst = RunMRJobs.updateLabels(tmp.toString(), ec.getVariables());
            tmp = SPInstructionParser.parseSingleInstruction(updInst);
        }
        return tmp;
    }

    @Override
    public abstract void processInstruction(ExecutionContext var1) throws DMLRuntimeException;

    @Override
    public void postprocessInstruction(ExecutionContext ec) throws DMLRuntimeException {
        Statistics.incrementNoOfExecutedSPInst();
        super.postprocessInstruction(ec);
    }

    public static enum SPType {
        MAPMM,
        MAPMMCHAIN,
        CPMM,
        RMM,
        TSMM,
        TSMM2,
        PMM,
        ZIPMM,
        PMAPMM,
        MatrixIndexing,
        Reorg,
        Binary,
        Ternary,
        AggregateUnary,
        AggregateTernary,
        Reblock,
        CSVReblock,
        Builtin,
        Unary,
        BuiltinNary,
        MultiReturnBuiltin,
        Checkpoint,
        Compression,
        Cast,
        CentralMoment,
        Covariance,
        QSort,
        QPick,
        ParameterizedBuiltin,
        MAppend,
        RAppend,
        GAppend,
        GAlignedAppend,
        Rand,
        MatrixReshape,
        Ctable,
        Quaternary,
        CumsumAggregate,
        CumsumOffset,
        BinUaggChain,
        UaggOuterChain,
        Write,
        SpoofFused,
        Convolution;

    }
}

