/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.rewrite;

import java.util.ArrayList;
import java.util.List;
import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.rewrite.HopRewriteRule;
import org.apache.sysml.hops.rewrite.ProgramRewriteStatus;
import org.apache.sysml.hops.rewrite.RewriteAlgebraicSimplificationDynamic;
import org.apache.sysml.hops.rewrite.RewriteAlgebraicSimplificationStatic;
import org.apache.sysml.hops.rewrite.RewriteBlockSizeAndReblock;
import org.apache.sysml.hops.rewrite.RewriteCommonSubexpressionElimination;
import org.apache.sysml.hops.rewrite.RewriteCompressedReblock;
import org.apache.sysml.hops.rewrite.RewriteConstantFolding;
import org.apache.sysml.hops.rewrite.RewriteElementwiseMultChainOptimization;
import org.apache.sysml.hops.rewrite.RewriteForLoopVectorization;
import org.apache.sysml.hops.rewrite.RewriteIndexingVectorization;
import org.apache.sysml.hops.rewrite.RewriteInjectSparkLoopCheckpointing;
import org.apache.sysml.hops.rewrite.RewriteInjectSparkPReadCheckpointing;
import org.apache.sysml.hops.rewrite.RewriteMarkLoopVariablesUpdateInPlace;
import org.apache.sysml.hops.rewrite.RewriteMatrixMultChainOptimization;
import org.apache.sysml.hops.rewrite.RewriteMergeBlockSequence;
import org.apache.sysml.hops.rewrite.RewriteRemoveEmptyBasicBlocks;
import org.apache.sysml.hops.rewrite.RewriteRemoveReadAfterWrite;
import org.apache.sysml.hops.rewrite.RewriteRemoveUnnecessaryBranches;
import org.apache.sysml.hops.rewrite.RewriteRemoveUnnecessaryCasts;
import org.apache.sysml.hops.rewrite.RewriteSplitDagDataDependentOperators;
import org.apache.sysml.hops.rewrite.RewriteSplitDagUnknownCSVRead;
import org.apache.sysml.hops.rewrite.RewriteTransientWriteParentHandling;
import org.apache.sysml.hops.rewrite.StatementBlockRewriteRule;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.ForStatement;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.parser.FunctionStatement;
import org.apache.sysml.parser.FunctionStatementBlock;
import org.apache.sysml.parser.IfStatement;
import org.apache.sysml.parser.IfStatementBlock;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.ParForStatementBlock;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.WhileStatement;
import org.apache.sysml.parser.WhileStatementBlock;

public class ProgramRewriter {
    private static final boolean LDEBUG = false;
    private static final boolean CHECK = false;
    private ArrayList<HopRewriteRule> _dagRuleSet = new ArrayList();
    private ArrayList<StatementBlockRewriteRule> _sbRuleSet = null;

    public ProgramRewriter() {
        this(true, true);
    }

    public ProgramRewriter(boolean staticRewrites, boolean dynamicRewrites) {
        this._sbRuleSet = new ArrayList();
        if (staticRewrites) {
            this._dagRuleSet.add(new RewriteTransientWriteParentHandling());
            this._dagRuleSet.add(new RewriteRemoveReadAfterWrite());
            this._dagRuleSet.add(new RewriteBlockSizeAndReblock());
            if (OptimizerUtils.ALLOW_ALGEBRAIC_SIMPLIFICATION) {
                this._dagRuleSet.add(new RewriteRemoveUnnecessaryCasts());
            }
            if (OptimizerUtils.ALLOW_COMMON_SUBEXPRESSION_ELIMINATION) {
                this._dagRuleSet.add(new RewriteCommonSubexpressionElimination());
            }
            if (OptimizerUtils.ALLOW_CONSTANT_FOLDING) {
                this._dagRuleSet.add(new RewriteConstantFolding());
            }
            if (OptimizerUtils.ALLOW_ALGEBRAIC_SIMPLIFICATION) {
                this._dagRuleSet.add(new RewriteAlgebraicSimplificationStatic());
            }
            if (OptimizerUtils.ALLOW_COMMON_SUBEXPRESSION_ELIMINATION) {
                this._dagRuleSet.add(new RewriteCommonSubexpressionElimination());
            }
            if (OptimizerUtils.ALLOW_AUTO_VECTORIZATION) {
                this._dagRuleSet.add(new RewriteIndexingVectorization());
            }
            this._dagRuleSet.add(new RewriteInjectSparkPReadCheckpointing());
            if (OptimizerUtils.ALLOW_BRANCH_REMOVAL) {
                this._sbRuleSet.add(new RewriteRemoveUnnecessaryBranches());
                this._sbRuleSet.add(new RewriteMergeBlockSequence());
            }
            this._sbRuleSet.add(new RewriteCompressedReblock());
            if (OptimizerUtils.ALLOW_SPLIT_HOP_DAGS) {
                this._sbRuleSet.add(new RewriteSplitDagUnknownCSVRead());
            }
            if (ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.ALLOW_INDIVIDUAL_SB_SPECIFIC_OPS)) {
                this._sbRuleSet.add(new RewriteSplitDagDataDependentOperators());
            }
            if (OptimizerUtils.ALLOW_AUTO_VECTORIZATION) {
                this._sbRuleSet.add(new RewriteForLoopVectorization());
            }
            this._sbRuleSet.add(new RewriteInjectSparkLoopCheckpointing(true));
            if (OptimizerUtils.ALLOW_LOOP_UPDATE_IN_PLACE) {
                this._sbRuleSet.add(new RewriteMarkLoopVariablesUpdateInPlace());
            }
        }
        if (dynamicRewrites) {
            if (OptimizerUtils.ALLOW_SUM_PRODUCT_REWRITES) {
                this._dagRuleSet.add(new RewriteMatrixMultChainOptimization());
                this._dagRuleSet.add(new RewriteElementwiseMultChainOptimization());
            }
            if (OptimizerUtils.ALLOW_ALGEBRAIC_SIMPLIFICATION) {
                this._dagRuleSet.add(new RewriteAlgebraicSimplificationDynamic());
                this._dagRuleSet.add(new RewriteAlgebraicSimplificationStatic());
            }
        }
        if (OptimizerUtils.ALLOW_ALGEBRAIC_SIMPLIFICATION) {
            this._dagRuleSet.add(new RewriteRemoveUnnecessaryCasts());
        }
        if (OptimizerUtils.ALLOW_COMMON_SUBEXPRESSION_ELIMINATION) {
            this._dagRuleSet.add(new RewriteCommonSubexpressionElimination(true));
        }
        this._sbRuleSet.add(new RewriteRemoveEmptyBasicBlocks());
    }

    public ProgramRewriter(HopRewriteRule ... rewrites) {
        for (HopRewriteRule rewrite : rewrites) {
            this._dagRuleSet.add(rewrite);
        }
        this._sbRuleSet = new ArrayList();
    }

    public ProgramRewriter(StatementBlockRewriteRule ... rewrites) {
        this._sbRuleSet = new ArrayList();
        for (StatementBlockRewriteRule rewrite : rewrites) {
            this._sbRuleSet.add(rewrite);
        }
    }

    public ProgramRewriter(ArrayList<HopRewriteRule> hRewrites, ArrayList<StatementBlockRewriteRule> sbRewrites) {
        this._dagRuleSet.addAll(hRewrites);
        this._sbRuleSet = new ArrayList();
        this._sbRuleSet.addAll(sbRewrites);
    }

    public void removeHopRewrite(Class<? extends HopRewriteRule> clazz) {
        this._dagRuleSet.removeIf(r -> r.getClass().equals(clazz));
    }

    public void removeStatementBlockRewrite(Class<? extends StatementBlockRewriteRule> clazz) {
        this._sbRuleSet.removeIf(r -> r.getClass().equals(clazz));
    }

    public ProgramRewriteStatus rewriteProgramHopDAGs(DMLProgram dmlp) throws LanguageException, HopsException {
        return this.rewriteProgramHopDAGs(dmlp, true);
    }

    public ProgramRewriteStatus rewriteProgramHopDAGs(DMLProgram dmlp, boolean splitDags) throws LanguageException, HopsException {
        ProgramRewriteStatus state = new ProgramRewriteStatus();
        for (String namespaceKey : dmlp.getNamespaces().keySet()) {
            for (String fname : dmlp.getFunctionStatementBlocks(namespaceKey).keySet()) {
                FunctionStatementBlock fsblock = dmlp.getFunctionStatementBlock(namespaceKey, fname);
                this.rRewriteStatementBlockHopDAGs(fsblock, state);
                if (this._sbRuleSet.isEmpty()) continue;
                this.rRewriteStatementBlock(fsblock, state, splitDags);
            }
        }
        for (int i = 0; i < dmlp.getNumStatementBlocks(); ++i) {
            StatementBlock current = dmlp.getStatementBlock(i);
            this.rRewriteStatementBlockHopDAGs(current, state);
        }
        if (!this._sbRuleSet.isEmpty()) {
            dmlp.setStatementBlocks(this.rRewriteStatementBlocks(dmlp.getStatementBlocks(), state, splitDags));
        }
        return state;
    }

    public void rRewriteStatementBlockHopDAGs(StatementBlock current, ProgramRewriteStatus state) throws LanguageException, HopsException {
        if (state == null) {
            state = new ProgramRewriteStatus();
        }
        if (current instanceof FunctionStatementBlock) {
            FunctionStatementBlock fsb = (FunctionStatementBlock)current;
            FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
            for (StatementBlock sb : fstmt.getBody()) {
                this.rRewriteStatementBlockHopDAGs(sb, state);
            }
        } else if (current instanceof WhileStatementBlock) {
            WhileStatementBlock wsb = (WhileStatementBlock)current;
            WhileStatement wstmt = (WhileStatement)wsb.getStatement(0);
            wsb.setPredicateHops(this.rewriteHopDAG(wsb.getPredicateHops(), state));
            for (StatementBlock sb : wstmt.getBody()) {
                this.rRewriteStatementBlockHopDAGs(sb, state);
            }
        } else if (current instanceof IfStatementBlock) {
            IfStatementBlock isb = (IfStatementBlock)current;
            IfStatement istmt = (IfStatement)isb.getStatement(0);
            isb.setPredicateHops(this.rewriteHopDAG(isb.getPredicateHops(), state));
            for (StatementBlock sb : istmt.getIfBody()) {
                this.rRewriteStatementBlockHopDAGs(sb, state);
            }
            for (StatementBlock sb : istmt.getElseBody()) {
                this.rRewriteStatementBlockHopDAGs(sb, state);
            }
        } else if (current instanceof ForStatementBlock) {
            ForStatementBlock fsb = (ForStatementBlock)current;
            ForStatement fstmt = (ForStatement)fsb.getStatement(0);
            fsb.setFromHops(this.rewriteHopDAG(fsb.getFromHops(), state));
            fsb.setToHops(this.rewriteHopDAG(fsb.getToHops(), state));
            fsb.setIncrementHops(this.rewriteHopDAG(fsb.getIncrementHops(), state));
            for (StatementBlock sb : fstmt.getBody()) {
                this.rRewriteStatementBlockHopDAGs(sb, state);
            }
        } else {
            current.setHops(this.rewriteHopDAG(current.getHops(), state));
        }
    }

    public ArrayList<Hop> rewriteHopDAG(ArrayList<Hop> roots, ProgramRewriteStatus state) throws HopsException {
        for (HopRewriteRule r : this._dagRuleSet) {
            Hop.resetVisitStatus(roots);
            roots = r.rewriteHopDAGs(roots, state);
        }
        return roots;
    }

    public Hop rewriteHopDAG(Hop root, ProgramRewriteStatus state) throws HopsException {
        if (root == null) {
            return null;
        }
        for (HopRewriteRule r : this._dagRuleSet) {
            root.resetVisitStatus();
            root = r.rewriteHopDAG(root, state);
        }
        return root;
    }

    public ArrayList<StatementBlock> rRewriteStatementBlocks(ArrayList<StatementBlock> sbs, ProgramRewriteStatus status, boolean splitDags) throws HopsException {
        if (status == null) {
            status = new ProgramRewriteStatus();
        }
        List<StatementBlock> tmp = sbs;
        for (StatementBlockRewriteRule r : this._sbRuleSet) {
            if (!splitDags && r.createsSplitDag()) continue;
            tmp = r.rewriteStatementBlocks(tmp, status);
        }
        List<StatementBlock> tmp2 = new ArrayList<StatementBlock>();
        for (StatementBlock sb : tmp) {
            tmp2.addAll(this.rRewriteStatementBlock(sb, status, splitDags));
        }
        for (StatementBlockRewriteRule r : this._sbRuleSet) {
            if (!splitDags && r.createsSplitDag()) continue;
            tmp2 = r.rewriteStatementBlocks(tmp2, status);
        }
        sbs.clear();
        sbs.addAll(tmp2);
        return sbs;
    }

    public ArrayList<StatementBlock> rRewriteStatementBlock(StatementBlock sb, ProgramRewriteStatus status, boolean splitDags) throws HopsException {
        ArrayList<StatementBlock> ret = new ArrayList<StatementBlock>();
        ret.add(sb);
        if (sb instanceof FunctionStatementBlock) {
            FunctionStatementBlock fsb = (FunctionStatementBlock)sb;
            FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
            fstmt.setBody(this.rRewriteStatementBlocks(fstmt.getBody(), status, splitDags));
        } else if (sb instanceof WhileStatementBlock) {
            WhileStatementBlock wsb = (WhileStatementBlock)sb;
            WhileStatement wstmt = (WhileStatement)wsb.getStatement(0);
            wstmt.setBody(this.rRewriteStatementBlocks(wstmt.getBody(), status, splitDags));
        } else if (sb instanceof IfStatementBlock) {
            IfStatementBlock isb = (IfStatementBlock)sb;
            IfStatement istmt = (IfStatement)isb.getStatement(0);
            istmt.setIfBody(this.rRewriteStatementBlocks(istmt.getIfBody(), status, splitDags));
            istmt.setElseBody(this.rRewriteStatementBlocks(istmt.getElseBody(), status, splitDags));
        } else if (sb instanceof ForStatementBlock) {
            boolean prestatus = status.isInParforContext();
            if (sb instanceof ParForStatementBlock) {
                status.setInParforContext(true);
            }
            ForStatementBlock fsb = (ForStatementBlock)sb;
            ForStatement fstmt = (ForStatement)fsb.getStatement(0);
            fstmt.setBody(this.rRewriteStatementBlocks(fstmt.getBody(), status, splitDags));
            status.setInParforContext(prestatus);
        }
        for (StatementBlockRewriteRule r : this._sbRuleSet) {
            if (!splitDags && r.createsSplitDag()) continue;
            ArrayList<StatementBlock> tmp = new ArrayList<StatementBlock>();
            for (StatementBlock sbc : ret) {
                tmp.addAll(r.rewriteStatementBlock(sbc, status));
            }
            ret.clear();
            ret.addAll(tmp);
        }
        return ret;
    }
}

