/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.utils;

import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.runtime.controlprogram.caching.CacheStatistics;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.MRJobInstruction;
import org.apache.sysml.runtime.instructions.cp.FunctionCallCPInstruction;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.matrix.data.LibMatrixDNN;
import org.apache.sysml.utils.GPUStatistics;
import org.apache.sysml.utils.NativeHelper;

public class Statistics {
    private static long compileStartTime = 0L;
    private static long compileEndTime = 0L;
    private static long execStartTime = 0L;
    private static long execEndTime = 0L;
    private static final LongAdder numExecutedMRJobs = new LongAdder();
    private static final LongAdder numCompiledMRJobs = new LongAdder();
    private static final LongAdder numExecutedSPInst = new LongAdder();
    private static final LongAdder numCompiledSPInst = new LongAdder();
    private static long jitCompileTime = 0L;
    private static long jvmGCTime = 0L;
    private static long jvmGCCount = 0L;
    private static final LongAdder hopRecompileTime = new LongAdder();
    private static final LongAdder hopRecompilePred = new LongAdder();
    private static final LongAdder hopRecompileSB = new LongAdder();
    private static final LongAdder codegenCompileTime = new LongAdder();
    private static final LongAdder codegenClassCompileTime = new LongAdder();
    private static final LongAdder codegenHopCompile = new LongAdder();
    private static final LongAdder codegenCPlanCompile = new LongAdder();
    private static final LongAdder codegenClassCompile = new LongAdder();
    private static final LongAdder codegenEnumAll = new LongAdder();
    private static final LongAdder codegenEnumEval = new LongAdder();
    private static final LongAdder codegenEnumEvalP = new LongAdder();
    private static final LongAdder codegenPlanCacheHits = new LongAdder();
    private static final LongAdder codegenPlanCacheTotal = new LongAdder();
    private static final LongAdder funRecompileTime = new LongAdder();
    private static final LongAdder funRecompiles = new LongAdder();
    private static long sparkCtxCreateTime = 0L;
    private static final LongAdder sparkParallelize = new LongAdder();
    private static final LongAdder sparkParallelizeCount = new LongAdder();
    private static final LongAdder sparkCollect = new LongAdder();
    private static final LongAdder sparkCollectCount = new LongAdder();
    private static final LongAdder sparkBroadcast = new LongAdder();
    private static final LongAdder sparkBroadcastCount = new LongAdder();
    private static long parforOptTime = 0L;
    private static long parforOptCount = 0L;
    private static long parforInitTime = 0L;
    private static long parforMergeTime = 0L;
    private static HashMap<String, Long> _cpInstTime = new HashMap();
    private static HashMap<String, Long> _cpInstCounts = new HashMap();
    private static final LongAdder lTotalUIPVar = new LongAdder();
    private static final LongAdder lTotalLix = new LongAdder();
    private static final LongAdder lTotalLixUIP = new LongAdder();
    private static LongAdder numNativeFailures = new LongAdder();
    public static LongAdder numNativeLibMatrixMultCalls = new LongAdder();
    public static LongAdder numNativeConv2dCalls = new LongAdder();
    public static LongAdder numNativeConv2dBwdDataCalls = new LongAdder();
    public static LongAdder numNativeConv2dBwdFilterCalls = new LongAdder();
    public static LongAdder numNativeSparseConv2dCalls = new LongAdder();
    public static LongAdder numNativeSparseConv2dBwdFilterCalls = new LongAdder();
    public static LongAdder numNativeSparseConv2dBwdDataCalls = new LongAdder();
    public static long nativeLibMatrixMultTime = 0L;
    public static long nativeConv2dTime = 0L;
    public static long nativeConv2dBwdDataTime = 0L;
    public static long nativeConv2dBwdFilterTime = 0L;
    public static long recomputeNNZTime = 0L;
    public static long examSparsityTime = 0L;
    public static long allocateDoubleArrTime = 0L;

    public static synchronized long getNoOfExecutedMRJobs() {
        return numExecutedMRJobs.longValue();
    }

    public static void incrementNativeFailuresCounter() {
        numNativeFailures.increment();
        throw new RuntimeException("Unexpected ERROR: OOM caused during JNI transfer. Please disable native BLAS by setting enviroment variable: SYSTEMML_BLAS=none");
    }

    public static void incrementNoOfExecutedMRJobs() {
        numExecutedMRJobs.increment();
    }

    public static void decrementNoOfExecutedMRJobs() {
        numExecutedMRJobs.decrement();
    }

    public static long getNoOfCompiledMRJobs() {
        return numCompiledMRJobs.longValue();
    }

    public static void incrementNoOfCompiledMRJobs() {
        numCompiledMRJobs.increment();
    }

    public static long getNoOfExecutedSPInst() {
        return numExecutedSPInst.longValue();
    }

    public static void incrementNoOfExecutedSPInst() {
        numExecutedSPInst.increment();
    }

    public static void decrementNoOfExecutedSPInst() {
        numExecutedSPInst.decrement();
    }

    public static long getNoOfCompiledSPInst() {
        return numCompiledSPInst.longValue();
    }

    public static void incrementNoOfCompiledSPInst() {
        numCompiledSPInst.increment();
    }

    public static long getTotalUIPVar() {
        return lTotalUIPVar.longValue();
    }

    public static void incrementTotalUIPVar() {
        lTotalUIPVar.increment();
    }

    public static long getTotalLixUIP() {
        return lTotalLixUIP.longValue();
    }

    public static void incrementTotalLixUIP() {
        lTotalLixUIP.increment();
    }

    public static long getTotalLix() {
        return lTotalLix.longValue();
    }

    public static void incrementTotalLix() {
        lTotalLix.increment();
    }

    public static void resetNoOfCompiledJobs(int count) {
        numCompiledSPInst.reset();
        numCompiledMRJobs.reset();
        if (OptimizerUtils.isSparkExecutionMode()) {
            numCompiledSPInst.add(count);
        } else {
            numCompiledMRJobs.add(count);
        }
    }

    public static void resetNoOfExecutedJobs() {
        numExecutedSPInst.reset();
        numExecutedMRJobs.reset();
        if (DMLScript.USE_ACCELERATOR) {
            GPUStatistics.setNoOfExecutedGPUInst(0);
        }
    }

    public static synchronized void incrementJITCompileTime(long time) {
        jitCompileTime += time;
    }

    public static synchronized void incrementJVMgcTime(long time) {
        jvmGCTime += time;
    }

    public static synchronized void incrementJVMgcCount(long delta) {
        jvmGCCount += delta;
    }

    public static void incrementHOPRecompileTime(long delta) {
        hopRecompileTime.add(delta);
    }

    public static void incrementHOPRecompilePred() {
        hopRecompilePred.increment();
    }

    public static void incrementHOPRecompilePred(long delta) {
        hopRecompilePred.add(delta);
    }

    public static void incrementHOPRecompileSB() {
        hopRecompileSB.increment();
    }

    public static void incrementHOPRecompileSB(long delta) {
        hopRecompileSB.add(delta);
    }

    public static void incrementCodegenDAGCompile() {
        codegenHopCompile.increment();
    }

    public static void incrementCodegenCPlanCompile(long delta) {
        codegenCPlanCompile.add(delta);
    }

    public static void incrementCodegenEnumAll(long delta) {
        codegenEnumAll.add(delta);
    }

    public static void incrementCodegenEnumEval(long delta) {
        codegenEnumEval.add(delta);
    }

    public static void incrementCodegenEnumEvalP(long delta) {
        codegenEnumEvalP.add(delta);
    }

    public static void incrementCodegenClassCompile() {
        codegenClassCompile.increment();
    }

    public static void incrementCodegenCompileTime(long delta) {
        codegenCompileTime.add(delta);
    }

    public static void incrementCodegenClassCompileTime(long delta) {
        codegenClassCompileTime.add(delta);
    }

    public static void incrementCodegenPlanCacheHits() {
        codegenPlanCacheHits.increment();
    }

    public static void incrementCodegenPlanCacheTotal() {
        codegenPlanCacheTotal.increment();
    }

    public static long getCodegenDAGCompile() {
        return codegenHopCompile.longValue();
    }

    public static long getCodegenCPlanCompile() {
        return codegenCPlanCompile.longValue();
    }

    public static long getCodegenEnumAll() {
        return codegenEnumAll.longValue();
    }

    public static long getCodegenEnumEval() {
        return codegenEnumEval.longValue();
    }

    public static long getCodegenEnumEvalP() {
        return codegenEnumEvalP.longValue();
    }

    public static long getCodegenClassCompile() {
        return codegenClassCompile.longValue();
    }

    public static long getCodegenCompileTime() {
        return codegenCompileTime.longValue();
    }

    public static long getCodegenClassCompileTime() {
        return codegenClassCompileTime.longValue();
    }

    public static long getCodegenPlanCacheHits() {
        return codegenPlanCacheHits.longValue();
    }

    public static long getCodegenPlanCacheTotal() {
        return codegenPlanCacheTotal.longValue();
    }

    public static void incrementFunRecompileTime(long delta) {
        funRecompileTime.add(delta);
    }

    public static void incrementFunRecompiles() {
        funRecompiles.increment();
    }

    public static synchronized void incrementParForOptimCount() {
        ++parforOptCount;
    }

    public static synchronized void incrementParForOptimTime(long time) {
        parforOptTime += time;
    }

    public static synchronized void incrementParForInitTime(long time) {
        parforInitTime += time;
    }

    public static synchronized void incrementParForMergeTime(long time) {
        parforMergeTime += time;
    }

    public static void startCompileTimer() {
        if (DMLScript.STATISTICS) {
            compileStartTime = System.nanoTime();
        }
    }

    public static void stopCompileTimer() {
        if (DMLScript.STATISTICS) {
            compileEndTime = System.nanoTime();
        }
    }

    public static long getCompileTime() {
        return compileEndTime - compileStartTime;
    }

    public static void startRunTimer() {
        execStartTime = System.nanoTime();
    }

    public static void stopRunTimer() {
        execEndTime = System.nanoTime();
    }

    public static long getRunTime() {
        return execEndTime - execStartTime;
    }

    public static void reset() {
        hopRecompileTime.reset();
        hopRecompilePred.reset();
        hopRecompileSB.reset();
        funRecompiles.reset();
        funRecompileTime.reset();
        codegenHopCompile.reset();
        codegenCPlanCompile.reset();
        codegenClassCompile.reset();
        codegenEnumAll.reset();
        codegenEnumEval.reset();
        codegenEnumEvalP.reset();
        codegenCompileTime.reset();
        codegenClassCompileTime.reset();
        parforOptCount = 0L;
        parforOptTime = 0L;
        parforInitTime = 0L;
        parforMergeTime = 0L;
        lTotalLix.reset();
        lTotalLixUIP.reset();
        lTotalUIPVar.reset();
        Statistics.resetJITCompileTime();
        Statistics.resetJVMgcTime();
        Statistics.resetJVMgcCount();
        Statistics.resetCPHeavyHitters();
        GPUStatistics.reset();
        numNativeLibMatrixMultCalls.reset();
        numNativeSparseConv2dCalls.reset();
        numNativeSparseConv2dBwdDataCalls.reset();
        numNativeSparseConv2dBwdFilterCalls.reset();
        numNativeConv2dCalls.reset();
        numNativeConv2dBwdDataCalls.reset();
        numNativeConv2dBwdFilterCalls.reset();
        numNativeFailures.reset();
        nativeLibMatrixMultTime = 0L;
        nativeConv2dTime = 0L;
        nativeConv2dBwdFilterTime = 0L;
        nativeConv2dBwdDataTime = 0L;
        LibMatrixDNN.resetStatistics();
    }

    public static void resetJITCompileTime() {
        jitCompileTime = -1L * Statistics.getJITCompileTime();
    }

    public static void resetJVMgcTime() {
        jvmGCTime = -1L * Statistics.getJVMgcTime();
    }

    public static void resetJVMgcCount() {
        jvmGCTime = -1L * Statistics.getJVMgcCount();
    }

    public static void resetCPHeavyHitters() {
        _cpInstTime.clear();
        _cpInstCounts.clear();
    }

    public static void setSparkCtxCreateTime(long ns) {
        sparkCtxCreateTime = ns;
    }

    public static void accSparkParallelizeTime(long t) {
        sparkParallelize.add(t);
    }

    public static void incSparkParallelizeCount(long c) {
        sparkParallelizeCount.add(c);
    }

    public static void accSparkCollectTime(long t) {
        sparkCollect.add(t);
    }

    public static void incSparkCollectCount(long c) {
        sparkCollectCount.add(c);
    }

    public static void accSparkBroadCastTime(long t) {
        sparkBroadcast.add(t);
    }

    public static void incSparkBroadcastCount(long c) {
        sparkBroadcastCount.add(c);
    }

    public static String getCPHeavyHitterCode(Instruction inst) {
        String opcode = null;
        if (inst instanceof MRJobInstruction) {
            MRJobInstruction mrinst = (MRJobInstruction)inst;
            opcode = "MR-Job_" + (Object)((Object)mrinst.getJobType());
        } else if (inst instanceof SPInstruction) {
            opcode = "SP_" + InstructionUtils.getOpCode(inst.toString());
            if (inst instanceof FunctionCallCPInstruction) {
                FunctionCallCPInstruction extfunct = (FunctionCallCPInstruction)inst;
                opcode = extfunct.getFunctionName();
            }
        } else {
            opcode = InstructionUtils.getOpCode(inst.toString());
            if (inst instanceof FunctionCallCPInstruction) {
                FunctionCallCPInstruction extfunct = (FunctionCallCPInstruction)inst;
                opcode = extfunct.getFunctionName();
            }
        }
        return opcode;
    }

    public static synchronized void maintainCPHeavyHitters(String instructionName, long timeNanos) {
        Long oldVal = _cpInstTime.getOrDefault(instructionName, 0L);
        _cpInstTime.put(instructionName, oldVal + timeNanos);
        Long oldCnt = _cpInstCounts.getOrDefault(instructionName, 0L);
        _cpInstCounts.put(instructionName, oldCnt + 1L);
    }

    public static Set<String> getCPHeavyHitterOpCodes() {
        return _cpInstTime.keySet();
    }

    public static long getCPHeavyHitterCount(String opcode) {
        return _cpInstCounts.get(opcode);
    }

    public static String getHeavyHitters(int num) {
        String timeSString;
        double timeS;
        Long timeNs;
        int i;
        int len = _cpInstTime.size();
        if (num <= 0 || len <= 0) {
            return "-";
        }
        Map.Entry[] tmp = _cpInstTime.entrySet().toArray(new Map.Entry[len]);
        Arrays.sort(tmp, new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> e1, Map.Entry<String, Long> e2) {
                return e1.getValue().compareTo(e2.getValue());
            }
        });
        String numCol = "#";
        String instCol = "Instruction";
        String timeSCol = "Time(s)";
        String countCol = "Count";
        String gpuCol = "Misc Timers";
        StringBuilder sb = new StringBuilder();
        int numHittersToDisplay = Math.min(num, len);
        int maxNumLen = String.valueOf(numHittersToDisplay).length();
        int maxInstLen = "Instruction".length();
        int maxTimeSLen = "Time(s)".length();
        int maxCountLen = "Count".length();
        DecimalFormat sFormat = new DecimalFormat("#,##0.000");
        for (i = 0; i < numHittersToDisplay; ++i) {
            Map.Entry hh = tmp[len - 1 - i];
            String instruction = (String)hh.getKey();
            timeNs = (Long)hh.getValue();
            timeS = (double)timeNs.longValue() / 1.0E9;
            maxInstLen = Math.max(maxInstLen, instruction.length());
            timeSString = sFormat.format(timeS);
            maxTimeSLen = Math.max(maxTimeSLen, timeSString.length());
            maxCountLen = Math.max(maxCountLen, String.valueOf(_cpInstCounts.get(instruction)).length());
        }
        maxInstLen = Math.min(maxInstLen, DMLScript.STATISTICS_MAX_WRAP_LEN);
        sb.append(String.format(" %" + maxNumLen + "s  %-" + maxInstLen + "s  %" + maxTimeSLen + "s  %" + maxCountLen + "s", "#", "Instruction", "Time(s)", "Count"));
        if (GPUStatistics.DISPLAY_STATISTICS || DMLScript.FINEGRAINED_STATISTICS) {
            sb.append("  ");
            sb.append("Misc Timers");
        }
        sb.append("\n");
        for (i = 0; i < numHittersToDisplay; ++i) {
            String instruction = (String)tmp[len - 1 - i].getKey();
            String[] wrappedInstruction = Statistics.wrap(instruction, maxInstLen);
            timeNs = (Long)tmp[len - 1 - i].getValue();
            timeS = (double)timeNs.longValue() / 1.0E9;
            timeSString = sFormat.format(timeS);
            Long count = _cpInstCounts.get(instruction);
            int numLines = wrappedInstruction.length;
            String[] miscTimers = null;
            if (GPUStatistics.DISPLAY_STATISTICS || DMLScript.FINEGRAINED_STATISTICS) {
                miscTimers = Statistics.wrap(GPUStatistics.getStringForCPMiscTimesPerInstruction(instruction), DMLScript.STATISTICS_MAX_WRAP_LEN);
                numLines = Math.max(numLines, miscTimers.length);
            }
            String miscFormatString = GPUStatistics.DISPLAY_STATISTICS || DMLScript.FINEGRAINED_STATISTICS ? " %" + DMLScript.STATISTICS_MAX_WRAP_LEN + "s" : "%s";
            for (int wrapIter = 0; wrapIter < numLines; ++wrapIter) {
                String miscTimerStr;
                String instStr = wrapIter < wrappedInstruction.length ? wrappedInstruction[wrapIter] : "";
                String string = miscTimerStr = (GPUStatistics.DISPLAY_STATISTICS || DMLScript.FINEGRAINED_STATISTICS) && wrapIter < miscTimers.length ? miscTimers[wrapIter] : "";
                if (wrapIter == 0) {
                    sb.append(String.format(" %" + maxNumLen + "d  %-" + maxInstLen + "s  %" + maxTimeSLen + "s  %" + maxCountLen + "d" + miscFormatString, i + 1, instStr, timeSString, count, miscTimerStr));
                } else {
                    sb.append(String.format(" %" + maxNumLen + "s  %-" + maxInstLen + "s  %" + maxTimeSLen + "s  %" + maxCountLen + "s" + miscFormatString, "", instStr, "", "", miscTimerStr));
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static long getJITCompileTime() {
        long ret = -1L;
        CompilationMXBean cmx = ManagementFactory.getCompilationMXBean();
        if (cmx.isCompilationTimeMonitoringSupported()) {
            ret = cmx.getTotalCompilationTime();
            ret += jitCompileTime;
        }
        return ret;
    }

    public static long getJVMgcTime() {
        long ret = 0L;
        List<GarbageCollectorMXBean> gcxs = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcx : gcxs) {
            ret += gcx.getCollectionTime();
        }
        if (ret > 0L) {
            ret += jvmGCTime;
        }
        return ret;
    }

    public static long getJVMgcCount() {
        long ret = 0L;
        List<GarbageCollectorMXBean> gcxs = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcx : gcxs) {
            ret += gcx.getCollectionCount();
        }
        if (ret > 0L) {
            ret += jvmGCCount;
        }
        return ret;
    }

    public static long getHopRecompileTime() {
        return hopRecompileTime.longValue();
    }

    public static long getHopRecompiledPredDAGs() {
        return hopRecompilePred.longValue();
    }

    public static long getHopRecompiledSBDAGs() {
        return hopRecompileSB.longValue();
    }

    public static long getFunRecompileTime() {
        return funRecompileTime.longValue();
    }

    public static long getFunRecompiles() {
        return funRecompiles.longValue();
    }

    public static long getParforOptCount() {
        return parforOptCount;
    }

    public static long getParforOptTime() {
        return parforOptTime;
    }

    public static long getParforInitTime() {
        return parforInitTime;
    }

    public static long getParforMergeTime() {
        return parforMergeTime;
    }

    public static String display() {
        return Statistics.display(DMLScript.STATISTICS_COUNT);
    }

    private static String[] wrap(String str, int wrapLength) {
        int numLines = (int)Math.ceil((double)str.length() / (double)wrapLength);
        int len = str.length();
        String[] ret = new String[numLines];
        for (int i = 0; i < numLines; ++i) {
            ret[i] = str.substring(i * wrapLength, Math.min((i + 1) * wrapLength, len));
        }
        return ret;
    }

    public static String display(int maxHeavyHitters) {
        StringBuilder sb = new StringBuilder();
        sb.append("SystemML Statistics:\n");
        if (DMLScript.STATISTICS) {
            sb.append("Total elapsed time:\t\t" + String.format("%.3f", (double)(Statistics.getCompileTime() + Statistics.getRunTime()) * 1.0E-9) + " sec.\n");
            sb.append("Total compilation time:\t\t" + String.format("%.3f", (double)Statistics.getCompileTime() * 1.0E-9) + " sec.\n");
        }
        sb.append("Total execution time:\t\t" + String.format("%.3f", (double)Statistics.getRunTime() * 1.0E-9) + " sec.\n");
        if (OptimizerUtils.isSparkExecutionMode()) {
            if (DMLScript.STATISTICS) {
                sb.append("Number of compiled Spark inst:\t" + Statistics.getNoOfCompiledSPInst() + ".\n");
            }
            sb.append("Number of executed Spark inst:\t" + Statistics.getNoOfExecutedSPInst() + ".\n");
        } else {
            if (DMLScript.STATISTICS) {
                sb.append("Number of compiled MR Jobs:\t" + Statistics.getNoOfCompiledMRJobs() + ".\n");
            }
            sb.append("Number of executed MR Jobs:\t" + Statistics.getNoOfExecutedMRJobs() + ".\n");
        }
        if (DMLScript.USE_ACCELERATOR && DMLScript.STATISTICS) {
            sb.append(GPUStatistics.getStringForCudaTimers());
        }
        if (DMLScript.STATISTICS) {
            if (NativeHelper.blasType != null) {
                String blas = NativeHelper.blasType != null ? NativeHelper.blasType : "";
                sb.append("Native " + blas + " calls (dense mult/conv/bwdF/bwdD):\t" + numNativeLibMatrixMultCalls.longValue() + "/" + numNativeConv2dCalls.longValue() + "/" + numNativeConv2dBwdFilterCalls.longValue() + "/" + numNativeConv2dBwdDataCalls.longValue() + ".\n");
                sb.append("Native " + blas + " calls (sparse conv/bwdF/bwdD):\t" + numNativeSparseConv2dCalls.longValue() + "/" + numNativeSparseConv2dBwdFilterCalls.longValue() + "/" + numNativeSparseConv2dBwdDataCalls.longValue() + ".\n");
                sb.append("Native " + blas + " times (dense mult/conv/bwdF/bwdD):\t" + String.format("%.3f", (double)nativeLibMatrixMultTime * 1.0E-9) + "/" + String.format("%.3f", (double)nativeConv2dTime * 1.0E-9) + "/" + String.format("%.3f", (double)nativeConv2dBwdFilterTime * 1.0E-9) + "/" + String.format("%.3f", (double)nativeConv2dBwdDataTime * 1.0E-9) + ".\n");
            }
            if (recomputeNNZTime != 0L || examSparsityTime != 0L || allocateDoubleArrTime != 0L) {
                sb.append("MatrixBlock times (recomputeNNZ/examSparsity/allocateDoubleArr):\t" + String.format("%.3f", (double)recomputeNNZTime * 1.0E-9) + "/" + String.format("%.3f", (double)examSparsityTime * 1.0E-9) + "/" + String.format("%.3f", (double)allocateDoubleArrTime * 1.0E-9) + ".\n");
            }
            sb.append("Cache hits (Mem, WB, FS, HDFS):\t" + CacheStatistics.displayHits() + ".\n");
            sb.append("Cache writes (WB, FS, HDFS):\t" + CacheStatistics.displayWrites() + ".\n");
            sb.append("Cache times (ACQr/m, RLS, EXP):\t" + CacheStatistics.displayTime() + " sec.\n");
            sb.append("HOP DAGs recompiled (PRED, SB):\t" + Statistics.getHopRecompiledPredDAGs() + "/" + Statistics.getHopRecompiledSBDAGs() + ".\n");
            sb.append("HOP DAGs recompile time:\t" + String.format("%.3f", (double)Statistics.getHopRecompileTime() / 1.0E9) + " sec.\n");
            if (Statistics.getFunRecompiles() > 0L) {
                sb.append("Functions recompiled:\t\t" + Statistics.getFunRecompiles() + ".\n");
                sb.append("Functions recompile time:\t" + String.format("%.3f", (double)Statistics.getFunRecompileTime() / 1.0E9) + " sec.\n");
            }
            if (ConfigurationManager.isCodegenEnabled()) {
                sb.append("Codegen compile (DAG,CP,JC):\t" + Statistics.getCodegenDAGCompile() + "/" + Statistics.getCodegenCPlanCompile() + "/" + Statistics.getCodegenClassCompile() + ".\n");
                sb.append("Codegen enum (All,Eval,EvalP):\t" + Statistics.getCodegenEnumAll() + "/" + Statistics.getCodegenEnumEval() + "/" + Statistics.getCodegenEnumEvalP() + ".\n");
                sb.append("Codegen compile times (DAG,JC):\t" + String.format("%.3f", (double)Statistics.getCodegenCompileTime() / 1.0E9) + "/" + String.format("%.3f", (double)Statistics.getCodegenClassCompileTime() / 1.0E9) + " sec.\n");
                sb.append("Codegen plan cache hits:\t" + Statistics.getCodegenPlanCacheHits() + "/" + Statistics.getCodegenPlanCacheTotal() + ".\n");
            }
            if (OptimizerUtils.isSparkExecutionMode()) {
                String lazy = SparkExecutionContext.isLazySparkContextCreation() ? "(lazy)" : "(eager)";
                sb.append("Spark ctx create time " + lazy + ":\t" + String.format("%.3f", (double)sparkCtxCreateTime * 1.0E-9) + " sec.\n");
                sb.append("Spark trans counts (par,bc,col):" + String.format("%d/%d/%d.\n", sparkParallelizeCount.longValue(), sparkBroadcastCount.longValue(), sparkCollectCount.longValue()));
                sb.append("Spark trans times (par,bc,col):\t" + String.format("%.3f/%.3f/%.3f secs.\n", (double)sparkParallelize.longValue() * 1.0E-9, (double)sparkBroadcast.longValue() * 1.0E-9, (double)sparkCollect.longValue() * 1.0E-9));
            }
            if (parforOptCount > 0L) {
                sb.append("ParFor loops optimized:\t\t" + Statistics.getParforOptCount() + ".\n");
                sb.append("ParFor optimize time:\t\t" + String.format("%.3f", (double)Statistics.getParforOptTime() / 1000.0) + " sec.\n");
                sb.append("ParFor initialize time:\t\t" + String.format("%.3f", (double)Statistics.getParforInitTime() / 1000.0) + " sec.\n");
                sb.append("ParFor result merge time:\t" + String.format("%.3f", (double)Statistics.getParforMergeTime() / 1000.0) + " sec.\n");
                sb.append("ParFor total update in-place:\t" + lTotalUIPVar + "/" + lTotalLixUIP + "/" + lTotalLix + "\n");
            }
            sb.append("Total JIT compile time:\t\t" + (double)Statistics.getJITCompileTime() / 1000.0 + " sec.\n");
            sb.append("Total JVM GC count:\t\t" + Statistics.getJVMgcCount() + ".\n");
            sb.append("Total JVM GC time:\t\t" + (double)Statistics.getJVMgcTime() / 1000.0 + " sec.\n");
            LibMatrixDNN.appendStatistics(sb);
            sb.append("Heavy hitter instructions:\n" + Statistics.getHeavyHitters(maxHeavyHitters));
        }
        return sb.toString();
    }
}

