/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.udf.lib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.CacheException;
import org.apache.sysml.runtime.matrix.data.IJV;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.udf.FunctionParameter;
import org.apache.sysml.udf.Matrix;
import org.apache.sysml.udf.PackageFunction;

public class RowClassMeet
extends PackageFunction {
    private static final long serialVersionUID = 1L;
    private Matrix CMat;
    private Matrix NMat;
    private MatrixBlock A;
    private MatrixBlock B;
    private MatrixBlock C;
    private MatrixBlock N;
    private int nr;
    private int nc;

    @Override
    public int getNumFunctionOutputs() {
        return 2;
    }

    @Override
    public FunctionParameter getFunctionOutput(int pos) {
        if (pos == 0) {
            return this.CMat;
        }
        if (pos == 1) {
            return this.NMat;
        }
        throw new RuntimeException("RowClassMeet produces only one output");
    }

    double[] getRow(MatrixBlock B, double[] bRow, int i) {
        if (B.getNumRows() == 1) {
            i = 0;
        }
        Arrays.fill(bRow, 0.0);
        if (B.isInSparseFormat()) {
            Iterator<IJV> iter = B.getSparseBlockIterator(i, i + 1);
            while (iter.hasNext()) {
                IJV ijv = iter.next();
                bRow[ijv.getJ()] = ijv.getV();
            }
        } else {
            double[] denseBlk = B.getDenseBlock();
            if (denseBlk != null) {
                System.arraycopy(denseBlk, i * B.getNumColumns(), bRow, 0, B.getNumColumns());
            }
        }
        return bRow;
    }

    @Override
    public void execute() {
        try {
            this.A = (MatrixBlock)((Matrix)this.getFunctionInput(0)).getMatrixObject().acquireRead();
            this.B = (MatrixBlock)((Matrix)this.getFunctionInput(1)).getMatrixObject().acquireRead();
            this.nr = Math.max(this.A.getNumRows(), this.B.getNumRows());
            this.nc = Math.max(this.A.getNumColumns(), this.B.getNumColumns());
            double[] bRow = new double[this.B.getNumColumns()];
            this.CMat = new Matrix(this.createOutputFilePathAndName("TMP"), this.nr, this.nc, Matrix.ValueType.Double);
            this.C = new MatrixBlock(this.nr, this.nc, false);
            this.C.allocateDenseBlock();
            this.NMat = new Matrix(this.createOutputFilePathAndName("TMP"), this.nr, this.nc, Matrix.ValueType.Double);
            this.N = new MatrixBlock(this.nr, this.nc, false);
            this.N.allocateDenseBlock();
            double[] cBlk = this.C.getDenseBlock();
            double[] nBlk = this.N.getDenseBlock();
            if (this.B.getNumRows() == 1) {
                this.getRow(this.B, bRow, 0);
            }
            for (int i = 0; i < this.A.getNumRows(); ++i) {
                ClassLabels key;
                double aVal;
                if (this.B.getNumRows() != 1) {
                    this.getRow(this.B, bRow, i);
                }
                TreeMap classLabelMapping = new TreeMap(new ClassLabelComparator());
                if (this.A.isInSparseFormat()) {
                    Iterator<IJV> iter = this.A.getSparseBlockIterator(i, i + 1);
                    while (iter.hasNext()) {
                        IJV ijv = iter.next();
                        int j = ijv.getJ();
                        aVal = ijv.getV();
                        if (aVal == 0.0 || bRow[j] == 0.0) continue;
                        key = new ClassLabels(aVal, bRow[j]);
                        if (!classLabelMapping.containsKey(key)) {
                            classLabelMapping.put(key, new ArrayList());
                        }
                        ((ArrayList)classLabelMapping.get(key)).add(j);
                    }
                } else {
                    double[] denseBlk = this.A.getDenseBlock();
                    if (denseBlk != null) {
                        int offset = i * this.A.getNumColumns();
                        for (int j = 0; j < this.A.getNumColumns(); ++j) {
                            aVal = denseBlk[offset + j];
                            if (aVal == 0.0 || bRow[j] == 0.0) continue;
                            key = new ClassLabels(aVal, bRow[j]);
                            if (!classLabelMapping.containsKey(key)) {
                                classLabelMapping.put(key, new ArrayList());
                            }
                            ((ArrayList)classLabelMapping.get(key)).add(j);
                        }
                    }
                }
                int labelID = 1;
                for (Map.Entry entry : classLabelMapping.entrySet()) {
                    double nVal = ((ArrayList)entry.getValue()).size();
                    for (Integer j : (ArrayList)entry.getValue()) {
                        nBlk[i * this.nc + j.intValue()] = nVal;
                        cBlk[i * this.nc + j.intValue()] = labelID;
                    }
                    ++labelID;
                }
            }
            ((Matrix)this.getFunctionInput(0)).getMatrixObject().release();
            ((Matrix)this.getFunctionInput(1)).getMatrixObject().release();
        }
        catch (CacheException e) {
            throw new RuntimeException("Error while executing RowClassMeet", e);
        }
        try {
            this.C.recomputeNonZeros();
            this.C.examSparsity();
            this.CMat.setMatrixDoubleArray(this.C, OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo);
            this.N.recomputeNonZeros();
            this.N.examSparsity();
            this.NMat.setMatrixDoubleArray(this.N, OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo);
        }
        catch (DMLRuntimeException e) {
            throw new RuntimeException("Error while executing RowClassMeet", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while executing RowClassMeet", e);
        }
    }

    public class ClassLabelComparator
    implements Comparator<ClassLabels> {
        Integer tmp1;
        Integer tmp2;

        @Override
        public int compare(ClassLabels o1, ClassLabels o2) {
            if (o1.aVal != o2.aVal) {
                this.tmp1 = (int)o1.aVal;
                this.tmp2 = (int)o2.aVal;
            } else {
                this.tmp1 = (int)o1.bVal;
                this.tmp2 = (int)o2.bVal;
            }
            return this.tmp1.compareTo(this.tmp2);
        }
    }

    public class ClassLabels {
        public double aVal;
        public double bVal;

        public ClassLabels(double aVal, double bVal) {
            this.aVal = aVal;
            this.bVal = bVal;
        }
    }
}

