/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.layers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;

public class Tanh
extends Script {
    public Tanh() {
        String string = "scripts/nn/layers/tanh.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Matrix forward(Object object) {
        String string = "source('scripts/nn/layers/tanh.dml') as mlcontextns;out = mlcontextns::forward(X);";
        Script script = new Script(string);
        script.in("X", object).out("out");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("out");
        return matrix;
    }

    public String forward__docs() {
        String string = "forward = function(matrix[double] X)\n    return (matrix[double] out) {\n  /*\n   * Computes the forward pass for a tanh nonlinearity layer.\n   *\n   *   ```\n   *   tanh(x) = (e^x - e^-x) / (e^x + e^-x)\n   *           = 2 * sigmoid(2x) - 1\n   *   ```\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (any, any).\n   *\n   * Outputs:\n   *  - out: Outputs, of same shape as `X`.\n   */\n";
        return string;
    }

    public String forward__source() {
        String string = "forward = function(matrix[double] X)\n    return (matrix[double] out) {\n  /*\n   * Computes the forward pass for a tanh nonlinearity layer.\n   *\n   *   ```\n   *   tanh(x) = (e^x - e^-x) / (e^x + e^-x)\n   *           = 2 * sigmoid(2x) - 1\n   *   ```\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (any, any).\n   *\n   * Outputs:\n   *  - out: Outputs, of same shape as `X`.\n   */\n  # out = (exp(X) - exp(-X)) / (exp(X) + exp(-X))\n  # Simplification of the above formulation to use the sigmoid function:\n  sigma2X = sigmoid::forward(2*X)\n  out = 2*sigma2X - 1\n}\n";
        return string;
    }

    public Matrix backward(Object object, Object object2) {
        String string = "source('scripts/nn/layers/tanh.dml') as mlcontextns;dX = mlcontextns::backward(dout, X);";
        Script script = new Script(string);
        script.in("dout", object).in("X", object2).out("dX");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("dX");
        return matrix;
    }

    public String backward__docs() {
        String string = "backward = function(matrix[double] dout, matrix[double] X)\n    return (matrix[double] dX) {\n  /*\n   * Computes the backward pass for a tanh nonlinearity layer.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of same shape as `X`.\n   *  - X: Inputs, of shape (any, any).\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of same shape as `X`.\n   */\n";
        return string;
    }

    public String backward__source() {
        String string = "backward = function(matrix[double] dout, matrix[double] X)\n    return (matrix[double] dX) {\n  /*\n   * Computes the backward pass for a tanh nonlinearity layer.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of same shape as `X`.\n   *  - X: Inputs, of shape (any, any).\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of same shape as `X`.\n   */\n  sigma2X = sigmoid::forward(2*X)\n  out = 2*sigma2X - 1\n  dX = (1-out^2) * dout\n}\n";
        return string;
    }
}

