/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.operators;

import org.apache.sysml.lops.WeightedCrossEntropy;
import org.apache.sysml.lops.WeightedDivMM;
import org.apache.sysml.lops.WeightedSigmoid;
import org.apache.sysml.lops.WeightedSquaredLoss;
import org.apache.sysml.lops.WeightedUnaryMM;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.functionobjects.Multiply2;
import org.apache.sysml.runtime.functionobjects.Power2;
import org.apache.sysml.runtime.functionobjects.ValueFunction;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class QuaternaryOperator
extends Operator {
    private static final long serialVersionUID = -1642908613016116069L;
    public WeightedSquaredLoss.WeightsType wtype1 = null;
    public WeightedSigmoid.WSigmoidType wtype2 = null;
    public WeightedDivMM.WDivMMType wtype3 = null;
    public WeightedCrossEntropy.WCeMMType wtype4 = null;
    public WeightedUnaryMM.WUMMType wtype5 = null;
    public ValueFunction fn;
    private double eps = 0.0;

    public QuaternaryOperator(WeightedSquaredLoss.WeightsType wt) {
        this.wtype1 = wt;
    }

    public QuaternaryOperator(WeightedSigmoid.WSigmoidType wt) {
        this.wtype2 = wt;
        this.fn = Builtin.getBuiltinFnObject("sigmoid");
    }

    public QuaternaryOperator(WeightedDivMM.WDivMMType wt) {
        this.wtype3 = wt;
    }

    public QuaternaryOperator(WeightedDivMM.WDivMMType wt, double epsilon) {
        this.wtype3 = wt;
        this.eps = epsilon;
    }

    public QuaternaryOperator(WeightedCrossEntropy.WCeMMType wt) {
        this.wtype4 = wt;
    }

    public QuaternaryOperator(WeightedCrossEntropy.WCeMMType wt, double epsilon) {
        this.wtype4 = wt;
        this.eps = epsilon;
    }

    public QuaternaryOperator(WeightedUnaryMM.WUMMType wt, String op) {
        this.wtype5 = wt;
        this.fn = op.equals("^2") ? Power2.getPower2FnObject() : (op.equals("*2") ? Multiply2.getMultiply2FnObject() : Builtin.getBuiltinFnObject(op));
    }

    public boolean hasFourInputs() {
        return this.wtype1 != null && this.wtype1.hasFourInputs() || this.wtype3 != null && this.wtype3.hasFourInputs() || this.wtype4 != null && this.wtype4.hasFourInputs();
    }

    public double getScalar() {
        return this.eps;
    }
}

