/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.util.Arrays;
import org.apache.sysml.runtime.matrix.data.ConvolutionParameters;
import org.apache.sysml.runtime.matrix.data.LibMatrixDNNHelper;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;

public class LibMatrixDNNRotate180Helper {

    static class SparseRotate180Worker
    implements Rotate180Worker {
        double[] outputArray;
        MatrixBlock input;
        ConvolutionParameters params;
        boolean zeroOutSparseOutput;

        public SparseRotate180Worker(MatrixBlock input, double[] outputArray, ConvolutionParameters params, boolean zeroOutSparseOutput) {
            this.outputArray = outputArray;
            this.params = params;
            this.zeroOutSparseOutput = zeroOutSparseOutput;
            this.input = input;
            if (outputArray == null) {
                throw new RuntimeException("Incorrect usage: empty inputs");
            }
        }

        @Override
        public void execute(int inputN, int outputN) {
            if (this.zeroOutSparseOutput) {
                Arrays.fill(this.outputArray, 0.0);
            }
            int outputOffset = outputN * this.params.K * this.params.P * this.params.Q;
            if (!this.input.isEmptyBlock() && !this.input.sparseBlock.isEmpty(inputN)) {
                int[] tensorIndexes = new int[3];
                int apos = this.input.sparseBlock.pos(inputN);
                int alen = this.input.sparseBlock.size(inputN);
                int[] aix = this.input.sparseBlock.indexes(inputN);
                double[] avals = this.input.sparseBlock.values(inputN);
                for (int j = apos; j < apos + alen; ++j) {
                    LibMatrixDNNHelper.computeTensorIndexes(aix[j], tensorIndexes, this.params.P, this.params.Q);
                    int k = tensorIndexes[0];
                    int p = tensorIndexes[1];
                    int q = tensorIndexes[2];
                    this.outputArray[outputOffset + p * this.params.Q * this.params.K + q * this.params.K + k] = avals[j];
                }
            }
        }
    }

    static class DenseRotate180Worker
    implements Rotate180Worker {
        double[] inputArray;
        double[] outputArray;
        ConvolutionParameters params;

        public DenseRotate180Worker(MatrixBlock input, double[] outputArray, ConvolutionParameters params) {
            this.outputArray = outputArray;
            this.params = params;
            this.inputArray = input.getDenseBlock();
            if (this.inputArray == null || outputArray == null) {
                throw new RuntimeException("Incorrect usage: empty inputs");
            }
        }

        @Override
        public void execute(int inputN, int outputN) {
            int outputOffset = outputN * this.params.K * this.params.P * this.params.Q;
            for (int k = 0; k < this.params.K; ++k) {
                for (int p = 0; p < this.params.P; ++p) {
                    for (int q = 0; q < this.params.Q; ++q) {
                        this.outputArray[outputOffset + p * this.params.Q * this.params.K + q * this.params.K + k] = this.inputArray[inputN * this.params.K * this.params.P * this.params.Q + k * this.params.P * this.params.Q + p * this.params.Q + q];
                    }
                }
            }
        }
    }

    static interface Rotate180Worker {
        public void execute(int var1, int var2);

        public static Rotate180Worker getWorker(MatrixBlock input, double[] outputArray, ConvolutionParameters params, boolean zeroOutSparseOutput) {
            if (!input.isInSparseFormat()) {
                return new DenseRotate180Worker(input, outputArray, params);
            }
            return new SparseRotate180Worker(input, outputArray, params, zeroOutSparseOutput);
        }
    }
}

