/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.runtime.matrix.data.ConvolutionParameters;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;

public class LibMatrixDNNIm2ColHelper {
    private static final Log LOG = LogFactory.getLog((String)LibMatrixDNNIm2ColHelper.class.getName());

    private static void appendInputValueToIm2colOutput(MatrixBlock output, int cInput, int hInput, int wInput, double value, int R, int S, int P, int Q, int stride_h, int stride_w, int pad_h, int pad_w) {
        if (value == 0.0) {
            return;
        }
        int RS = R * S;
        int rMax = Math.min(R - 1, hInput + pad_h);
        int sMin = Math.max(0, wInput + pad_w - Q * stride_w + 1);
        int sMax = Math.min(S - 1, wInput + pad_w);
        for (int rMin = Math.max(0, hInput + pad_h - P * stride_h + 1); (hInput - rMin + pad_h) % stride_h != 0 && rMin <= rMax; ++rMin) {
        }
        while ((wInput - sMin + pad_w) % stride_w != 0 && sMin <= sMax) {
            ++sMin;
        }
        for (int r = rMin; r <= rMax; r += stride_h) {
            int p = (hInput - r + pad_h) / stride_h;
            int pQ = p * Q;
            int outRowIndex = cInput * RS + r * S;
            for (int s = sMin; s <= sMax; s += stride_w) {
                int q = (wInput - s + pad_w) / stride_w;
                output.appendValue(outRowIndex + s, pQ + q, value);
            }
        }
    }

    static class SparseSparseIm2colWorker
    implements Im2colWorker {
        MatrixBlock input;
        MatrixBlock output;
        int CRS;
        int S;
        int R;
        int P;
        int Q;
        int H;
        int W;
        int HW;
        int RS;
        int stride_h;
        int stride_w;
        int pad_h;
        int pad_w;

        public SparseSparseIm2colWorker(MatrixBlock input, MatrixBlock im2ColOutBlock, ConvolutionParameters params) {
            this.input = input;
            this.output = im2ColOutBlock;
            this.CRS = params.C * params.R * params.S;
            this.HW = params.H * params.W;
            this.RS = params.R * params.S;
            this.H = params.H;
            this.W = params.W;
            this.R = params.R;
            this.S = params.S;
            this.P = params.P;
            this.Q = params.Q;
            this.stride_h = params.stride_h;
            this.stride_w = params.stride_w;
            this.pad_h = params.pad_h;
            this.pad_w = params.pad_w;
        }

        @Override
        public void execute(int n) {
            throw new RuntimeException("Not supported");
        }

        @Override
        public void execute(int n, int cInput) {
            if (!this.input.sparseBlock.isEmpty(n)) {
                this.output.sparseBlock.reset();
                this.output.setNonZeros(0L);
                int apos = this.input.sparseBlock.pos(n);
                int alen = this.input.sparseBlock.size(n);
                int[] aix = this.input.sparseBlock.indexes(n);
                double[] avals = this.input.sparseBlock.values(n);
                for (int j = apos; j < apos + alen; ++j) {
                    int chw = aix[j];
                    if (cInput != chw / this.HW) continue;
                    int hInput = (chw - cInput * this.HW) / this.W;
                    int wInput = chw % this.W;
                    LibMatrixDNNIm2ColHelper.appendInputValueToIm2colOutput(this.output, cInput, hInput, wInput, avals[j], this.R, this.S, this.P, this.Q, this.stride_h, this.stride_w, this.pad_h, this.pad_w);
                }
            } else {
                this.output.setNonZeros(0L);
            }
        }
    }

    static class SparseSparseIm2colWorkerAllChannels
    implements Im2colWorker {
        MatrixBlock input;
        MatrixBlock output;
        int CRS;
        int S;
        int R;
        int P;
        int Q;
        int H;
        int W;
        int RS;
        int HW;
        int stride_h;
        int stride_w;
        int pad_h;
        int pad_w;

        public SparseSparseIm2colWorkerAllChannels(MatrixBlock input, MatrixBlock im2ColOutBlock, ConvolutionParameters params) {
            this.input = input;
            this.output = im2ColOutBlock;
            this.CRS = params.C * params.R * params.S;
            this.RS = params.R * params.S;
            this.HW = params.H * params.W;
            this.H = params.H;
            this.W = params.W;
            this.R = params.R;
            this.S = params.S;
            this.P = params.P;
            this.Q = params.Q;
            this.stride_h = params.stride_h;
            this.stride_w = params.stride_w;
            this.pad_h = params.pad_h;
            this.pad_w = params.pad_w;
            if (!input.isInSparseFormat()) {
                throw new RuntimeException("Incorrect operator selection. Expected dense input for SparseIm2colWorkerAllChannels");
            }
        }

        @Override
        public void execute(int n, int c) {
            throw new RuntimeException("Not supported");
        }

        @Override
        public void execute(int n) {
            if (!this.input.sparseBlock.isEmpty(n)) {
                this.output.sparseBlock.reset();
                this.output.setNonZeros(0L);
                int apos = this.input.sparseBlock.pos(n);
                int alen = this.input.sparseBlock.size(n);
                int[] aix = this.input.sparseBlock.indexes(n);
                double[] avals = this.input.sparseBlock.values(n);
                for (int j = apos; j < apos + alen; ++j) {
                    int chw = aix[j];
                    int cInput = chw / this.HW;
                    int hInput = (chw - cInput * this.HW) / this.W;
                    int wInput = chw % this.W;
                    LibMatrixDNNIm2ColHelper.appendInputValueToIm2colOutput(this.output, cInput, hInput, wInput, avals[j], this.R, this.S, this.P, this.Q, this.stride_h, this.stride_w, this.pad_h, this.pad_w);
                }
            } else {
                this.output.setNonZeros(0L);
            }
        }
    }

    static class DenseIm2colWorkerAllChannels
    implements Im2colWorker {
        double[] inputArray;
        double[] outputArray;
        int CRS;
        int S;
        int R;
        int P;
        int Q;
        int CHW;
        int H;
        int W;
        int stride_h;
        int stride_w;
        int pad_h;
        int pad_w;

        public DenseIm2colWorkerAllChannels(double[] inputArray, double[] outputArray, ConvolutionParameters params) {
            this.inputArray = inputArray;
            this.outputArray = outputArray;
            this.CRS = params.C * params.R * params.S;
            this.H = params.H;
            this.W = params.W;
            this.R = params.R;
            this.S = params.S;
            this.P = params.P;
            this.Q = params.Q;
            this.CHW = params.C * params.H * params.W;
            this.stride_h = params.stride_h;
            this.stride_w = params.stride_w;
            this.pad_h = params.pad_h;
            this.pad_w = params.pad_w;
        }

        @Override
        public void execute(int n, int c) {
            throw new RuntimeException("Not supported");
        }

        @Override
        public void execute(int n) {
            int nOffset = n * this.CHW;
            for (int c = 0; c < this.CRS; ++c) {
                int wOffset = c % this.S;
                int hOffset = c / this.S % this.R;
                int cInput = c / this.R / this.S;
                for (int h = 0; h < this.P; ++h) {
                    int outOffset = (c * this.P + h) * this.Q;
                    int hPadded = h * this.stride_h - this.pad_h + hOffset;
                    int inputOffset = nOffset + (cInput * this.H + hPadded) * this.W;
                    if (hPadded < 0 || hPadded >= this.H) {
                        Arrays.fill(this.outputArray, outOffset, outOffset + this.Q, 0.0);
                        continue;
                    }
                    for (int w = 0; w < this.Q; ++w) {
                        int wPadded = w * this.stride_w - this.pad_w + wOffset;
                        this.outputArray[outOffset + w] = wPadded >= 0 && wPadded < this.W ? this.inputArray[inputOffset + wPadded] : 0.0;
                    }
                }
            }
        }
    }

    static class DenseIm2colWorker
    implements Im2colWorker {
        double[] inputArray;
        double[] outputArray;
        int CRS;
        int S;
        int R;
        int P;
        int Q;
        int CHW;
        int H;
        int W;
        int stride_h;
        int stride_w;
        int pad_h;
        int pad_w;

        public DenseIm2colWorker(double[] inputArray, double[] outputArray, ConvolutionParameters params) {
            this.inputArray = inputArray;
            this.outputArray = outputArray;
            this.CRS = params.C * params.R * params.S;
            this.H = params.H;
            this.W = params.W;
            this.R = params.R;
            this.S = params.S;
            this.P = params.P;
            this.Q = params.Q;
            this.CHW = params.C * params.H * params.W;
            this.stride_h = params.stride_h;
            this.stride_w = params.stride_w;
            this.pad_h = params.pad_h;
            this.pad_w = params.pad_w;
        }

        @Override
        public void execute(int n) {
            throw new RuntimeException("Not supported");
        }

        @Override
        public void execute(int n, int cInput) {
            int nOffset = n * this.CHW;
            int RS = this.R * this.S;
            for (int rs = 0; rs < RS; ++rs) {
                int wOffset = rs % this.S;
                int hOffset = rs / this.S;
                for (int h = 0; h < this.P; ++h) {
                    int outOffset = (rs * this.P + h) * this.Q;
                    int hPadded = h * this.stride_h - this.pad_h + hOffset;
                    int inputOffset = nOffset + (cInput * this.H + hPadded) * this.W;
                    if (hPadded < 0 || hPadded >= this.H) {
                        Arrays.fill(this.outputArray, outOffset, outOffset + this.Q, 0.0);
                        continue;
                    }
                    for (int w = 0; w < this.Q; ++w) {
                        int wPadded = w * this.stride_w - this.pad_w + wOffset;
                        this.outputArray[outOffset + w] = wPadded >= 0 && wPadded < this.W ? this.inputArray[inputOffset + wPadded] : 0.0;
                    }
                }
            }
        }
    }

    static class DenseIm2colWorkerStride1Pad0AllChannels
    implements Im2colWorker {
        double[] inputArray;
        double[] outputArray;
        int CRS;
        int S;
        int R;
        int P;
        int Q;
        int CHW;
        int H;
        int W;

        public DenseIm2colWorkerStride1Pad0AllChannels(double[] inputArray, double[] outputArray, ConvolutionParameters params) {
            this.inputArray = inputArray;
            this.outputArray = outputArray;
            this.CRS = params.C * params.R * params.S;
            this.H = params.H;
            this.W = params.W;
            this.R = params.R;
            this.S = params.S;
            this.P = params.P;
            this.Q = params.Q;
            this.CHW = params.C * params.H * params.W;
        }

        @Override
        public void execute(int n, int c) {
            throw new RuntimeException("Not supported");
        }

        @Override
        public void execute(int n) {
            int nOffset = n * this.CHW;
            for (int c = 0; c < this.CRS; ++c) {
                int wOffset = c % this.S;
                int hOffset = c / this.S % this.R;
                int cInput = c / this.R / this.S;
                for (int h = 0; h < this.P; ++h) {
                    int hPadded = h + hOffset;
                    int outOffset = (c * this.P + h) * this.Q;
                    int inputOffset = nOffset + (cInput * this.H + hPadded) * this.W;
                    System.arraycopy(this.inputArray, inputOffset + wOffset, this.outputArray, outOffset, this.Q);
                    int w = this.Q - 1;
                    int wPadded = w + wOffset;
                    this.outputArray[outOffset + w] = hPadded < this.H && wPadded < this.W ? this.inputArray[inputOffset + wPadded] : 0.0;
                }
            }
        }
    }

    static class DenseIm2colWorkerStride1Pad0
    implements Im2colWorker {
        double[] inputArray;
        double[] outputArray;
        int CRS;
        int S;
        int R;
        int P;
        int Q;
        int CHW;
        int H;
        int W;

        public DenseIm2colWorkerStride1Pad0(double[] inputArray, double[] outputArray, ConvolutionParameters params) {
            this.inputArray = inputArray;
            this.outputArray = outputArray;
            this.CRS = params.C * params.R * params.S;
            this.H = params.H;
            this.W = params.W;
            this.R = params.R;
            this.S = params.S;
            this.P = params.P;
            this.Q = params.Q;
            this.CHW = params.C * params.H * params.W;
        }

        @Override
        public void execute(int n) {
            throw new RuntimeException("Not supported");
        }

        @Override
        public void execute(int n, int cInput) {
            int nOffset = n * this.CHW;
            int RS = this.R * this.S;
            for (int rs = 0; rs < RS; ++rs) {
                int wOffset = rs % this.S;
                int hOffset = rs / this.S;
                for (int h = 0; h < this.P; ++h) {
                    int hPadded = h + hOffset;
                    int outOffset = (rs * this.P + h) * this.Q;
                    int inputOffset = nOffset + (cInput * this.H + hPadded) * this.W;
                    System.arraycopy(this.inputArray, inputOffset + wOffset, this.outputArray, outOffset, this.Q);
                    int w = this.Q - 1;
                    int wPadded = w + wOffset;
                    this.outputArray[outOffset + w] = hPadded < this.H && wPadded < this.W ? this.inputArray[inputOffset + wPadded] : 0.0;
                }
            }
        }
    }

    static interface Im2colWorker {
        public void execute(int var1);

        public void execute(int var1, int var2);

        public static Im2colWorker getWorker(MatrixBlock input, MatrixBlock im2ColOutBlock, ConvolutionParameters params, boolean allChannels) {
            if (allChannels) {
                if (!input.isInSparseFormat()) {
                    im2ColOutBlock.allocateDenseBlock();
                    if (params.stride_h == 1 && params.stride_w == 1 && params.pad_h == 0 && params.pad_w == 0) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)"Using DenseIm2colWorkerStride1Pad0AllChannels operator to perform im2col.");
                        }
                        return new DenseIm2colWorkerStride1Pad0AllChannels(input.getDenseBlock(), im2ColOutBlock.getDenseBlock(), params);
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)"Using DenseIm2colWorkerAllChannels operator to perform im2col.");
                    }
                    return new DenseIm2colWorkerAllChannels(input.getDenseBlock(), im2ColOutBlock.getDenseBlock(), params);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"Using SparseIm2colWorkerAllChannels operator to perform im2col.");
                }
                double sparsity = Math.min(0.4, (double)input.getNonZeros() * 2.0 / (double)(input.getNumRows() * input.getNumColumns()));
                Im2colWorker.initializeSparseIm2ColBlock(im2ColOutBlock, (long)Math.ceil((double)(params.P * params.Q) * sparsity));
                return new SparseSparseIm2colWorkerAllChannels(input, im2ColOutBlock, params);
            }
            if (!input.isInSparseFormat()) {
                im2ColOutBlock.allocateDenseBlock();
                if (params.stride_h == 1 && params.stride_w == 1 && params.pad_h == 0 && params.pad_w == 0) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)"Using DenseIm2colWorkerStride1Pad0 operator to perform im2col.");
                    }
                    return new DenseIm2colWorkerStride1Pad0(input.getDenseBlock(), im2ColOutBlock.getDenseBlock(), params);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"Using DenseIm2colWorker operator to perform im2col.");
                }
                return new DenseIm2colWorker(input.getDenseBlock(), im2ColOutBlock.getDenseBlock(), params);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Using SparseIm2colWorker operator to perform im2col.");
            }
            double sparsity = Math.min(0.4, (double)input.getNonZeros() * 2.0 / (double)(input.getNumRows() * input.getNumColumns()));
            Im2colWorker.initializeSparseIm2ColBlock(im2ColOutBlock, (long)Math.ceil((double)(params.P * params.Q) * sparsity));
            return new SparseSparseIm2colWorker(input, im2ColOutBlock, params);
        }

        public static void initializeSparseIm2ColBlock(MatrixBlock im2ColOutBlock, long worstCaseNNPerRow) {
            if (worstCaseNNPerRow >= Integer.MAX_VALUE) {
                throw new RuntimeException("The dimension of intermediate im2col matrix exceeded:" + worstCaseNNPerRow);
            }
            im2ColOutBlock.sparse = true;
            im2ColOutBlock.denseBlock = null;
            im2ColOutBlock.allocateSparseRowsBlock();
            for (int r = 0; r < im2ColOutBlock.getNumRows(); ++r) {
                im2ColOutBlock.getSparseBlock().allocate(r, (int)worstCaseNNPerRow);
            }
            im2ColOutBlock.setNonZeros(0L);
        }
    }
}

