/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.lops.SortKeys;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.MRJobInstruction;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryInstruction;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.JobReturn;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.matrix.sort.CompactInputFormat;
import org.apache.sysml.runtime.matrix.sort.CompactOutputFormat;
import org.apache.sysml.runtime.matrix.sort.IndexSortComparable;
import org.apache.sysml.runtime.matrix.sort.IndexSortComparableDesc;
import org.apache.sysml.runtime.matrix.sort.IndexSortMapper;
import org.apache.sysml.runtime.matrix.sort.IndexSortReducer;
import org.apache.sysml.runtime.matrix.sort.IndexSortStitchupMapper;
import org.apache.sysml.runtime.matrix.sort.IndexSortStitchupReducer;
import org.apache.sysml.runtime.matrix.sort.SamplingSortMRInputFormat;
import org.apache.sysml.runtime.matrix.sort.ValueSortMapper;
import org.apache.sysml.runtime.matrix.sort.ValueSortReducer;
import org.apache.sysml.runtime.util.MapReduceTool;

public class SortMR {
    private static final Log LOG = LogFactory.getLog((String)SortMR.class.getName());
    public static final String NUM_VALUES_PREFIX = "num.values.in";
    public static final String COMBINE_INSTRUCTION = "combine.instruction";
    public static final String SORT_INSTRUCTION = "sort.instruction";
    public static final String VALUE_IS_WEIGHT = "value.is.weight";
    public static final String SORT_INDEXES_OFFSETS = "sort.indexes.offsets";
    public static final String SORT_DECREASING = "sort.decreasing";

    private SortMR() {
    }

    public static JobReturn runJob(MRJobInstruction inst, String input, InputInfo inputInfo, long rlen, long clen, int brlen, int bclen, String combineInst, String sortInst, int numReducers, int replication, String output, OutputInfo outputInfo, boolean valueIsWeight) throws Exception {
        boolean sortIndexes = SortMR.getSortInstructionType(sortInst) == SortKeys.OperationTypes.Indexes;
        String tmpOutput = sortIndexes ? MRJobConfiguration.constructTempOutputFilename() : output;
        JobConf job = new JobConf(SortMR.class);
        job.setJobName("SortMR");
        String pfname = MRJobConfiguration.setUpSortPartitionFilename(job);
        Path partitionFile = new Path(pfname);
        URI partitionUri = new URI(partitionFile.toString());
        Path inputDir = new Path(input);
        inputDir = inputDir.makeQualified(inputDir.getFileSystem((Configuration)job));
        SamplingSortMRInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{inputDir});
        Path outpath = new Path(tmpOutput);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outpath);
        MapReduceTool.deleteFileIfExistOnHDFS(outpath, job);
        if (!InfrastructureAnalyzer.isLocalMode(job)) {
            MRJobConfiguration.setNumReducers(job, numReducers, numReducers);
            if (SortMR.getSortInstructionType(sortInst) != SortKeys.OperationTypes.Indexes) {
                job.setNumReduceTasks((int)Math.max((long)job.getNumReduceTasks(), rlen / 10000000L));
            }
        } else {
            job.setNumReduceTasks(1);
        }
        job.setInputFormat(SamplingSortMRInputFormat.class);
        SamplingSortMRInputFormat.setTargetKeyValueClasses(job, outputInfo.outputKeyClass, outputInfo.outputValueClass);
        if (combineInst != null && !combineInst.trim().isEmpty()) {
            job.set(COMBINE_INSTRUCTION, combineInst);
        }
        job.set(SORT_INSTRUCTION, sortInst);
        job.setBoolean(VALUE_IS_WEIGHT, valueIsWeight);
        boolean desc = SortMR.getSortInstructionDescending(sortInst);
        job.setBoolean(SORT_DECREASING, desc);
        MRJobConfiguration.setBlockSize(job, (byte)0, brlen, bclen);
        MRJobConfiguration.setInputInfo(job, (byte)0, inputInfo, brlen, bclen, MRJobConfiguration.ConvertTarget.CELL);
        int partitionWith0 = SamplingSortMRInputFormat.writePartitionFile(job, partitionFile);
        if (SortMR.getSortInstructionType(sortInst) == SortKeys.OperationTypes.Indexes) {
            MRJobConfiguration.setInputInfo(job, (byte)0, inputInfo, brlen, bclen, MRJobConfiguration.ConvertTarget.CELL);
            job.setOutputFormat(OutputInfo.BinaryBlockOutputInfo.outputFormatClass);
            job.setMapperClass(IndexSortMapper.class);
            job.setReducerClass(IndexSortReducer.class);
            job.setMapOutputKeyClass(!desc ? IndexSortComparable.class : IndexSortComparableDesc.class);
            job.setMapOutputValueClass(LongWritable.class);
            job.setOutputKeyClass(MatrixIndexes.class);
            job.setOutputValueClass(MatrixBlock.class);
        } else {
            MRJobConfiguration.setInputInfo(job, (byte)0, inputInfo, brlen, bclen, MRJobConfiguration.ConvertTarget.CELL);
            job.setOutputFormat(CompactOutputFormat.class);
            job.setMapperClass(ValueSortMapper.class);
            job.setReducerClass(ValueSortReducer.class);
            job.setOutputKeyClass(outputInfo.outputKeyClass);
            job.setOutputValueClass(outputInfo.outputValueClass);
        }
        job.setPartitionerClass(TotalOrderPartitioner.class);
        DistributedCache.addCacheFile((URI)partitionUri, (Configuration)job);
        DistributedCache.createSymlink((Configuration)job);
        job.setInt("dfs.replication", replication);
        DMLConfig config = ConfigurationManager.getDMLConfig();
        MRJobConfiguration.setupCustomMRConfigurations(job, config);
        MatrixCharacteristics[] s = new MatrixCharacteristics[]{new MatrixCharacteristics(rlen, clen, brlen, bclen)};
        if (LOG.isTraceEnabled()) {
            inst.printCompleteMRJobInstruction(s);
        }
        MRJobConfiguration.setUniqueWorkingDir(job);
        RunningJob runjob = JobClient.runJob((JobConf)job);
        Counters.Group group = runjob.getCounters().getGroup(NUM_VALUES_PREFIX);
        numReducers = job.getNumReduceTasks();
        long[] counts = new long[numReducers];
        long total = 0L;
        for (int i = 0; i < numReducers; ++i) {
            counts[i] = group.getCounter(Integer.toString(i));
            total += counts[i];
        }
        long missing0s = 0L;
        if (total < rlen * clen) {
            if (partitionWith0 < 0) {
                throw new RuntimeException("no partition contains 0, which is wrong!");
            }
            missing0s = rlen * clen - total;
            int n = partitionWith0;
            counts[n] = counts[n] + missing0s;
        } else {
            partitionWith0 = -1;
        }
        if (sortIndexes) {
            boolean success = runjob.isSuccessful();
            if (success) {
                success = SortMR.runStitchupJob(tmpOutput, rlen, clen, brlen, bclen, counts, numReducers, replication, output);
            }
            MapReduceTool.deleteFileIfExistOnHDFS(tmpOutput);
            MapReduceTool.deleteFileIfExistOnHDFS(pfname);
            return new JobReturn(s[0], OutputInfo.BinaryBlockOutputInfo, success);
        }
        MapReduceTool.deleteFileIfExistOnHDFS(pfname);
        return new JobReturn(s[0], counts, partitionWith0, missing0s, runjob.isSuccessful());
    }

    public static MRInstruction parseSortInstruction(String str) throws DMLRuntimeException {
        SortKeys.OperationTypes otype = SortMR.getSortInstructionType(str);
        if (otype != SortKeys.OperationTypes.Indexes) {
            return UnaryInstruction.parseInstruction(str);
        }
        InstructionUtils.checkNumFields(str, 4);
        String[] sparts = InstructionUtils.getInstructionParts(str);
        byte in = Byte.parseByte(sparts[1]);
        byte out = Byte.parseByte(sparts[2]);
        return new UnaryInstruction(null, in, out, str);
    }

    private static SortKeys.OperationTypes getSortInstructionType(String str) {
        String[] parts = str.split("\u00b0");
        return SortKeys.OperationTypes.valueOf(parts[parts.length - 2]);
    }

    private static boolean getSortInstructionDescending(String str) {
        String[] parts = str.split("\u00b0");
        return Boolean.parseBoolean(parts[5]);
    }

    private static boolean runStitchupJob(String input, long rlen, long clen, int brlen, int bclen, long[] counts, int numReducers, int replication, String output) throws Exception {
        JobConf job = new JobConf(SortMR.class);
        job.setJobName("SortIndexesMR");
        Path inpath = new Path(input);
        Path outpath = new Path(output);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{inpath});
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outpath);
        MapReduceTool.deleteFileIfExistOnHDFS(outpath, job);
        if (InfrastructureAnalyzer.isLocalMode(job)) {
            job.setNumReduceTasks(1);
        } else {
            MRJobConfiguration.setNumReducers(job, numReducers, numReducers);
        }
        InputInfo iinfo = InputInfo.BinaryBlockInputInfo;
        OutputInfo oinfo = OutputInfo.BinaryBlockOutputInfo;
        job.setInputFormat(iinfo.inputFormatClass);
        job.setOutputFormat(oinfo.outputFormatClass);
        CompactInputFormat.setKeyValueClasses(job, MatrixIndexes.class, MatrixBlock.class);
        MRJobConfiguration.setInputInfo(job, (byte)0, InputInfo.BinaryBlockInputInfo, brlen, bclen, MRJobConfiguration.ConvertTarget.BLOCK);
        job.setMapperClass(IndexSortStitchupMapper.class);
        job.setReducerClass(IndexSortStitchupReducer.class);
        job.setOutputKeyClass(oinfo.outputKeyClass);
        job.setOutputValueClass(oinfo.outputValueClass);
        MRJobConfiguration.setBlockSize(job, (byte)0, brlen, bclen);
        MRJobConfiguration.setMatricesDimensions(job, new byte[]{0}, new long[]{rlen}, new long[]{clen});
        long[] cumsumCounts = new long[counts.length];
        long sum = 0L;
        for (int i = 0; i < counts.length; ++i) {
            cumsumCounts[i] = sum;
            sum += counts[i];
        }
        job.set(SORT_INDEXES_OFFSETS, Arrays.toString(cumsumCounts));
        job.setInt("dfs.replication", replication);
        MRJobConfiguration.setUniqueWorkingDir(job);
        RunningJob runJob = JobClient.runJob((JobConf)job);
        return runJob.isSuccessful();
    }

    private static class TotalOrderPartitioner<K extends WritableComparable, V extends Writable>
    implements Partitioner<K, V> {
        private ArrayList<WritableComparable> splitPoints;

        private TotalOrderPartitioner() {
        }

        private ArrayList<WritableComparable> readPartitions(FileSystem fs, Path p, JobConf job) throws IOException {
            ArrayList<WritableComparable> parts = new ArrayList<WritableComparable>();
            SequenceFile.Reader reader = null;
            try {
                reader = new SequenceFile.Reader(fs, p, (Configuration)job);
                DoubleWritable key = new DoubleWritable();
                NullWritable value = NullWritable.get();
                while (reader.next((Writable)key, (Writable)value)) {
                    parts.add((WritableComparable)key);
                    key = new DoubleWritable();
                }
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtilFunctions.closeSilently(reader);
                    throw throwable;
                }
            }
            IOUtilFunctions.closeSilently((Closeable)reader);
            return parts;
        }

        public void configure(JobConf job) {
            try {
                Path partFile = new Path(MRJobConfiguration.getSortPartitionFilename(job));
                FileSystem fs = IOUtilFunctions.getFileSystem(partFile, (Configuration)job);
                this.splitPoints = this.readPartitions(fs, partFile, job);
            }
            catch (IOException ie) {
                throw new IllegalArgumentException("can't read paritions file", ie);
            }
        }

        public int getPartition(K key, V value, int numPartitions) {
            return this.findPartition(key) % numPartitions;
        }

        private int findPartition(K key) {
            int i;
            for (i = 0; i < this.splitPoints.size(); ++i) {
                if (key.compareTo((Object)this.splitPoints.get(i)) > 0) continue;
                return i;
            }
            return i;
        }
    }
}

