/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.MRInstructionParser;
import org.apache.sysml.runtime.instructions.MRJobInstruction;
import org.apache.sysml.runtime.instructions.mr.IDistributedCacheConsumer;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.PickByCountInstruction;
import org.apache.sysml.runtime.matrix.JobReturn;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.NumItemsByEachReducerMetaData;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixBlock;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixPackedCell;
import org.apache.sysml.runtime.matrix.mapred.GMRCombiner;
import org.apache.sysml.runtime.matrix.mapred.GMRMapper;
import org.apache.sysml.runtime.matrix.mapred.GMRReducer;
import org.apache.sysml.runtime.matrix.mapred.MRBaseForCommonInstructions;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.matrix.sort.PickFromCompactInputFormat;
import org.apache.sysml.runtime.util.MapReduceTool;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.sysml.yarn.DMLAppMasterUtils;

public class GMR {
    private static final Log LOG = LogFactory.getLog((String)GMR.class.getName());

    private GMR() {
    }

    public static JobReturn runJob(MRJobInstruction inst, String[] inputs, InputInfo[] inputInfos, long[] rlens, long[] clens, int[] brlens, int[] bclens, boolean[] partitioned, ParForProgramBlock.PDataPartitionFormat[] pformats, int[] psizes, String recordReaderInstruction, String instructionsInMapper, String aggInstructionsInReducer, String otherInstructionsInReducer, int numReducers, int replication, boolean jvmReuse, byte[] resultIndexes, String dimsUnknownFilePrefix, String[] outputs, OutputInfo[] outputInfos) throws Exception {
        JobConf job = new JobConf(GMR.class);
        job.setJobName("G-MR");
        boolean inBlockRepresentation = MRJobConfiguration.deriveRepresentation(inputInfos);
        MRJobConfiguration.setMatrixValueClass(job, inBlockRepresentation);
        String[] realinputs = inputs;
        InputInfo[] realinputInfos = inputInfos;
        long[] realrlens = rlens;
        long[] realclens = clens;
        int[] realbrlens = brlens;
        int[] realbclens = bclens;
        byte[] realIndexes = new byte[inputs.length];
        for (int b = 0; b < realIndexes.length; b = (int)((byte)(b + 1))) {
            realIndexes[b] = b;
        }
        if (recordReaderInstruction != null && !recordReaderInstruction.isEmpty()) {
            assert (inputs.length <= 2);
            PickByCountInstruction ins = PickByCountInstruction.parseInstruction(recordReaderInstruction);
            PickFromCompactInputFormat.setKeyValueClasses(job, inputInfos[ins.input1].inputKeyClass, inputInfos[ins.input1].inputValueClass);
            job.setInputFormat(PickFromCompactInputFormat.class);
            PickFromCompactInputFormat.setZeroValues(job, (NumItemsByEachReducerMetaData)inputInfos[ins.input1].metadata);
            if (ins.isValuePick) {
                double[] probs = MapReduceTool.readColumnVectorFromHDFS(inputs[ins.input2], inputInfos[ins.input2], rlens[ins.input2], clens[ins.input2], brlens[ins.input2], bclens[ins.input2]);
                PickFromCompactInputFormat.setPickRecordsInEachPartFile(job, (NumItemsByEachReducerMetaData)inputInfos[ins.input1].metadata, probs);
                realinputs = new String[inputs.length - 1];
                realinputInfos = new InputInfo[inputs.length - 1];
                realrlens = new long[inputs.length - 1];
                realclens = new long[inputs.length - 1];
                realbrlens = new int[inputs.length - 1];
                realbclens = new int[inputs.length - 1];
                realIndexes = new byte[inputs.length - 1];
                int realIndex = 0;
                for (int i = 0; i < inputs.length; i = (int)((byte)(i + 1))) {
                    if (i == ins.input2) continue;
                    realinputs[realIndex] = inputs[i];
                    realinputInfos[realIndex] = inputInfos[i];
                    if (i == ins.input1) {
                        realrlens[realIndex] = rlens[ins.input2];
                        realclens[realIndex] = clens[ins.input2];
                        realbrlens[realIndex] = 1;
                        realbclens[realIndex] = 1;
                        realIndexes[realIndex] = ins.output;
                    } else {
                        realrlens[realIndex] = rlens[i];
                        realclens[realIndex] = clens[i];
                        realbrlens[realIndex] = brlens[i];
                        realbclens[realIndex] = bclens[i];
                        realIndexes[realIndex] = i;
                    }
                    realIndex = (byte)(realIndex + 1);
                }
            } else {
                PickFromCompactInputFormat.setRangePickPartFiles(job, (NumItemsByEachReducerMetaData)inputInfos[ins.input1].metadata, ins.cst, 1.0 - ins.cst);
                realrlens[ins.input1] = UtilFunctions.getLengthForInterQuantile((NumItemsByEachReducerMetaData)inputInfos[ins.input1].metadata, ins.cst);
                realclens[ins.input1] = clens[ins.input1];
                realbrlens[ins.input1] = 1;
                realbclens[ins.input1] = 1;
                realIndexes[ins.input1] = ins.output;
            }
        }
        boolean resetDistCache = GMR.setupDistributedCache(job, instructionsInMapper, otherInstructionsInReducer, realinputs, realrlens, realclens);
        boolean[] distCacheOnly = GMR.getDistCacheOnlyInputs(realIndexes, recordReaderInstruction, instructionsInMapper, aggInstructionsInReducer, otherInstructionsInReducer);
        MRJobConfiguration.setUpMultipleInputs(job, realIndexes, realinputs, realinputInfos, realbrlens, realbclens, distCacheOnly, true, inBlockRepresentation ? MRJobConfiguration.ConvertTarget.BLOCK : MRJobConfiguration.ConvertTarget.CELL);
        MRJobConfiguration.setInputPartitioningInfo(job, pformats);
        MRJobConfiguration.setMatricesDimensions(job, realIndexes, realrlens, realclens);
        MRJobConfiguration.setDimsUnknownFilePrefix(job, dimsUnknownFilePrefix);
        MRJobConfiguration.setBlocksSizes(job, realIndexes, realbrlens, realbclens);
        MRJobConfiguration.setInstructionsInMapper(job, instructionsInMapper);
        MRJobConfiguration.setAggregateInstructions(job, aggInstructionsInReducer);
        MRJobConfiguration.setInstructionsInReducer(job, otherInstructionsInReducer);
        job.setInt("dfs.replication", replication);
        MRJobConfiguration.addBinaryBlockSerializationFramework((Configuration)job);
        DMLConfig config = ConfigurationManager.getDMLConfig();
        DMLAppMasterUtils.setupMRJobRemoteMaxMemory(job, config);
        MRJobConfiguration.setupCustomMRConfigurations(job, config);
        if (jvmReuse) {
            job.setNumTasksToExecutePerJvm(-1);
        }
        HashSet<Byte> mapoutputIndexes = MRJobConfiguration.setUpOutputIndexesForMapper(job, realIndexes, instructionsInMapper, aggInstructionsInReducer, otherInstructionsInReducer, resultIndexes);
        MRJobConfiguration.MatrixChar_N_ReducerGroups ret = MRJobConfiguration.computeMatrixCharacteristics(job, realIndexes, instructionsInMapper, aggInstructionsInReducer, null, otherInstructionsInReducer, resultIndexes, mapoutputIndexes, false);
        MatrixCharacteristics[] stats = ret.stats;
        MRJobConfiguration.setNumReducers(job, ret.numReducerGroups, numReducers);
        if (LOG.isTraceEnabled()) {
            inst.printCompleteMRJobInstruction(stats);
        }
        byte[] dimsUnknown = new byte[resultIndexes.length];
        for (int i = 0; i < resultIndexes.length; ++i) {
            dimsUnknown[i] = stats[i].getRows() == -1L || stats[i].getCols() == -1L ? (byte)1 : 0;
        }
        MRJobConfiguration.setUpMultipleOutputs(job, resultIndexes, dimsUnknown, outputs, outputInfos, inBlockRepresentation, true);
        job.setMapperClass(GMRMapper.class);
        if (numReducers == 0) {
            job.setMapOutputKeyClass(Writable.class);
            job.setMapOutputValueClass(Writable.class);
        } else {
            job.setMapOutputKeyClass(MatrixIndexes.class);
            if (inBlockRepresentation) {
                job.setMapOutputValueClass(TaggedMatrixBlock.class);
            } else {
                job.setMapOutputValueClass(TaggedMatrixPackedCell.class);
            }
        }
        if (numReducers != 0 && aggInstructionsInReducer != null && !aggInstructionsInReducer.isEmpty()) {
            job.setCombinerClass(GMRCombiner.class);
        }
        job.setReducerClass(GMRReducer.class);
        MatrixCharacteristics[] inputStats = new MatrixCharacteristics[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            inputStats[i] = new MatrixCharacteristics(rlens[i], clens[i], brlens[i], bclens[i]);
        }
        MRJobConfiguration.setUniqueWorkingDir(job);
        RunningJob runjob = JobClient.runJob((JobConf)job);
        Counters.Group group = runjob.getCounters().getGroup("nonzeros");
        for (int i = 0; i < resultIndexes.length; ++i) {
            stats[i].setNonZeros(group.getCounter(Integer.toString(i)));
        }
        String dir = dimsUnknownFilePrefix + "/" + runjob.getID().toString() + "_dimsFile";
        stats = MapReduceTool.processDimsFiles(dir, stats);
        MapReduceTool.deleteFileIfExistOnHDFS(dir);
        if (resetDistCache) {
            MRBaseForCommonInstructions.resetDistCache();
        }
        return new JobReturn(stats, outputInfos, runjob.isSuccessful());
    }

    private static boolean setupDistributedCache(JobConf job, String instMap, String instRed, String[] inputs, long[] rlens, long[] clens) throws DMLRuntimeException {
        String allInsts;
        String string = allInsts = instMap != null && !instMap.trim().isEmpty() ? instMap : null;
        if (allInsts == null) {
            allInsts = instRed;
        } else if (instRed != null && !instRed.trim().isEmpty()) {
            allInsts = allInsts + "\u2021" + instRed;
        }
        if (allInsts != null && !allInsts.trim().isEmpty() && InstructionUtils.isDistributedCacheUsed(allInsts)) {
            String[] inst;
            ArrayList<Byte> indexList = new ArrayList<Byte>();
            for (String tmp : inst = allInsts.split("\u2021")) {
                if (!InstructionUtils.isDistributedCacheUsed(tmp)) continue;
                ArrayList<Byte> tmpindexList = new ArrayList<Byte>();
                MRInstruction mrinst = MRInstructionParser.parseSingleInstruction(tmp);
                if (mrinst instanceof IDistributedCacheConsumer) {
                    ((IDistributedCacheConsumer)((Object)mrinst)).addDistCacheIndex(tmp, tmpindexList);
                }
                for (Byte tmpix : tmpindexList) {
                    if (indexList.contains(tmpix)) continue;
                    indexList.add(tmpix);
                }
            }
            ArrayList<String> pathList = new ArrayList<String>();
            StringBuilder indexString = new StringBuilder();
            StringBuilder pathString = new StringBuilder();
            Iterator iterator = indexList.iterator();
            while (iterator.hasNext()) {
                byte index = (Byte)iterator.next();
                if (pathList.size() > 0) {
                    indexString.append("\u2021");
                    pathString.append("\u2021");
                }
                pathList.add(inputs[index]);
                indexString.append(index);
                pathString.append(inputs[index]);
            }
            MRJobConfiguration.setupDistCacheInputs(job, indexString.toString(), pathString.toString(), pathList);
            if (InfrastructureAnalyzer.isLocalMode(job)) {
                MRBaseForCommonInstructions.resetDistCache();
                return true;
            }
        }
        return false;
    }

    private static boolean[] getDistCacheOnlyInputs(byte[] realIndexes, String inst1, String inst2, String inst3, String inst4) throws DMLRuntimeException {
        boolean[] ret = new boolean[realIndexes.length];
        String[] inst = new String[]{inst1, inst2, inst3, inst4};
        for (int i = 0; i < ret.length; ++i) {
            byte index = realIndexes[i];
            String indexStr = index + "\u00b7" + Expression.DataType.MATRIX.toString();
            boolean distCacheOnly = true;
            boolean use = false;
            for (String linst : inst) {
                String[] alinst;
                if (linst == null || linst.trim().isEmpty()) continue;
                for (String tmp : alinst = linst.split("\u2021")) {
                    MRInstruction mrinst;
                    boolean lcache = false;
                    if (InstructionUtils.isDistributedCacheUsed(tmp) && (mrinst = MRInstructionParser.parseSingleInstruction(tmp)) instanceof IDistributedCacheConsumer) {
                        lcache = ((IDistributedCacheConsumer)((Object)mrinst)).isDistCacheOnlyIndex(tmp, index);
                    }
                    distCacheOnly &= lcache || !tmp.contains(indexStr);
                    use |= tmp.contains(indexStr);
                }
            }
            ret[i] = distCacheOnly && use;
        }
        return ret;
    }
}

