/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.util.UtilFunctions;

public class IOUtilFunctions {
    private static final Log LOG = LogFactory.getLog((String)UtilFunctions.class.getName());
    private static final char CSV_QUOTE_CHAR = '\"';

    public static FileSystem getFileSystem(String fname) throws IOException {
        return IOUtilFunctions.getFileSystem(new Path(fname), (Configuration)ConfigurationManager.getCachedJobConf());
    }

    public static FileSystem getFileSystem(Path fname) throws IOException {
        return IOUtilFunctions.getFileSystem(fname, (Configuration)ConfigurationManager.getCachedJobConf());
    }

    public static FileSystem getFileSystem(Path fname, Configuration conf) throws IOException {
        return FileSystem.get((URI)fname.toUri(), (Configuration)conf);
    }

    public static boolean isSameFileScheme(Path path1, Path path2) {
        if (path1 == null || path2 == null || path1.toUri() == null || path2.toUri() == null) {
            return false;
        }
        String scheme1 = path1.toUri().getScheme();
        String scheme2 = path2.toUri().getScheme();
        return scheme1 == null && scheme2 == null || scheme1 != null && scheme1.equals(scheme2);
    }

    public static boolean isObjectStoreFileScheme(Path path) {
        if (path == null || path.toUri() == null || path.toUri().getScheme() == null) {
            return false;
        }
        String scheme = path.toUri().getScheme();
        return scheme.startsWith("s3") || scheme.startsWith("swift");
    }

    public static String getPartFileName(int pos) {
        return String.format("0-m-%05d", pos);
    }

    public static void closeSilently(Closeable io) {
        try {
            if (io != null) {
                io.close();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to close IO resource.", (Throwable)ex);
        }
    }

    public static void closeSilently(RecordReader<?, ?> rr) {
        try {
            if (rr != null) {
                rr.close();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to close record reader.", (Throwable)ex);
        }
    }

    public static double parseDoubleParallel(String str) {
        return Double.parseDouble(str);
    }

    public static void checkAndRaiseErrorCSVEmptyField(String row, boolean fill, boolean emptyFound) throws IOException {
        if (!fill && emptyFound) {
            throw new IOException("Empty fields found in delimited file. Use \"fill\" option to read delimited files with empty fields:" + (row != null ? row : ""));
        }
    }

    public static void checkAndRaiseErrorCSVNumColumns(String fname, String line, String[] parts, long ncol) throws IOException {
        int realncol = parts.length;
        if ((long)realncol != ncol) {
            throw new IOException("Invalid number of columns (" + realncol + ", expected=" + ncol + ") found in delimited file (" + fname + ") for line: " + line);
        }
    }

    public static String[] split(String str, String delim) {
        return StringUtils.splitByWholeSeparatorPreserveAllTokens((String)str, (String)delim);
    }

    public static String[] splitCSV(String str, String delim) {
        if (str == null || str.isEmpty()) {
            return new String[]{""};
        }
        ArrayList<String> tokens = new ArrayList<String>();
        int from = 0;
        int to = 0;
        int len = str.length();
        int dlen = delim.length();
        while (from < len) {
            if (str.charAt(from) == '\"' && str.indexOf(34, from + 1) > 0) {
                to = str.indexOf(34, from + 1);
                while (to + 1 < len && str.charAt(to + 1) == '\"') {
                    to = str.indexOf(34, to + 2);
                }
                if (++to < len - 1 && !str.regionMatches(to, delim, 0, dlen)) {
                    to = str.indexOf(delim, to + 1);
                }
            } else {
                to = str.regionMatches(from, delim, 0, dlen) ? from : str.indexOf(delim, from + 1);
            }
            to = to >= 0 ? to : len;
            tokens.add(str.substring(from, to));
            from = to + delim.length();
        }
        if (from == len) {
            tokens.add("");
        }
        return tokens.toArray(new String[0]);
    }

    public static String[] splitCSV(String str, String delim, String[] tokens) {
        if (str == null || str.isEmpty()) {
            return new String[]{""};
        }
        int from = 0;
        int to = 0;
        int len = str.length();
        int dlen = delim.length();
        int pos = 0;
        while (from < len) {
            if (str.charAt(from) == '\"' && str.indexOf(34, from + 1) > 0) {
                to = str.indexOf(34, from + 1);
                while (to + 1 < len && str.charAt(to + 1) == '\"') {
                    to = str.indexOf(34, to + 2);
                }
                if (++to < len - 1 && !str.regionMatches(to, delim, 0, dlen)) {
                    to = str.indexOf(delim, to + 1);
                }
            } else {
                to = str.regionMatches(from, delim, 0, dlen) ? from : str.indexOf(delim, from + 1);
            }
            to = to >= 0 ? to : len;
            tokens[pos++] = str.substring(from, to);
            from = to + delim.length();
        }
        if (from == len) {
            tokens[pos] = "";
        }
        return tokens;
    }

    public static int countTokensCSV(String str, String delim) {
        if (str == null || str.isEmpty()) {
            return 1;
        }
        int numTokens = 0;
        int from = 0;
        int to = 0;
        int len = str.length();
        int dlen = delim.length();
        while (from < len) {
            if (str.charAt(from) == '\"' && str.indexOf(34, from + 1) > 0) {
                to = str.indexOf(34, from + 1);
                while (to + 1 < len && str.charAt(to + 1) == '\"') {
                    to = str.indexOf(34, to + 2);
                }
                if (++to < len - 1 && !str.regionMatches(to, delim, 0, dlen)) {
                    to = str.indexOf(delim, to + 1);
                }
            } else {
                to = str.regionMatches(from, delim, 0, dlen) ? from : str.indexOf(delim, from + 1);
            }
            to = to >= 0 ? to : len;
            from = to + delim.length();
            ++numTokens;
        }
        if (from == len) {
            ++numTokens;
        }
        return numTokens;
    }

    public static int countNnz(String[] cols) {
        return IOUtilFunctions.countNnz(cols, 0, cols.length);
    }

    public static int countNnz(String[] cols, int pos, int len) {
        int lnnz = 0;
        for (int i = pos; i < pos + len; ++i) {
            String col = cols[i];
            lnnz += !col.isEmpty() && !col.equals("0") && !col.equals("0.0") ? 1 : 0;
        }
        return lnnz;
    }

    public static int getUTFSize(String value) {
        if (value == null) {
            return 2;
        }
        int size = 2;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            size += c >= '\u0001' && c <= '\u007f' ? 1 : (c >= '\u0800' ? 3 : 2);
        }
        return size;
    }

    public static InputStream toInputStream(String input) throws IOException {
        if (input == null) {
            return null;
        }
        return new ReaderInputStream((Reader)new StringReader(input), "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(InputStream input) throws IOException {
        if (input == null) {
            return null;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buff = new byte[8192];
            int len = 0;
            while ((len = input.read(buff)) != -1) {
                bos.write(buff, 0, len);
            }
            String string = bos.toString("UTF-8");
            return string;
        }
        finally {
            IOUtilFunctions.closeSilently(input);
        }
    }

    public static InputSplit[] sortInputSplits(InputSplit[] splits) {
        if (splits[0] instanceof FileSplit) {
            Arrays.sort(splits, new Comparator<InputSplit>(){

                @Override
                public int compare(InputSplit o1, InputSplit o2) {
                    Path p1 = ((FileSplit)o1).getPath();
                    Path p2 = ((FileSplit)o2).getPath();
                    return p1.toString().compareTo(p2.toString());
                }
            });
        }
        return splits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countNumColumnsCSV(InputSplit[] splits, InputFormat informat, JobConf job, String delim) throws IOException {
        LongWritable key = new LongWritable();
        Text value = new Text();
        int ncol = -1;
        for (int i = 0; i < splits.length && ncol <= 0; ++i) {
            RecordReader reader = informat.getRecordReader(splits[i], job, Reporter.NULL);
            try {
                if (!reader.next((Object)key, (Object)value)) continue;
                boolean hasValue = true;
                if (value.toString().startsWith("#Meta\u00b7MV")) {
                    hasValue = reader.next((Object)key, (Object)value);
                }
                if (value.toString().startsWith("#Meta\u00b7ND")) {
                    hasValue = reader.next((Object)key, (Object)value);
                }
                String row = value.toString().trim();
                if (!hasValue || row.isEmpty()) continue;
                ncol = IOUtilFunctions.countTokensCSV(row, delim);
                continue;
            }
            finally {
                IOUtilFunctions.closeSilently(reader);
            }
        }
        return ncol;
    }

    public static Path[] getSequenceFilePaths(FileSystem fs, Path file) throws IOException {
        Path[] ret = null;
        if (fs.isDirectory(file) || IOUtilFunctions.isObjectStoreFileScheme(file)) {
            FileStatus[] dStatus;
            LinkedList<Path> tmp = new LinkedList<Path>();
            for (FileStatus fdStatus : dStatus = fs.listStatus(file)) {
                if (fdStatus.getPath().getName().startsWith("_") || fdStatus.getPath().toString().equals(file.toString() + ".mtd")) continue;
                tmp.add(fdStatus.getPath());
            }
            ret = tmp.toArray(new Path[0]);
        } else {
            ret = new Path[]{file};
        }
        return ret;
    }

    public static void deleteCrcFilesFromLocalFileSystem(FileSystem fs, Path path) throws IOException {
        if (fs instanceof LocalFileSystem) {
            Path fnameCrc = new Path(path.getParent(), "." + path.getName() + ".crc");
            fs.delete(fnameCrc, false);
            Path fnameMtdCrc = new Path(path.getParent(), "." + path.getName() + ".mtd.crc");
            fs.delete(fnameMtdCrc, false);
        }
    }
}

