/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.io.FrameReaderTextCell;
import org.apache.sysml.runtime.matrix.data.FrameBlock;

public class FrameReaderTextCellParallel
extends FrameReaderTextCell {
    @Override
    protected void readTextCellFrameFromHDFS(Path path, JobConf job, FileSystem fs, FrameBlock dest, Expression.ValueType[] schema, String[] names, long rlen, long clen) throws IOException {
        int numThreads = OptimizerUtils.getParallelTextReadParallelism();
        FileInputFormat.addInputPath((JobConf)job, (Path)path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        try {
            ExecutorService pool = Executors.newFixedThreadPool(numThreads);
            InputSplit[] splits = informat.getSplits(job, numThreads);
            ArrayList<ReadTask> tasks = new ArrayList<ReadTask>();
            for (InputSplit split : splits) {
                tasks.add(new ReadTask(split, informat, job, dest));
            }
            List rt = pool.invokeAll(tasks);
            pool.shutdown();
            for (Future task : rt) {
                task.get();
            }
        }
        catch (Exception e) {
            throw new IOException("Failed parallel read of text cell input.", e);
        }
    }

    public class ReadTask
    implements Callable<Object> {
        private InputSplit _split = null;
        private TextInputFormat _informat = null;
        private JobConf _job = null;
        private FrameBlock _dest = null;

        public ReadTask(InputSplit split, TextInputFormat informat, JobConf job, FrameBlock dest) {
            this._split = split;
            this._informat = informat;
            this._job = job;
            this._dest = dest;
        }

        @Override
        public Object call() throws Exception {
            FrameReaderTextCellParallel.this.readTextCellFrameFromInputSplit(this._split, this._informat, this._job, this._dest);
            return null;
        }
    }
}

