/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.broadcast.Broadcast;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.functionobjects.SortIndex;
import org.apache.sysml.runtime.instructions.spark.data.PartitionedBlock;
import org.apache.sysml.runtime.instructions.spark.data.RowMatrixBlock;
import org.apache.sysml.runtime.instructions.spark.functions.ReplicateVectorFunction;
import org.apache.sysml.runtime.instructions.spark.utils.RDDAggregateUtils;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.operators.ReorgOperator;
import org.apache.sysml.runtime.util.DataConverter;
import org.apache.sysml.runtime.util.UtilFunctions;
import scala.Tuple2;

public class RDDSortUtils {
    public static JavaPairRDD<MatrixIndexes, MatrixBlock> sortByVal(JavaPairRDD<MatrixIndexes, MatrixBlock> in, long rlen, int brlen) {
        JavaRDD dvals = in.values().flatMap((FlatMapFunction)new ExtractDoubleValuesFunction());
        long hdfsBlocksize = InfrastructureAnalyzer.getHDFSBlockSize();
        int numPartitions = (int)Math.ceil((double)rlen * 8.0 / (double)hdfsBlocksize);
        JavaRDD sdvals = dvals.sortBy((Function)new CreateDoubleKeyFunction(), true, numPartitions);
        JavaPairRDD<MatrixIndexes, MatrixBlock> ret = sdvals.zipWithIndex().mapPartitionsToPair((PairFlatMapFunction)new ConvertToBinaryBlockFunction(rlen, brlen));
        ret = RDDAggregateUtils.mergeByKey(ret, false);
        return ret;
    }

    public static JavaPairRDD<MatrixIndexes, MatrixBlock> sortByVal(JavaPairRDD<MatrixIndexes, MatrixBlock> in, JavaPairRDD<MatrixIndexes, MatrixBlock> in2, long rlen, int brlen) {
        JavaRDD dvals = in.join(in2).values().flatMap((FlatMapFunction)new ExtractDoubleValuesFunction2());
        long hdfsBlocksize = InfrastructureAnalyzer.getHDFSBlockSize();
        int numPartitions = (int)Math.ceil((double)rlen * 8.0 / (double)hdfsBlocksize);
        JavaRDD sdvals = dvals.sortBy((Function)new CreateDoubleKeyFunction2(), true, numPartitions);
        JavaPairRDD<MatrixIndexes, MatrixBlock> ret = sdvals.zipWithIndex().mapPartitionsToPair((PairFlatMapFunction)new ConvertToBinaryBlockFunction2(rlen, brlen));
        ret = RDDAggregateUtils.mergeByKey(ret, false);
        return ret;
    }

    public static JavaPairRDD<MatrixIndexes, MatrixBlock> sortIndexesByVal(JavaPairRDD<MatrixIndexes, MatrixBlock> val, boolean asc, long rlen, int brlen) {
        JavaPairRDD dvals = val.flatMapToPair((PairFlatMapFunction)new ExtractDoubleValuesWithIndexFunction(brlen));
        long hdfsBlocksize = InfrastructureAnalyzer.getHDFSBlockSize();
        int numPartitions = (int)Math.ceil((double)rlen * 16.0 / (double)hdfsBlocksize);
        JavaRDD sdvals = dvals.sortByKey((Comparator)new IndexComparator(asc), true, numPartitions).keys();
        JavaPairRDD<MatrixIndexes, MatrixBlock> ret = sdvals.zipWithIndex().mapPartitionsToPair((PairFlatMapFunction)new ConvertToBinaryBlockFunction3(rlen, brlen));
        ret = RDDAggregateUtils.mergeByKey(ret, false);
        return ret;
    }

    public static JavaPairRDD<MatrixIndexes, MatrixBlock> sortDataByVal(JavaPairRDD<MatrixIndexes, MatrixBlock> val, JavaPairRDD<MatrixIndexes, MatrixBlock> data, boolean asc, long rlen, long clen, int brlen, int bclen) {
        JavaPairRDD dvals = val.flatMapToPair((PairFlatMapFunction)new ExtractDoubleValuesWithIndexFunction(brlen));
        long hdfsBlocksize = InfrastructureAnalyzer.getHDFSBlockSize();
        int numPartitions = (int)Math.ceil((double)rlen * 16.0 / (double)hdfsBlocksize);
        JavaRDD sdvals = dvals.sortByKey((Comparator)new IndexComparator(asc), true, numPartitions).keys();
        long numRep = (long)Math.ceil((double)clen / (double)bclen);
        JavaPairRDD<MatrixIndexes, MatrixBlock> ixmap = sdvals.zipWithIndex().mapToPair((PairFunction)new ExtractIndexFunction()).sortByKey().mapPartitionsToPair((PairFlatMapFunction)new ConvertToBinaryBlockFunction4(rlen, brlen));
        ixmap = RDDAggregateUtils.mergeByKey(ixmap, false);
        JavaPairRDD rixmap = ixmap.flatMapToPair((PairFlatMapFunction)new ReplicateVectorFunction(false, numRep));
        JavaPairRDD ret = data.join(rixmap).mapPartitionsToPair((PairFlatMapFunction)new ShuffleMatrixBlockRowsFunction(rlen, brlen));
        return RDDAggregateUtils.mergeRowsByKey((JavaPairRDD<MatrixIndexes, RowMatrixBlock>)ret);
    }

    public static JavaPairRDD<MatrixIndexes, MatrixBlock> sortDataByValMemSort(JavaPairRDD<MatrixIndexes, MatrixBlock> val, JavaPairRDD<MatrixIndexes, MatrixBlock> data, boolean asc, long rlen, long clen, int brlen, int bclen, SparkExecutionContext sec, ReorgOperator r_op) throws DMLRuntimeException {
        MatrixBlock inMatBlock = SparkExecutionContext.toMatrixBlock(val, (int)rlen, 1, brlen, bclen, -1L);
        ReorgOperator lrop = new ReorgOperator(SortIndex.getSortIndexFnObject(1, !asc, true));
        MatrixBlock sortedIx = (MatrixBlock)inMatBlock.reorgOperations(lrop, new MatrixBlock(), -1, -1, -1);
        MatrixBlock sortedIxSrc = new MatrixBlock(sortedIx.getNumRows(), 1, false);
        for (int i = 0; i < sortedIx.getNumRows(); ++i) {
            sortedIxSrc.quickSetValue((int)sortedIx.quickGetValue(i, 0) - 1, 0, i + 1);
        }
        PartitionedBlock<MatrixBlock> pmb = new PartitionedBlock<MatrixBlock>(sortedIxSrc, brlen, bclen);
        Broadcast _pmb = sec.getSparkContext().broadcast(pmb);
        JavaPairRDD ret = data.mapPartitionsToPair((PairFlatMapFunction)new ShuffleMatrixBlockRowsInMemFunction(rlen, brlen, (Broadcast<PartitionedBlock<MatrixBlock>>)_pmb));
        return RDDAggregateUtils.mergeRowsByKey((JavaPairRDD<MatrixIndexes, RowMatrixBlock>)ret);
    }

    public static class IndexComparator
    implements Comparator<ValueIndexPair>,
    Serializable {
        private static final long serialVersionUID = 5154839870549241343L;
        private boolean _asc;

        public IndexComparator(boolean asc) {
            this._asc = asc;
        }

        @Override
        public int compare(ValueIndexPair o1, ValueIndexPair o2) {
            int retVal = Double.valueOf(o1.val).compareTo(o2.val);
            if (retVal != 0) {
                return this._asc ? retVal : -1 * retVal;
            }
            return Long.valueOf(o1.ix).compareTo(o2.ix);
        }
    }

    private static class ValueIndexPair
    implements Serializable {
        private static final long serialVersionUID = -3273385845538526829L;
        public double val;
        public long ix;

        public ValueIndexPair(double dval, long lix) {
            this.val = dval;
            this.ix = lix;
        }
    }

    private static class DoublePair
    implements Serializable {
        private static final long serialVersionUID = 4373356163734559009L;
        public double val1;
        public double val2;

        public DoublePair(double d1, double d2) {
            this.val1 = d1;
            this.val2 = d2;
        }
    }

    private static class ShuffleMatrixBlockRowsInMemFunction
    implements PairFlatMapFunction<Iterator<Tuple2<MatrixIndexes, MatrixBlock>>, MatrixIndexes, RowMatrixBlock> {
        private static final long serialVersionUID = 6885207719329119646L;
        private long _rlen = -1L;
        private int _brlen = -1;
        private Broadcast<PartitionedBlock<MatrixBlock>> _pmb = null;

        public ShuffleMatrixBlockRowsInMemFunction(long rlen, int brlen, Broadcast<PartitionedBlock<MatrixBlock>> pmb) {
            this._rlen = rlen;
            this._brlen = brlen;
            this._pmb = pmb;
        }

        public ShuffleMatrixIterator call(Iterator<Tuple2<MatrixIndexes, MatrixBlock>> arg0) throws Exception {
            return new ShuffleMatrixIterator(arg0);
        }

        private class ShuffleMatrixIterator
        implements Iterable<Tuple2<MatrixIndexes, RowMatrixBlock>>,
        Iterator<Tuple2<MatrixIndexes, RowMatrixBlock>> {
            private Iterator<Tuple2<MatrixIndexes, MatrixBlock>> _inIter = null;
            private Tuple2<MatrixIndexes, MatrixBlock> _currBlk = null;
            private int _currPos = -1;

            public ShuffleMatrixIterator(Iterator<Tuple2<MatrixIndexes, MatrixBlock>> in) {
                this._inIter = in;
            }

            @Override
            public Iterator<Tuple2<MatrixIndexes, RowMatrixBlock>> iterator() {
                return this;
            }

            @Override
            public boolean hasNext() {
                return this._currBlk != null || this._inIter.hasNext();
            }

            @Override
            public Tuple2<MatrixIndexes, RowMatrixBlock> next() {
                if (this._currBlk == null) {
                    this._currBlk = this._inIter.next();
                    this._currPos = 0;
                }
                try {
                    MatrixIndexes ixmap = (MatrixIndexes)this._currBlk._1();
                    MatrixBlock data = (MatrixBlock)this._currBlk._2();
                    MatrixBlock mbTargetIndex = (MatrixBlock)((PartitionedBlock)ShuffleMatrixBlockRowsInMemFunction.this._pmb.value()).getBlock((int)ixmap.getRowIndex(), 1);
                    long valix = (long)mbTargetIndex.getValue(this._currPos, 0);
                    long rix = UtilFunctions.computeBlockIndex(valix, ShuffleMatrixBlockRowsInMemFunction.this._brlen);
                    int pos = UtilFunctions.computeCellInBlock(valix, ShuffleMatrixBlockRowsInMemFunction.this._brlen);
                    int len = UtilFunctions.computeBlockSize(ShuffleMatrixBlockRowsInMemFunction.this._rlen, rix, ShuffleMatrixBlockRowsInMemFunction.this._brlen);
                    MatrixIndexes lix = new MatrixIndexes(rix, ixmap.getColumnIndex());
                    MatrixBlock tmp = data.sliceOperations(this._currPos, this._currPos, 0, data.getNumColumns() - 1, new MatrixBlock());
                    ++this._currPos;
                    if (this._currPos == data.getNumRows()) {
                        this._currBlk = null;
                    }
                    return new Tuple2((Object)lix, (Object)new RowMatrixBlock(len, pos, tmp));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public void remove() {
                throw new RuntimeException("Unsupported remove operation.");
            }
        }
    }

    private static class ShuffleMatrixBlockRowsFunction
    implements PairFlatMapFunction<Iterator<Tuple2<MatrixIndexes, Tuple2<MatrixBlock, MatrixBlock>>>, MatrixIndexes, RowMatrixBlock> {
        private static final long serialVersionUID = 6885207719329119646L;
        private long _rlen = -1L;
        private int _brlen = -1;

        public ShuffleMatrixBlockRowsFunction(long rlen, int brlen) {
            this._rlen = rlen;
            this._brlen = brlen;
        }

        public ShuffleMatrixIterator call(Iterator<Tuple2<MatrixIndexes, Tuple2<MatrixBlock, MatrixBlock>>> arg0) throws Exception {
            return new ShuffleMatrixIterator(arg0);
        }

        private class ShuffleMatrixIterator
        implements Iterable<Tuple2<MatrixIndexes, RowMatrixBlock>>,
        Iterator<Tuple2<MatrixIndexes, RowMatrixBlock>> {
            private Iterator<Tuple2<MatrixIndexes, Tuple2<MatrixBlock, MatrixBlock>>> _inIter = null;
            private Tuple2<MatrixIndexes, Tuple2<MatrixBlock, MatrixBlock>> _currBlk = null;
            private int _currPos = -1;

            public ShuffleMatrixIterator(Iterator<Tuple2<MatrixIndexes, Tuple2<MatrixBlock, MatrixBlock>>> in) {
                this._inIter = in;
            }

            @Override
            public Iterator<Tuple2<MatrixIndexes, RowMatrixBlock>> iterator() {
                return this;
            }

            @Override
            public boolean hasNext() {
                return this._currBlk != null || this._inIter.hasNext();
            }

            @Override
            public Tuple2<MatrixIndexes, RowMatrixBlock> next() {
                if (this._currBlk == null) {
                    this._currBlk = this._inIter.next();
                    this._currPos = 0;
                }
                try {
                    MatrixIndexes ixmap = (MatrixIndexes)this._currBlk._1();
                    MatrixBlock data = (MatrixBlock)((Tuple2)this._currBlk._2())._1();
                    MatrixBlock mbTargetIndex = (MatrixBlock)((Tuple2)this._currBlk._2())._2();
                    long valix = (long)mbTargetIndex.getValue(this._currPos, 0);
                    long rix = UtilFunctions.computeBlockIndex(valix, ShuffleMatrixBlockRowsFunction.this._brlen);
                    int pos = UtilFunctions.computeCellInBlock(valix, ShuffleMatrixBlockRowsFunction.this._brlen);
                    int len = UtilFunctions.computeBlockSize(ShuffleMatrixBlockRowsFunction.this._rlen, rix, ShuffleMatrixBlockRowsFunction.this._brlen);
                    MatrixIndexes lix = new MatrixIndexes(rix, ixmap.getColumnIndex());
                    MatrixBlock tmp = data.sliceOperations(this._currPos, this._currPos, 0, data.getNumColumns() - 1, new MatrixBlock());
                    ++this._currPos;
                    if (this._currPos == data.getNumRows()) {
                        this._currBlk = null;
                    }
                    return new Tuple2((Object)lix, (Object)new RowMatrixBlock(len, pos, tmp));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public void remove() {
                throw new RuntimeException("Unsupported remove operation.");
            }
        }
    }

    private static class ConvertToBinaryBlockFunction4
    implements PairFlatMapFunction<Iterator<Tuple2<Long, Long>>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 9113122668214965797L;
        private long _rlen = -1L;
        private int _brlen = -1;

        public ConvertToBinaryBlockFunction4(long rlen, int brlen) {
            this._rlen = rlen;
            this._brlen = brlen;
        }

        public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Iterator<Tuple2<Long, Long>> arg0) throws Exception {
            ArrayList<Tuple2> ret = new ArrayList<Tuple2>();
            MatrixIndexes ix = null;
            MatrixBlock mb = null;
            while (arg0.hasNext()) {
                Tuple2<Long, Long> val = arg0.next();
                long valix = (Long)val._1;
                long rix = UtilFunctions.computeBlockIndex(valix, this._brlen);
                int pos = UtilFunctions.computeCellInBlock(valix, this._brlen);
                if (ix == null || ix.getRowIndex() != rix) {
                    if (ix != null) {
                        ret.add(new Tuple2((Object)ix, (Object)mb));
                    }
                    long len = UtilFunctions.computeBlockSize(this._rlen, rix, this._brlen);
                    ix = new MatrixIndexes(rix, 1L);
                    mb = new MatrixBlock((int)len, 1, false);
                }
                mb.quickSetValue(pos, 0, (Long)val._2 + 1L);
            }
            if (mb != null && mb.getNonZeros() != 0L) {
                ret.add(new Tuple2(ix, (Object)mb));
            }
            return ret.iterator();
        }
    }

    private static class ConvertToBinaryBlockFunction3
    implements PairFlatMapFunction<Iterator<Tuple2<ValueIndexPair, Long>>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 9113122668214965797L;
        private long _rlen = -1L;
        private int _brlen = -1;

        public ConvertToBinaryBlockFunction3(long rlen, int brlen) {
            this._rlen = rlen;
            this._brlen = brlen;
        }

        public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Iterator<Tuple2<ValueIndexPair, Long>> arg0) throws Exception {
            ArrayList<Tuple2> ret = new ArrayList<Tuple2>();
            MatrixIndexes ix = null;
            MatrixBlock mb = null;
            while (arg0.hasNext()) {
                Tuple2<ValueIndexPair, Long> val = arg0.next();
                long valix = (Long)val._2 + 1L;
                long rix = UtilFunctions.computeBlockIndex(valix, this._brlen);
                int pos = UtilFunctions.computeCellInBlock(valix, this._brlen);
                if (ix == null || ix.getRowIndex() != rix) {
                    if (ix != null) {
                        ret.add(new Tuple2((Object)ix, (Object)mb));
                    }
                    long len = UtilFunctions.computeBlockSize(this._rlen, rix, this._brlen);
                    ix = new MatrixIndexes(rix, 1L);
                    mb = new MatrixBlock((int)len, 1, false);
                }
                mb.quickSetValue(pos, 0, ((ValueIndexPair)val._1).ix);
            }
            if (mb != null && mb.getNonZeros() != 0L) {
                ret.add(new Tuple2(ix, (Object)mb));
            }
            return ret.iterator();
        }
    }

    private static class ConvertToBinaryBlockFunction2
    implements PairFlatMapFunction<Iterator<Tuple2<DoublePair, Long>>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = -8638434373377180192L;
        private long _rlen = -1L;
        private int _brlen = -1;

        public ConvertToBinaryBlockFunction2(long rlen, int brlen) {
            this._rlen = rlen;
            this._brlen = brlen;
        }

        public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Iterator<Tuple2<DoublePair, Long>> arg0) throws Exception {
            ArrayList<Tuple2> ret = new ArrayList<Tuple2>();
            MatrixIndexes ix = null;
            MatrixBlock mb = null;
            while (arg0.hasNext()) {
                Tuple2<DoublePair, Long> val = arg0.next();
                long valix = (Long)val._2 + 1L;
                long rix = UtilFunctions.computeBlockIndex(valix, this._brlen);
                int pos = UtilFunctions.computeCellInBlock(valix, this._brlen);
                if (ix == null || ix.getRowIndex() != rix) {
                    if (ix != null) {
                        ret.add(new Tuple2((Object)ix, (Object)mb));
                    }
                    long len = UtilFunctions.computeBlockSize(this._rlen, rix, this._brlen);
                    ix = new MatrixIndexes(rix, 1L);
                    mb = new MatrixBlock((int)len, 2, false);
                }
                mb.quickSetValue(pos, 0, ((DoublePair)val._1).val1);
                mb.quickSetValue(pos, 1, ((DoublePair)val._1).val2);
            }
            if (mb != null && mb.getNonZeros() != 0L) {
                ret.add(new Tuple2(ix, (Object)mb));
            }
            return ret.iterator();
        }
    }

    private static class ConvertToBinaryBlockFunction
    implements PairFlatMapFunction<Iterator<Tuple2<Double, Long>>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 5000298196472931653L;
        private long _rlen = -1L;
        private int _brlen = -1;

        public ConvertToBinaryBlockFunction(long rlen, int brlen) {
            this._rlen = rlen;
            this._brlen = brlen;
        }

        public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Iterator<Tuple2<Double, Long>> arg0) throws Exception {
            ArrayList<Tuple2> ret = new ArrayList<Tuple2>();
            MatrixIndexes ix = null;
            MatrixBlock mb = null;
            while (arg0.hasNext()) {
                Tuple2<Double, Long> val = arg0.next();
                long valix = (Long)val._2 + 1L;
                long rix = UtilFunctions.computeBlockIndex(valix, this._brlen);
                int pos = UtilFunctions.computeCellInBlock(valix, this._brlen);
                if (ix == null || ix.getRowIndex() != rix) {
                    if (ix != null) {
                        ret.add(new Tuple2((Object)ix, (Object)mb));
                    }
                    long len = UtilFunctions.computeBlockSize(this._rlen, rix, this._brlen);
                    ix = new MatrixIndexes(rix, 1L);
                    mb = new MatrixBlock((int)len, 1, false);
                }
                mb.quickSetValue(pos, 0, (Double)val._1);
            }
            if (mb != null && mb.getNonZeros() != 0L) {
                ret.add(new Tuple2(ix, (Object)mb));
            }
            return ret.iterator();
        }
    }

    private static class ExtractIndexFunction
    implements PairFunction<Tuple2<ValueIndexPair, Long>, Long, Long> {
        private static final long serialVersionUID = -4553468724131249535L;

        private ExtractIndexFunction() {
        }

        public Tuple2<Long, Long> call(Tuple2<ValueIndexPair, Long> arg0) throws Exception {
            return new Tuple2((Object)((ValueIndexPair)arg0._1()).ix, arg0._2());
        }
    }

    private static class CreateDoubleKeyFunction2
    implements Function<DoublePair, Double> {
        private static final long serialVersionUID = -7954819651274239592L;

        private CreateDoubleKeyFunction2() {
        }

        public Double call(DoublePair arg0) throws Exception {
            return arg0.val1;
        }
    }

    private static class CreateDoubleKeyFunction
    implements Function<Double, Double> {
        private static final long serialVersionUID = 2021786334763247835L;

        private CreateDoubleKeyFunction() {
        }

        public Double call(Double arg0) throws Exception {
            return arg0;
        }
    }

    private static class ExtractDoubleValuesWithIndexFunction
    implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, ValueIndexPair, Double> {
        private static final long serialVersionUID = -3976735381580482118L;
        private int _brlen = -1;

        public ExtractDoubleValuesWithIndexFunction(int brlen) {
            this._brlen = brlen;
        }

        public Iterator<Tuple2<ValueIndexPair, Double>> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
            ArrayList<Tuple2> ret = new ArrayList<Tuple2>();
            MatrixIndexes ix = (MatrixIndexes)arg0._1();
            MatrixBlock mb = (MatrixBlock)arg0._2();
            long ixoffset = (ix.getRowIndex() - 1L) * (long)this._brlen;
            for (int i = 0; i < mb.getNumRows(); ++i) {
                double val = mb.quickGetValue(i, 0);
                ret.add(new Tuple2((Object)new ValueIndexPair(val, ixoffset + (long)i + 1L), (Object)val));
            }
            return ret.iterator();
        }
    }

    private static class ExtractDoubleValuesFunction2
    implements FlatMapFunction<Tuple2<MatrixBlock, MatrixBlock>, DoublePair> {
        private static final long serialVersionUID = 2132672563825289022L;

        private ExtractDoubleValuesFunction2() {
        }

        public Iterator<DoublePair> call(Tuple2<MatrixBlock, MatrixBlock> arg0) throws Exception {
            ArrayList<DoublePair> ret = new ArrayList<DoublePair>();
            MatrixBlock mb1 = (MatrixBlock)arg0._1();
            MatrixBlock mb2 = (MatrixBlock)arg0._2();
            for (int i = 0; i < mb1.getNumRows(); ++i) {
                ret.add(new DoublePair(mb1.quickGetValue(i, 0), mb2.quickGetValue(i, 0)));
            }
            return ret.iterator();
        }
    }

    private static class ExtractDoubleValuesFunction
    implements FlatMapFunction<MatrixBlock, Double> {
        private static final long serialVersionUID = 6888003502286282876L;

        private ExtractDoubleValuesFunction() {
        }

        public Iterator<Double> call(MatrixBlock arg0) throws Exception {
            return DataConverter.convertToDoubleList(arg0).iterator();
        }
    }
}

