/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.functionobjects.MinusMultiply;
import org.apache.sysml.runtime.functionobjects.PlusMultiply;
import org.apache.sysml.runtime.functionobjects.ValueFunctionWithConstant;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.spark.ArithmeticBinarySPInstruction;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;

public class PlusMultSPInstruction
extends ArithmeticBinarySPInstruction {
    private PlusMultSPInstruction(BinaryOperator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String str) throws DMLRuntimeException {
        super(op, in1, in2, out, opcode, str);
        this.input3 = in3;
        if (!opcode.equalsIgnoreCase("+*") && !opcode.equalsIgnoreCase("-*")) {
            throw new DMLRuntimeException("Unknown opcode in PlusMultSPInstruction: " + this.toString());
        }
    }

    public static PlusMultSPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand operand1 = new CPOperand(parts[1]);
        CPOperand operand2 = new CPOperand(parts[3]);
        CPOperand operand3 = new CPOperand(parts[2]);
        CPOperand outOperand = new CPOperand(parts[4]);
        BinaryOperator bOperator = new BinaryOperator(opcode.equals("+*") ? PlusMultiply.getPlusMultiplyFnObject() : MinusMultiply.getMinusMultiplyFnObject());
        return new PlusMultSPInstruction(bOperator, operand1, operand2, operand3, outOperand, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        ScalarObject constant = ec.getScalarInput(this.input3.getName(), this.input3.getValueType(), this.input3.isLiteral());
        ((ValueFunctionWithConstant)((BinaryOperator)this._optr).fn).setConstant(constant.getDoubleValue());
        super.processMatrixMatrixBinaryInstruction(sec);
    }
}

