/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import java.util.HashMap;
import org.apache.sysml.lops.Ternary;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.matrix.data.CTableMap;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.OperationsOnMatrixValues;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;

public class TernaryInstruction
extends MRInstruction {
    private Ternary.OperationTypes _op;
    public byte input1;
    public byte input2;
    public byte input3;
    public double scalar_input2;
    public double scalar_input3;
    private long _outputDim1;
    private long _outputDim2;

    private TernaryInstruction(Ternary.OperationTypes op, byte in1, double scalar_in2, double scalar_in3, byte out, long outputDim1, long outputDim2, String istr) {
        super(null, out);
        this.mrtype = MRInstruction.MRINSTRUCTION_TYPE.Ternary;
        this._op = op;
        this.input1 = in1;
        this.scalar_input2 = scalar_in2;
        this.scalar_input3 = scalar_in3;
        this._outputDim1 = outputDim1;
        this._outputDim2 = outputDim2;
        this.instString = istr;
    }

    private TernaryInstruction(Ternary.OperationTypes op, byte in1, byte in2, double scalar_in3, byte out, long outputDim1, long outputDim2, String istr) {
        super(null, out);
        this.mrtype = MRInstruction.MRINSTRUCTION_TYPE.Ternary;
        this._op = op;
        this.input1 = in1;
        this.input2 = in2;
        this.scalar_input3 = scalar_in3;
        this._outputDim1 = outputDim1;
        this._outputDim2 = outputDim2;
        this.instString = istr;
    }

    private TernaryInstruction(Ternary.OperationTypes op, byte in1, double scalar_in2, byte in3, byte out, long outputDim1, long outputDim2, String istr) {
        super(null, out);
        this.mrtype = MRInstruction.MRINSTRUCTION_TYPE.Ternary;
        this._op = op;
        this.input1 = in1;
        this.scalar_input2 = scalar_in2;
        this.input3 = in3;
        this._outputDim1 = outputDim1;
        this._outputDim2 = outputDim2;
        this.instString = istr;
    }

    protected TernaryInstruction(Ternary.OperationTypes op, byte in1, byte in2, byte in3, byte out, long outputDim1, long outputDim2, String istr) {
        super(null, out);
        this.mrtype = MRInstruction.MRINSTRUCTION_TYPE.Ternary;
        this._op = op;
        this.input1 = in1;
        this.input2 = in2;
        this.input3 = in3;
        this._outputDim1 = outputDim1;
        this._outputDim2 = outputDim2;
        this.instString = istr;
    }

    public long getOutputDim1() {
        return this._outputDim1;
    }

    public long getOutputDim2() {
        return this._outputDim2;
    }

    public boolean knownOutputDims() {
        return this._outputDim1 > 0L && this._outputDim2 > 0L;
    }

    public static TernaryInstruction parseInstruction(String str) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(str, 6);
        String[] parts = InstructionUtils.getInstructionParts(str);
        String opcode = parts[0];
        byte in1 = Byte.parseByte(parts[1]);
        long outputDim1 = (long)Double.parseDouble(parts[4]);
        long outputDim2 = (long)Double.parseDouble(parts[5]);
        byte out = Byte.parseByte(parts[6]);
        Ternary.OperationTypes op = Ternary.getOperationType(opcode);
        switch (op) {
            case CTABLE_TRANSFORM: {
                byte in2 = Byte.parseByte(parts[2]);
                byte in3 = Byte.parseByte(parts[3]);
                return new TernaryInstruction(op, in1, in2, in3, out, outputDim1, outputDim2, str);
            }
            case CTABLE_TRANSFORM_SCALAR_WEIGHT: {
                byte in2 = Byte.parseByte(parts[2]);
                double scalar_in3 = Double.parseDouble(parts[3]);
                return new TernaryInstruction(op, in1, in2, scalar_in3, out, outputDim1, outputDim2, str);
            }
            case CTABLE_EXPAND_SCALAR_WEIGHT: {
                double scalar_in2 = Double.parseDouble(parts[2]);
                double type = Double.parseDouble(parts[3]);
                return new TernaryInstruction(op, in1, scalar_in2, type, out, outputDim1, outputDim2, str);
            }
            case CTABLE_TRANSFORM_HISTOGRAM: {
                double scalar_in2 = Double.parseDouble(parts[2]);
                double scalar_in3 = Double.parseDouble(parts[3]);
                return new TernaryInstruction(op, in1, scalar_in2, scalar_in3, out, outputDim1, outputDim2, str);
            }
            case CTABLE_TRANSFORM_WEIGHTED_HISTOGRAM: {
                double scalar_in2 = Double.parseDouble(parts[2]);
                byte in3 = Byte.parseByte(parts[3]);
                return new TernaryInstruction(op, in1, scalar_in2, in3, out, outputDim1, outputDim2, str);
            }
        }
        throw new DMLRuntimeException("Unrecognized opcode in Ternary Instruction: " + (Object)((Object)op));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue zeroInput, HashMap<Byte, CTableMap> resultMaps, HashMap<Byte, MatrixBlock> resultBlocks, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        IndexedMatrixValue in3 = null;
        IndexedMatrixValue in1 = cachedValues.getFirst(this.input1);
        CTableMap ctableResult = null;
        MatrixBlock ctableResultBlock = null;
        if (this.knownOutputDims()) {
            if (resultBlocks == null) throw new DMLRuntimeException("Unexpected error in processing table instruction.");
            ctableResultBlock = resultBlocks.get(this.output);
            if (ctableResultBlock == null) {
                ctableResultBlock = new MatrixBlock((int)this._outputDim1, (int)this._outputDim2, true);
                resultBlocks.put(this.output, ctableResultBlock);
            }
        } else {
            ctableResult = resultMaps.get(this.output);
            if (ctableResult == null) {
                ctableResult = new CTableMap();
                resultMaps.put(this.output, ctableResult);
            }
        }
        switch (this._op) {
            case CTABLE_TRANSFORM: {
                IndexedMatrixValue in2 = cachedValues.getFirst(this.input2);
                in3 = cachedValues.getFirst(this.input3);
                if (in1 == null || in2 == null || in3 == null) {
                    return;
                }
                OperationsOnMatrixValues.performTernary(in1.getIndexes(), in1.getValue(), in2.getIndexes(), in2.getValue(), in3.getIndexes(), in3.getValue(), ctableResult, ctableResultBlock, this.optr);
                return;
            }
            case CTABLE_TRANSFORM_SCALAR_WEIGHT: {
                IndexedMatrixValue in2 = cachedValues.getFirst(this.input2);
                if (in1 == null || in2 == null) {
                    return;
                }
                OperationsOnMatrixValues.performTernary(in1.getIndexes(), in1.getValue(), in2.getIndexes(), in2.getValue(), this.scalar_input3, ctableResult, ctableResultBlock, this.optr);
                return;
            }
            case CTABLE_EXPAND_SCALAR_WEIGHT: {
                if (in1 == null) {
                    return;
                }
                OperationsOnMatrixValues.performTernary(in1.getIndexes(), in1.getValue(), this.scalar_input2, this.scalar_input3 == 1.0, blockRowFactor, ctableResult, ctableResultBlock, this.optr);
                return;
            }
            case CTABLE_TRANSFORM_HISTOGRAM: {
                if (in1 == null) {
                    return;
                }
                OperationsOnMatrixValues.performTernary(in1.getIndexes(), in1.getValue(), this.scalar_input2, this.scalar_input3, ctableResult, ctableResultBlock, this.optr);
                return;
            }
            case CTABLE_TRANSFORM_WEIGHTED_HISTOGRAM: {
                in3 = cachedValues.getFirst(this.input3);
                if (in1 == null || in3 == null) {
                    return;
                }
                OperationsOnMatrixValues.performTernary(in1.getIndexes(), in1.getValue(), this.scalar_input2, in3.getIndexes(), in3.getValue(), ctableResult, ctableResultBlock, this.optr);
                return;
            }
            default: {
                throw new DMLRuntimeException("Unrecognized opcode in Tertiary Instruction: " + this.instString);
            }
        }
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        throw new DMLRuntimeException("This function should not be called!");
    }

    @Override
    public byte[] getAllIndexes() throws DMLRuntimeException {
        return new byte[]{this.input1, this.input2, this.input3, this.output};
    }

    @Override
    public byte[] getInputIndexes() throws DMLRuntimeException {
        return new byte[]{this.input1, this.input2, this.input3};
    }
}

