/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.ValueFunctionWithConstant;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.BinaryInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class PlusMultInstruction
extends BinaryInstruction {
    private PlusMultInstruction(Operator op, byte in1, byte in2, byte out, String istr) {
        super(op, in1, in2, out, istr);
    }

    public static PlusMultInstruction parseInstruction(String str) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(str, 4);
        String[] parts = InstructionUtils.getInstructionParts(str);
        String opcode = parts[0];
        byte in1 = Byte.parseByte(parts[1]);
        double scalar = Double.parseDouble(parts[2]);
        byte in2 = Byte.parseByte(parts[3]);
        byte out = Byte.parseByte(parts[4]);
        BinaryOperator bop = InstructionUtils.parseBinaryOperator(opcode);
        ((ValueFunctionWithConstant)bop.fn).setConstant(scalar);
        return new PlusMultInstruction(bop, in1, in2, out, str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        super.processInstruction(valueClass, cachedValues, tempValue, zeroInput, blockRowFactor, blockColFactor);
    }
}

