/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import java.util.ArrayList;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.OperationsOnMatrixValues;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;

public class BinUaggChainInstruction
extends UnaryInstruction {
    private BinaryOperator _bOp = null;
    private AggregateUnaryOperator _uaggOp = null;
    private MatrixIndexes _tmpIx = null;
    private MatrixValue _tmpVal = null;

    private BinUaggChainInstruction(BinaryOperator bop, AggregateUnaryOperator uaggop, byte in1, byte out, String istr) {
        super(null, in1, out, istr);
        this._bOp = bop;
        this._uaggOp = uaggop;
        this._tmpIx = new MatrixIndexes();
        this._tmpVal = new MatrixBlock();
        this.mrtype = MRInstruction.MRINSTRUCTION_TYPE.BinUaggChain;
        this.instString = istr;
    }

    public static BinUaggChainInstruction parseInstruction(String str) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(str, 4);
        String[] parts = InstructionUtils.getInstructionParts(str);
        BinaryOperator bop = InstructionUtils.parseBinaryOperator(parts[1]);
        AggregateUnaryOperator uaggop = InstructionUtils.parseBasicAggregateUnaryOperator(parts[2]);
        byte in1 = Byte.parseByte(parts[3]);
        byte out = Byte.parseByte(parts[4]);
        return new BinUaggChainInstruction(bop, uaggop, in1, out, str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        ArrayList<IndexedMatrixValue> blkList = cachedValues.get(this.input);
        if (blkList == null) {
            return;
        }
        for (IndexedMatrixValue imv : blkList) {
            if (imv == null) continue;
            MatrixIndexes inIx = imv.getIndexes();
            MatrixValue inVal = imv.getValue();
            IndexedMatrixValue iout = cachedValues.holdPlace(this.output, valueClass);
            MatrixIndexes outIx = iout.getIndexes();
            MatrixValue outVal = iout.getValue();
            OperationsOnMatrixValues.performAggregateUnary(inIx, inVal, this._tmpIx, this._tmpVal, this._uaggOp, blockRowFactor, blockColFactor);
            ((MatrixBlock)this._tmpVal).dropLastRowsOrColumns(this._uaggOp.aggOp.correctionLocation);
            OperationsOnMatrixValues.performBinaryIgnoreIndexes(inVal, this._tmpVal, outVal, this._bOp);
            outIx.setIndexes(inIx);
        }
    }
}

