/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.AppendGInstruction;
import org.apache.sysml.runtime.instructions.mr.AppendMInstruction;
import org.apache.sysml.runtime.instructions.mr.AppendRInstruction;
import org.apache.sysml.runtime.instructions.mr.BinaryMRInstructionBase;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class AppendInstruction
extends BinaryMRInstructionBase {
    protected boolean _cbind = true;

    protected AppendInstruction(Operator op, byte in1, byte in2, byte out, boolean cbind, String istr) {
        super(op, in1, in2, out);
        this.instString = istr;
        this.mrtype = MRInstruction.MRINSTRUCTION_TYPE.Append;
        this._cbind = cbind;
    }

    public boolean isCBind() {
        return this._cbind;
    }

    public static AppendInstruction parseInstruction(String str) throws DMLRuntimeException {
        String opcode = InstructionUtils.getOpCode(str);
        if (opcode.equals("mappend")) {
            return AppendMInstruction.parseInstruction(str);
        }
        if (opcode.equals("rappend")) {
            return AppendRInstruction.parseInstruction(str);
        }
        if (opcode.equals("gappend")) {
            return AppendGInstruction.parseInstruction(str);
        }
        throw new DMLRuntimeException("Unsupported append operation code: " + opcode);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int brlen, int bclen) throws DMLRuntimeException {
        throw new DMLRuntimeException("Operations on base append instruction not supported.");
    }
}

