/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import java.util.ArrayList;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.ReduceDiag;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryMRInstructionBase;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.OperationsOnMatrixValues;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class AggregateUnaryInstruction
extends UnaryMRInstructionBase {
    private boolean _dropCorr = false;

    protected AggregateUnaryInstruction(Operator op, byte in, byte out, boolean dropCorr, String istr) {
        super(op, in, out);
        this.mrtype = MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary;
        this.instString = istr;
        this._dropCorr = dropCorr;
    }

    public static AggregateUnaryInstruction parseInstruction(String str) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(str, 3);
        String[] parts = InstructionUtils.getInstructionParts(str);
        String opcode = parts[0];
        byte in = Byte.parseByte(parts[1]);
        byte out = Byte.parseByte(parts[2]);
        boolean drop = Boolean.parseBoolean(parts[3]);
        AggregateUnaryOperator aggun = InstructionUtils.parseBasicAggregateUnaryOperator(opcode);
        return new AggregateUnaryInstruction(aggun, in, out, drop, str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        ArrayList<IndexedMatrixValue> blkList = cachedValues.get(this.input);
        if (blkList != null) {
            for (IndexedMatrixValue in : blkList) {
                if (in == null) continue;
                IndexedMatrixValue out = this.input == this.output ? tempValue : cachedValues.holdPlace(this.output, valueClass);
                MatrixIndexes inix = in.getIndexes();
                if (((AggregateUnaryOperator)this.optr).indexFn instanceof ReduceDiag && inix.getColumnIndex() != inix.getRowIndex()) {
                    out.getValue().reset();
                } else {
                    AggregateUnaryOperator auop = (AggregateUnaryOperator)this.optr;
                    OperationsOnMatrixValues.performAggregateUnary(inix, in.getValue(), out.getIndexes(), out.getValue(), auop, blockRowFactor, blockColFactor);
                    if (this._dropCorr) {
                        ((MatrixBlock)out.getValue()).dropLastRowsOrColumns(auop.aggOp.correctionLocation);
                    }
                }
                if (out != tempValue) continue;
                cachedValues.add(this.output, out);
            }
        }
    }
}

