/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.lops.PartialAggregate;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.functionobjects.ReduceAll;
import org.apache.sysml.runtime.functionobjects.ReduceCol;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysml.runtime.matrix.data.LibMatrixOuterAgg;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.AggregateOperator;
import org.apache.sysml.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;

public class UaggOuterChainCPInstruction
extends UnaryCPInstruction {
    private AggregateUnaryOperator _uaggOp = null;
    private BinaryOperator _bOp = null;

    private UaggOuterChainCPInstruction(BinaryOperator bop, AggregateUnaryOperator uaggop, AggregateOperator aggop, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(bop, in1, in2, out, opcode, istr);
        this._cptype = CPInstruction.CPINSTRUCTION_TYPE.UaggOuterChain;
        this._uaggOp = uaggop;
        this._bOp = bop;
        this.instString = istr;
    }

    public static UaggOuterChainCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("uaggouterchain")) {
            AggregateUnaryOperator uaggop = InstructionUtils.parseBasicAggregateUnaryOperator(parts[1]);
            BinaryOperator bop = InstructionUtils.parseBinaryOperator(parts[2]);
            CPOperand in1 = new CPOperand(parts[3]);
            CPOperand in2 = new CPOperand(parts[4]);
            CPOperand out = new CPOperand(parts[5]);
            String aopcode = InstructionUtils.deriveAggregateOperatorOpcode(parts[1]);
            PartialAggregate.CorrectionLocationType corrLoc = InstructionUtils.deriveAggregateOperatorCorrectionLocation(parts[1]);
            String corrExists = corrLoc != PartialAggregate.CorrectionLocationType.NONE ? "true" : "false";
            AggregateOperator aop = InstructionUtils.parseAggregateOperator(aopcode, corrExists, corrLoc.toString());
            return new UaggOuterChainCPInstruction(bop, uaggop, aop, in1, in2, out, opcode, str);
        }
        throw new DMLRuntimeException("UaggOuterChainCPInstruction.parseInstruction():: Unknown opcode " + opcode);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        boolean rightCached = this._uaggOp.indexFn instanceof ReduceCol || this._uaggOp.indexFn instanceof ReduceAll || !LibMatrixOuterAgg.isSupportedUaggOp(this._uaggOp, this._bOp);
        MatrixBlock mbLeft = null;
        MatrixBlock mbRight = null;
        MatrixBlock mbOut = null;
        if (rightCached) {
            mbLeft = ec.getMatrixInput(this.input1.getName(), this.getExtendedOpcode());
            mbRight = ec.getMatrixInput(this.input2.getName(), this.getExtendedOpcode());
        } else {
            mbLeft = ec.getMatrixInput(this.input2.getName(), this.getExtendedOpcode());
            mbRight = ec.getMatrixInput(this.input1.getName(), this.getExtendedOpcode());
        }
        mbOut = mbLeft.uaggouterchainOperations(mbLeft, mbRight, mbOut, this._bOp, this._uaggOp);
        ec.releaseMatrixInput(this.input1.getName(), this.getExtendedOpcode());
        ec.releaseMatrixInput(this.input2.getName(), this.getExtendedOpcode());
        if (this._uaggOp.aggOp.correctionExists) {
            mbOut.dropLastRowsOrColumns(this._uaggOp.aggOp.correctionLocation);
        }
        String output_name = this.output.getName();
        if (this._uaggOp.indexFn instanceof ReduceAll) {
            DoubleObject ret = null;
            switch (this.output.getValueType()) {
                case DOUBLE: {
                    ret = new DoubleObject(output_name, mbOut.quickGetValue(0, 0));
                    break;
                }
                default: {
                    throw new DMLRuntimeException("Invalid output value type: " + (Object)((Object)this.output.getValueType()));
                }
            }
            ec.setScalarOutput(output_name, ret);
        } else {
            mbOut.examSparsity();
            ec.setMatrixOutput(output_name, mbOut, this.getExtendedOpcode());
        }
    }
}

