/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.codegen.CodegenUtils;
import org.apache.sysml.runtime.codegen.SpoofOperator;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;

public class SpoofCPInstruction
extends ComputationCPInstruction {
    private final Class<?> _class;
    private final SpoofOperator _op;
    private final int _numThreads;
    private final CPOperand[] _in;

    private SpoofCPInstruction(SpoofOperator op, Class<?> cla, int k, CPOperand[] in, CPOperand out, String opcode, String str) {
        super(null, null, null, out, opcode, str);
        this._class = cla;
        this._op = op;
        this._numThreads = k;
        this._in = in;
    }

    public Class<?> getOperatorClass() {
        return this._class;
    }

    public static SpoofCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        ArrayList<CPOperand> inlist = new ArrayList<CPOperand>();
        Class<?> cla = CodegenUtils.getClass(parts[1]);
        SpoofOperator op = CodegenUtils.createInstance(cla);
        String opcode = parts[0] + op.getSpoofType();
        for (int i = 2; i < parts.length - 2; ++i) {
            inlist.add(new CPOperand(parts[i]));
        }
        CPOperand out = new CPOperand(parts[parts.length - 2]);
        int k = Integer.parseInt(parts[parts.length - 1]);
        return new SpoofCPInstruction(op, cla, k, inlist.toArray(new CPOperand[0]), out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        Serializable out;
        ArrayList<MatrixBlock> inputs = new ArrayList<MatrixBlock>();
        ArrayList<ScalarObject> scalars = new ArrayList<ScalarObject>();
        for (CPOperand input : this._in) {
            if (input.getDataType() == Expression.DataType.MATRIX) {
                inputs.add(ec.getMatrixInput(input.getName(), this.getExtendedOpcode()));
                continue;
            }
            if (input.getDataType() != Expression.DataType.SCALAR) continue;
            scalars.add(ec.getScalarInput(input.getName(), input.getValueType(), input.isLiteral()));
        }
        if (this.output.getDataType() == Expression.DataType.MATRIX) {
            out = this._op.execute(inputs, scalars, new MatrixBlock(), this._numThreads);
            ec.setMatrixOutput(this.output.getName(), (MatrixBlock)out, this.getExtendedOpcode());
        } else if (this.output.getDataType() == Expression.DataType.SCALAR) {
            out = this._op.execute(inputs, scalars, this._numThreads);
            ec.setScalarOutput(this.output.getName(), (ScalarObject)out);
        }
        for (CPOperand input : this._in) {
            if (input.getDataType() != Expression.DataType.MATRIX) continue;
            ec.releaseMatrixInput(input.getName(), this.getExtendedOpcode());
        }
    }
}

