/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.functionobjects.DiagIndex;
import org.apache.sysml.runtime.functionobjects.RevIndex;
import org.apache.sysml.runtime.functionobjects.SortIndex;
import org.apache.sysml.runtime.functionobjects.SwapIndex;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.ReorgOperator;

public class ReorgCPInstruction
extends UnaryCPInstruction {
    private CPOperand _col = null;
    private CPOperand _desc = null;
    private CPOperand _ixret = null;

    private ReorgCPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String istr) {
        super(op, in, out, opcode, istr);
        this._cptype = CPInstruction.CPINSTRUCTION_TYPE.Reorg;
    }

    private ReorgCPInstruction(Operator op, CPOperand in, CPOperand col, CPOperand desc, CPOperand ixret, CPOperand out, String opcode, String istr) {
        this(op, in, out, opcode, istr);
        this._col = col;
        this._desc = desc;
        this._ixret = ixret;
    }

    public static ReorgCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        CPOperand in = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand out = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("r'")) {
            InstructionUtils.checkNumFields(str, 2, 3);
            in.split(parts[1]);
            out.split(parts[2]);
            int k = Integer.parseInt(parts[3]);
            return new ReorgCPInstruction(new ReorgOperator(SwapIndex.getSwapIndexFnObject(), k), in, out, opcode, str);
        }
        if (opcode.equalsIgnoreCase("rev")) {
            ReorgCPInstruction.parseUnaryInstruction(str, in, out);
            return new ReorgCPInstruction(new ReorgOperator(RevIndex.getRevIndexFnObject()), in, out, opcode, str);
        }
        if (opcode.equalsIgnoreCase("rdiag")) {
            ReorgCPInstruction.parseUnaryInstruction(str, in, out);
            return new ReorgCPInstruction(new ReorgOperator(DiagIndex.getDiagIndexFnObject()), in, out, opcode, str);
        }
        if (opcode.equalsIgnoreCase("rsort")) {
            InstructionUtils.checkNumFields(parts, 5);
            in.split(parts[1]);
            out.split(parts[5]);
            CPOperand col = new CPOperand(parts[2]);
            CPOperand desc = new CPOperand(parts[3]);
            CPOperand ixret = new CPOperand(parts[4]);
            return new ReorgCPInstruction(new ReorgOperator(SortIndex.getSortIndexFnObject(1, false, false)), in, col, desc, ixret, out, opcode, str);
        }
        throw new DMLRuntimeException("Unknown opcode while parsing a ReorgInstruction: " + str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        MatrixBlock matBlock = ec.getMatrixInput(this.input1.getName(), this.getExtendedOpcode());
        ReorgOperator r_op = (ReorgOperator)this._optr;
        if (r_op.fn instanceof SortIndex) {
            int col = (int)ec.getScalarInput(this._col.getName(), this._col.getValueType(), this._col.isLiteral()).getLongValue();
            boolean desc = ec.getScalarInput(this._desc.getName(), this._desc.getValueType(), this._desc.isLiteral()).getBooleanValue();
            boolean ixret = ec.getScalarInput(this._ixret.getName(), this._ixret.getValueType(), this._ixret.isLiteral()).getBooleanValue();
            r_op.fn = SortIndex.getSortIndexFnObject(col, desc, ixret);
        }
        MatrixBlock soresBlock = (MatrixBlock)matBlock.reorgOperations(r_op, new MatrixBlock(), 0, 0, 0);
        ec.releaseMatrixInput(this.input1.getName(), this.getExtendedOpcode());
        ec.setMatrixOutput(this.output.getName(), soresBlock, this.getExtendedOpcode());
    }
}

