/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.DMLScriptException;
import org.apache.sysml.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContextFactory;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObjectFactory;

public class FunctionCallCPInstruction
extends CPInstruction {
    private String _functionName;
    private String _namespace;
    private ArrayList<CPOperand> _boundInputParamOperands;
    private ArrayList<String> _boundInputParamNames;
    private ArrayList<String> _boundOutputParamNames;

    public String getFunctionName() {
        return this._functionName;
    }

    public String getNamespace() {
        return this._namespace;
    }

    private FunctionCallCPInstruction(String namespace, String functName, ArrayList<CPOperand> boundInParamOperands, ArrayList<String> boundInParamNames, ArrayList<String> boundOutParamNames, String istr) {
        super(null, functName, istr);
        this._cptype = CPInstruction.CPINSTRUCTION_TYPE.External;
        this._functionName = functName;
        this._namespace = namespace;
        this._boundInputParamOperands = boundInParamOperands;
        this._boundInputParamNames = boundInParamNames;
        this._boundOutputParamNames = boundOutParamNames;
    }

    public static FunctionCallCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        int i;
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String namespace = parts[1];
        String functionName = parts[2];
        int numInputs = Integer.valueOf(parts[3]);
        int numOutputs = Integer.valueOf(parts[4]);
        ArrayList<CPOperand> boundInParamOperands = new ArrayList<CPOperand>();
        ArrayList<String> boundInParamNames = new ArrayList<String>();
        ArrayList<String> boundOutParamNames = new ArrayList<String>();
        for (i = 0; i < numInputs; ++i) {
            CPOperand operand = new CPOperand(parts[5 + i]);
            boundInParamOperands.add(operand);
            boundInParamNames.add(operand.getName());
        }
        for (i = 0; i < numOutputs; ++i) {
            boundOutParamNames.add(parts[5 + numInputs + i]);
        }
        return new FunctionCallCPInstruction(namespace, functionName, boundInParamOperands, boundInParamNames, boundOutParamNames, str);
    }

    @Override
    public Instruction preprocessInstruction(ExecutionContext ec) throws DMLRuntimeException {
        Instruction tmp = super.preprocessInstruction(ec);
        if (DMLScript.ENABLE_DEBUG_MODE) {
            ec.handleDebugFunctionEntry((FunctionCallCPInstruction)tmp);
        }
        return tmp;
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Executing instruction : " + this.toString()));
        }
        FunctionProgramBlock fpb = ec.getProgram().getFunctionProgramBlock(this._namespace, this._functionName);
        if (this._boundInputParamNames.size() < fpb.getInputParams().size()) {
            throw new DMLRuntimeException("Number of bound input parameters does not match the function signature (" + this._boundInputParamNames.size() + ", but " + fpb.getInputParams().size() + " expected)");
        }
        LocalVariableMap functionVariables = new LocalVariableMap();
        for (int i = 0; i < fpb.getInputParams().size(); ++i) {
            DataIdentifier currFormalParam = fpb.getInputParams().get(i);
            String currFormalParamName = currFormalParam.getName();
            Data currFormalParamValue = null;
            CPOperand operand = this._boundInputParamOperands.get(i);
            Iterator varname = operand.getName();
            if (!operand.isLiteral() && !ec.containsVariable((String)((Object)varname))) {
                throw new DMLRuntimeException("Input variable '" + (String)((Object)varname) + "' not existing on call of " + DMLProgram.constructFunctionKey(this._namespace, this._functionName) + " (line " + this.getLineNum() + ").");
            }
            Data data = currFormalParamValue = operand.getDataType() != Expression.DataType.SCALAR ? ec.getVariable((String)((Object)varname)) : ec.getScalarInput((String)((Object)varname), operand.getValueType(), operand.isLiteral());
            if (currFormalParamValue.getDataType() == Expression.DataType.SCALAR && currFormalParamValue.getValueType() != operand.getValueType()) {
                ScalarObject so = (ScalarObject)currFormalParamValue;
                currFormalParamValue = ScalarObjectFactory.createScalarObject(operand.getValueType(), so);
            }
            functionVariables.put(currFormalParamName, currFormalParamValue);
        }
        HashMap<String, Boolean> pinStatus = ec.pinVariables(this._boundInputParamNames);
        ExecutionContext fn_ec = ExecutionContextFactory.createContext(false, ec.getProgram());
        if (DMLScript.USE_ACCELERATOR) {
            fn_ec.setGPUContexts(ec.getGPUContexts());
            fn_ec.getGPUContext(0).initializeThread();
        }
        fn_ec.setVariables(functionVariables);
        try {
            fpb._functionName = this._functionName;
            fpb._namespace = this._namespace;
            fpb.execute(fn_ec);
        }
        catch (DMLScriptException e) {
            throw e;
        }
        catch (Exception e) {
            String fname = DMLProgram.constructFunctionKey(this._namespace, this._functionName);
            throw new DMLRuntimeException("error executing function " + fname, e);
        }
        LocalVariableMap retVars = fn_ec.getVariables();
        LinkedList<String> retVarnames = new LinkedList<String>(retVars.keySet());
        HashSet<String> probeVars = new HashSet<String>();
        for (DataIdentifier di : fpb.getOutputParams()) {
            probeVars.add(di.getName());
        }
        for (String var : retVarnames) {
            Data dat;
            if (probeVars.contains(var) || (dat = fn_ec.removeVariable(var)) == null || !(dat instanceof MatrixObject)) continue;
            fn_ec.cleanupMatrixObject((MatrixObject)dat);
        }
        ec.unpinVariables(this._boundInputParamNames, pinStatus);
        for (int i = 0; i < fpb.getOutputParams().size(); ++i) {
            String boundVarName = this._boundOutputParamNames.get(i);
            Data boundValue = retVars.get(fpb.getOutputParams().get(i).getName());
            if (boundValue == null) {
                throw new DMLRuntimeException(boundVarName + " was not assigned a return value");
            }
            Data exdata = ec.removeVariable(boundVarName);
            if (exdata != null && exdata instanceof MatrixObject && exdata != boundValue) {
                ec.cleanupMatrixObject((MatrixObject)exdata);
            }
            if (boundValue instanceof MatrixObject) {
                ((MatrixObject)boundValue).setVarName(boundVarName);
            }
            ec.setVariable(boundVarName, boundValue);
        }
    }

    @Override
    public void postprocessInstruction(ExecutionContext ec) throws DMLRuntimeException {
        if (DMLScript.ENABLE_DEBUG_MODE) {
            ec.handleDebugFunctionExit(this);
        }
        super.postprocessInstruction(ec);
    }

    @Override
    public void printMe() {
        LOG.debug((Object)("ExternalBuiltInFunction: " + this.toString()));
    }

    @Override
    public String getGraphString() {
        return "ExtBuiltinFunc: " + this._functionName;
    }

    public ArrayList<String> getBoundInputParamNames() {
        return this._boundInputParamNames;
    }

    public ArrayList<String> getBoundOutputParamNames() {
        return this._boundOutputParamNames;
    }

    public void setFunctionName(String fname) {
        String oldfname = this._functionName;
        this.instString = this.updateInstStringFunctionName(oldfname, fname);
        this._functionName = fname;
        this.instOpcode = fname;
    }

    public String updateInstStringFunctionName(String pattern, String replace) {
        String[] parts = this.instString.split("\u00b0");
        if (parts[3].equals(pattern)) {
            parts[3] = replace;
        }
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            sb.append(part);
            sb.append("\u00b0");
        }
        return sb.substring(0, sb.length() - "\u00b0".length());
    }
}

