/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.cp.AppendCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.operators.Operator;

public final class FrameAppendCPInstruction
extends AppendCPInstruction {
    protected FrameAppendCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, AppendCPInstruction.AppendType type, String opcode, String istr) {
        super(op, in1, in2, in3, out, type, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        FrameBlock fin1 = ec.getFrameInput(this.input1.getName());
        FrameBlock fin2 = ec.getFrameInput(this.input2.getName());
        if (this._type == AppendCPInstruction.AppendType.CBIND && fin1.getNumRows() != fin2.getNumRows()) {
            throw new DMLRuntimeException("Append-cbind is not possible for input matrices " + this.input1.getName() + " and " + this.input2.getName() + " with different number of rows: " + fin1.getNumRows() + " vs " + fin2.getNumRows());
        }
        if (this._type == AppendCPInstruction.AppendType.RBIND && fin1.getNumColumns() != fin2.getNumColumns()) {
            throw new DMLRuntimeException("Append-rbind is not possible for input matrices " + this.input1.getName() + " and " + this.input2.getName() + " with different number of columns: " + fin1.getNumColumns() + " vs " + fin2.getNumColumns());
        }
        FrameBlock ret = fin1.appendOperations(fin2, new FrameBlock(), this._type == AppendCPInstruction.AppendType.CBIND);
        ec.setFrameOutput(this.output.getName(), ret);
        ec.releaseFrameInput(this.input1.getName());
        ec.releaseFrameInput(this.input2.getName());
    }
}

